/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.common;

import cn.regionsoft.one.common.HashFunction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class ConsistentHash<T> {
    private final HashFunction hashFunction;
    private final int numberOfReplicas;
    private final SortedMap<Long, T> circle = new TreeMap<Long, T>();

    public ConsistentHash(HashFunction hashFunction, int numberOfReplicas, Collection<T> nodes) {
        this.hashFunction = hashFunction;
        this.numberOfReplicas = numberOfReplicas;
        for (T node : nodes) {
            this.add(node);
        }
    }

    public void add(T node) {
        for (int i = 0; i < this.numberOfReplicas; ++i) {
            this.circle.put(this.hashFunction.hash(node.toString() + i), node);
        }
    }

    public void remove(T node) {
        for (int i = 0; i < this.numberOfReplicas; ++i) {
            this.circle.remove(this.hashFunction.hash(node.toString() + i));
        }
    }

    public T get(Object key) {
        if (this.circle.isEmpty()) {
            return null;
        }
        long hash = this.hashFunction.hash((String)key);
        if (!this.circle.containsKey(hash)) {
            SortedMap<Long, T> tailMap = this.circle.tailMap(hash);
            hash = tailMap.isEmpty() ? this.circle.firstKey().longValue() : tailMap.firstKey().longValue();
        }
        return (T)this.circle.get(hash);
    }

    public long getSize() {
        return this.circle.size();
    }

    public void testBalance() {
        Set<Long> sets = this.circle.keySet();
        TreeSet<Long> sortedSets = new TreeSet<Long>(sets);
        for (Long hashCode : sortedSets) {
            System.out.println(hashCode + "-" + this.circle.get(hashCode));
        }
        System.out.println("----each location 's distance are follows: ----");
        Iterator it = sortedSets.iterator();
        Iterator it2 = sortedSets.iterator();
        if (it2.hasNext()) {
            it2.next();
        }
        while (it.hasNext() && it2.hasNext()) {
            long keyPre = (Long)it.next();
            long keyAfter = (Long)it2.next();
            System.out.println(keyAfter - keyPre);
        }
    }

    public static void main(String[] args) {
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("A");
        nodes.add("B");
        nodes.add("C");
        ConsistentHash consistentHash = new ConsistentHash(new HashFunction(), 2, nodes);
        consistentHash.add("D");
        System.out.println("hash circle size: " + consistentHash.getSize());
        System.out.println("location of each node are follows: ");
        consistentHash.testBalance();
        System.out.println((String)consistentHash.get("A"));
    }
}

