/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.common;

import cn.regionsoft.one.common.Base64;
import cn.regionsoft.one.core.CommonUtil;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AESUtil {
    private static final String TRANSFORMATION = "AES/CBC/PKCS7Padding";

    public static String encrypt(String data, String key, String transformation, String iv) throws Exception {
        byte[] zipedBytes = CommonUtil.gzip(data.getBytes("UTF-8"));
        byte[] encriptedBytes = AESUtil.handle(zipedBytes, key, transformation, iv, true);
        return Base64.byteArrayToBase64(encriptedBytes);
    }

    public static byte[] decrypt(String data, String key, String transformation, String iv) throws Exception {
        byte[] encriptedBytes = Base64.base64ToByteArray(data);
        byte[] zipedBytes = AESUtil.handle(encriptedBytes, key, transformation, iv, false);
        return CommonUtil.ungzip(zipedBytes);
    }

    public static String encryptHex(String data, String key, String transformation, String iv) throws Exception {
        return AESUtil.byteToHex(AESUtil.handle(data.getBytes("UTF-8"), key, transformation, iv, true));
    }

    public static String byteToHex(byte[] bytes) {
        String strHex = "";
        StringBuilder sb = new StringBuilder("");
        for (int n = 0; n < bytes.length; ++n) {
            strHex = Integer.toHexString(bytes[n] & 0xFF);
            sb.append(strHex.length() == 1 ? "0" + strHex : strHex);
        }
        return sb.toString().trim();
    }

    public static byte[] hexToByte(String hex) {
        int m = 0;
        int n = 0;
        int byteLen = hex.length() / 2;
        byte[] ret = new byte[byteLen];
        for (int i = 0; i < byteLen; ++i) {
            m = i * 2 + 1;
            n = m + 1;
            int intVal = Integer.decode("0x" + hex.substring(i * 2, m) + hex.substring(m, n));
            ret[i] = (byte)intVal;
        }
        return ret;
    }

    public static String decryptHex(String data, String key, String transformation, String iv) throws Exception {
        return new String(AESUtil.handle(AESUtil.hexToByte(data), key, transformation, iv, false), "UTF-8");
    }

    private static byte[] handle(byte[] data, String key, String transformation, String iv, boolean isEncrypt) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
        Cipher cipher = Cipher.getInstance(transformation);
        if (iv == null || iv.length() == 0) {
            cipher.init(isEncrypt ? 1 : 2, secretKey);
        } else {
            IvParameterSpec ips = new IvParameterSpec(iv.getBytes("UTF-8"));
            cipher.init(isEncrypt ? 1 : 2, (Key)secretKey, ips);
        }
        return cipher.doFinal(data);
    }

    public static byte[] handle(byte[] data, byte[] key, String transformation, byte[] iv, boolean isEncrypt) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance(transformation);
        if (iv == null || iv.length == 0) {
            cipher.init(isEncrypt ? 1 : 2, secretKey);
        } else {
            IvParameterSpec ips = new IvParameterSpec(iv);
            cipher.init(isEncrypt ? 1 : 2, (Key)secretKey, ips);
        }
        return cipher.doFinal(data);
    }

    public static String encriptCBC(String data, String key, String iv) throws Exception {
        return AESUtil.encrypt(data, key, TRANSFORMATION, iv);
    }

    public static byte[] decriptCBC(String data, String key, String iv) throws Exception {
        return AESUtil.decrypt(data, key, TRANSFORMATION, iv);
    }

    public static void main(String[] args) throws Exception {
        String transformation = TRANSFORMATION;
        String key = "1234123412ABCDEF";
        String iv = "1234123412ABCDEF";
        String data = "asdasdasasdsdasddaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
        String result1 = AESUtil.encrypt(data, key, transformation, iv);
        System.out.println(result1);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

