/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.caches.aop;

import cn.regionsoft.one.caches.CacheThreadData;
import cn.regionsoft.one.caches.CacheThreadHolder;
import cn.regionsoft.one.caches.LocalCacheUtil;
import cn.regionsoft.one.caches.RedisUtil;
import cn.regionsoft.one.caches.annotation.Cache;
import cn.regionsoft.one.common.JsonUtil;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.data.persistence.H2OEntity;
import cn.regionsoft.one.reflect.MethodMeta;
import cn.regionsoft.one.reflect.enums.ReturnClassType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RedisCacheUtil {
    protected static final String PREFIX = "${";
    protected static final String SUFFIX = "}";
    protected static final String OCCUP = "occup_";
    protected static final String ID = "id";
    protected static final String NIL = "nil";
    protected static final String REF = "REF_";
    protected static final String DOLLAR = "$";

    public static Map<Integer, String> getOccupsInfo(String anKey) {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        List<String> occupNameList = CommonUtil.getOccupationParanames(anKey, PREFIX, SUFFIX);
        String occupName = null;
        for (int i = 0; i < occupNameList.size(); ++i) {
            occupName = occupNameList.get(i);
            result.put(i, occupName);
        }
        return result;
    }

    private static Object[] resolveArgs(Cache cacheTag, Object obj, Method method, Object[] args, MethodMeta methodMeta) throws Exception {
        String methodMetaCacheKey = methodMeta.getCacheKey();
        String occupsCacheKey = OCCUP + cacheTag.key() + methodMetaCacheKey;
        Map<Integer, String> cachedOccupsInfoMap = null;
        Object embededCachedOccupsInfo = LocalCacheUtil.get(occupsCacheKey);
        if (embededCachedOccupsInfo != null) {
            cachedOccupsInfoMap = (Map<Integer, String>)embededCachedOccupsInfo;
        } else {
            cachedOccupsInfoMap = RedisCacheUtil.getOccupsInfo(cacheTag.key());
            LocalCacheUtil.put(occupsCacheKey, cachedOccupsInfoMap);
        }
        Object[] filteredArgs = null;
        int occupsCount = cachedOccupsInfoMap.size();
        if (occupsCount > 0) {
            filteredArgs = new Object[occupsCount];
            String embededOccupName = null;
            for (int i = 0; i < occupsCount; ++i) {
                Integer argIndex;
                embededOccupName = cachedOccupsInfoMap.get(i);
                String[] fieldArray = embededOccupName.split("\\.");
                if (fieldArray.length > 1) {
                    argIndex = methodMeta.getParaNames().get(fieldArray[0]);
                    if (argIndex == null) continue;
                    filteredArgs[i] = CommonUtil.getEmbededAttributeValue(args[argIndex], fieldArray);
                    continue;
                }
                argIndex = methodMeta.getParaNames().get(fieldArray[0]);
                filteredArgs[i] = args[argIndex];
            }
        } else {
            filteredArgs = args;
        }
        return new Object[]{filteredArgs, cachedOccupsInfoMap};
    }

    private static String calculateCacheKey(Cache cacheTag, MethodMeta methodMeta, Map<Integer, String> cachedOccupsInfoMap, Object[] filteredArgs) {
        Object tmpVal = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (int i = 0; i < filteredArgs.length; ++i) {
            tmpVal = filteredArgs[i];
            if (tmpVal == null) {
                tmpVal = NIL;
            }
            params.put(cachedOccupsInfoMap.get(i), tmpVal);
        }
        String cachekey = CommonUtil.wrapText(cacheTag.key(), params);
        return cachekey;
    }

    public static Object handleCacheBeforeInvoke(Cache cacheTag, Object obj, Method method, Object[] args) throws Exception {
        String anKey = cacheTag.key();
        MethodMeta methodMeta = CommonUtil.getMethodMeta(obj.getClass(), method);
        Object[] resolveResult = RedisCacheUtil.resolveArgs(cacheTag, obj, method, args, methodMeta);
        Object[] filteredArgs = (Object[])resolveResult[0];
        Map cachedOccupsInfoMap = (Map)resolveResult[1];
        boolean hasValue = false;
        for (Object t : filteredArgs) {
            if (t == null) continue;
            hasValue = true;
            break;
        }
        if (!hasValue) {
            return null;
        }
        String cacheKey = RedisCacheUtil.calculateCacheKey(cacheTag, methodMeta, cachedOccupsInfoMap, filteredArgs);
        List<Object> cachedObject = null;
        if (cacheTag.action() == Cache.Action.GET) {
            String cachedJson = RedisUtil.getAndRefresh(cacheKey);
            if (!CommonUtil.isEmpty(cachedJson)) {
                if (methodMeta.getReturnClassType() == ReturnClassType.LIST) {
                    Type[] typesto = methodMeta.getArgumentsOfReturnClass();
                    if (typesto.length > 0) {
                        Class genClassInList = (Class)typesto[0];
                        cachedObject = JsonUtil.jsonToList(cachedJson, genClassInList);
                    }
                } else if (methodMeta.getReturnClassType() == ReturnClassType.POJO) {
                    cachedObject = (List<Object>)JsonUtil.jsonToBeanDateSerializer(cachedJson, method.getReturnType(), "yyyy-MM-dd HH:mm:ss");
                } else {
                    throw new Exception("return type is not supported for cache :" + methodMeta.getActualReturnClassType());
                }
            }
            if (cachedObject != null) {
                return cachedObject;
            }
        } else if (cacheTag.action() == Cache.Action.REMOVE) {
            if (cacheTag.useRegex()) {
                RedisUtil.delKeysLike(cacheKey);
            } else {
                RedisUtil.delKey(cacheKey);
            }
        } else if (cacheTag.action() == Cache.Action.SELECTIVE_GET) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (filteredArgs[0] != null) {
                Field idField = CommonUtil.getField(filteredArgs[0].getClass(), ID);
                String occupName = methodMeta.getParaNames().keySet().iterator().next();
                if (idField != null) {
                    idField.setAccessible(true);
                    Object idVal = idField.get(filteredArgs[0]);
                    if (idVal != null) {
                        params.put(occupName, idVal);
                        String idCacheKey = CommonUtil.wrapText(anKey, params);
                        String cachedJson = RedisUtil.getAndRefresh(idCacheKey);
                        if (cachedJson != null) {
                            cachedObject = JsonUtil.jsonToBeanDateSerializer(cachedJson, method.getReturnType(), "yyyy-MM-dd HH:mm:ss");
                            return cachedObject;
                        }
                        cacheKey = idCacheKey;
                    } else {
                        String cachedJson;
                        String classKey = CommonUtil.getAllFieldsAsString(filteredArgs[0].getClass());
                        params.put(occupName, REF + classKey);
                        cacheKey = CommonUtil.wrapText(anKey, params);
                        params.clear();
                        Map<String, Field> fieldsMap = CommonUtil.getAllFields(filteredArgs[0].getClass());
                        Iterator<Map.Entry<String, Field>> fieldsIterator = fieldsMap.entrySet().iterator();
                        Map.Entry<String, Field> fieldEntry = null;
                        Field field = null;
                        Object fieldVal = null;
                        while (fieldsIterator.hasNext()) {
                            fieldEntry = fieldsIterator.next();
                            field = fieldEntry.getValue();
                            field.setAccessible(true);
                            fieldVal = field.get(filteredArgs[0]);
                            if (fieldVal == null) {
                                fieldVal = NIL;
                            }
                            params.put(fieldEntry.getKey(), fieldVal);
                        }
                        String cachedIdKey = RedisUtil.getAndRefresh(cacheKey = CommonUtil.wrapText(cacheKey, params));
                        if (cachedIdKey != null && (cachedJson = RedisUtil.getAndRefresh(cachedIdKey)) != null) {
                            cachedObject = JsonUtil.jsonToBeanDateSerializer(cachedJson, method.getReturnType(), "yyyy-MM-dd HH:mm:ss");
                            return cachedObject;
                        }
                    }
                } else {
                    String cachedJson = RedisUtil.getAndRefresh(cacheKey);
                    if (cachedJson != null) {
                        cachedObject = JsonUtil.jsonToBeanDateSerializer(cachedJson, method.getReturnType(), "yyyy-MM-dd HH:mm:ss");
                        return cachedObject;
                    }
                }
            }
        }
        CacheThreadData cacheThreadData = CacheThreadHolder.getInstance().getCacheThreadData();
        cacheThreadData.put(cacheKey, cacheTag);
        return null;
    }

    public static Object handleCacheAfterInvoke(Object obj, Method method, Object[] args, Object result) throws Exception {
        CacheThreadData cacheThreadData = CacheThreadHolder.getInstance().getCacheThreadData();
        if (result == null) {
            return null;
        }
        Iterator<Map.Entry<String, Cache>> iterator = cacheThreadData.iterator();
        Map.Entry<String, Cache> tmpEntry = null;
        String cacheKey = null;
        Cache cacheTag = null;
        while (iterator.hasNext()) {
            MethodMeta methodMeta;
            Object idVal;
            Field idField;
            tmpEntry = iterator.next();
            cacheKey = tmpEntry.getKey();
            cacheTag = tmpEntry.getValue();
            if (cacheTag.action() == Cache.Action.GET) {
                String objectJson = JsonUtil.objectToJsonDateSerializer(result, "yyyy-MM-dd HH:mm:ss");
                RedisCacheUtil.setCache(cacheKey, objectJson, cacheTag.expireSeconds());
                continue;
            }
            if (cacheTag.action() == Cache.Action.PUT) {
                idField = CommonUtil.getField(method.getReturnType(), ID);
                if (idField != null) {
                    idField.setAccessible(true);
                    idVal = idField.get(result);
                    methodMeta = CommonUtil.getMethodMeta(obj.getClass(), method);
                    Object[] resolveResult = RedisCacheUtil.resolveArgs(cacheTag, obj, method, args, methodMeta);
                    Object[] filteredArgs = (Object[])resolveResult[0];
                    Map cachedOccupsInfoMap = (Map)resolveResult[1];
                    cacheKey = RedisCacheUtil.calculateCacheKey(cacheTag, methodMeta, cachedOccupsInfoMap, filteredArgs);
                }
                String objectJson = JsonUtil.objectToJsonDateSerializer(result, "yyyy-MM-dd HH:mm:ss");
                RedisCacheUtil.setCache(cacheKey, objectJson, cacheTag.expireSeconds());
                continue;
            }
            if (cacheTag.action() != Cache.Action.SELECTIVE_GET || (idField = CommonUtil.getField(method.getReturnType(), ID)) == null) continue;
            idField.setAccessible(true);
            idVal = idField.get(result);
            methodMeta = CommonUtil.getMethodMeta(obj.getClass(), method);
            Map<String, Integer> paraNames = methodMeta.getParaNames();
            Iterator<Map.Entry<String, Integer>> paraNamesIterator = paraNames.entrySet().iterator();
            String idOccupName = paraNamesIterator.next().getKey();
            String objectJson = JsonUtil.objectToJsonDateSerializer(result, "yyyy-MM-dd HH:mm:ss");
            if (idVal != null) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(idOccupName, idVal);
                String idCacheKey = CommonUtil.wrapText(cacheTag.key(), params);
                RedisCacheUtil.setCache(idCacheKey, objectJson, cacheTag.expireSeconds());
                if (cacheKey.equals(idCacheKey)) continue;
                RedisCacheUtil.setCache(cacheKey, idCacheKey, cacheTag.expireSeconds());
                continue;
            }
            RedisCacheUtil.setCache(cacheKey, objectJson, cacheTag.expireSeconds());
        }
        return null;
    }

    private static void setCache(String cacheKey, String value, int expireSeconds) {
        if (expireSeconds == 0) {
            RedisUtil.setWithExpire(cacheKey, value);
        } else if (expireSeconds < 0) {
            RedisUtil.set(cacheKey, value);
        } else {
            RedisUtil.set(cacheKey, value, expireSeconds);
        }
    }

    public static void putEntityReferenceCache(H2OEntity reference, H2OEntity entityToCache) throws Exception {
        Class<?> entityClass = reference.getClass();
        if (entityClass != entityToCache.getClass()) {
            throw new Exception("Type is not matched");
        }
        Field idField = CommonUtil.getField(entityClass, ID);
        if (idField == null) {
            throw new Exception("No ID field found");
        }
        idField.setAccessible(true);
        Object idVal = idField.get(entityToCache);
        if (idVal == null) {
            throw new Exception("id of entityToCache is null");
        }
        String classKey = CommonUtil.getAllFieldsAsString(entityClass);
        String prefix = entityClass.getSimpleName() + ":" + REF;
        String refCacheKeyOccups = prefix + classKey;
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map<String, Field> fieldsMap = CommonUtil.getAllFields(entityClass);
        Iterator<Map.Entry<String, Field>> fieldsIterator = fieldsMap.entrySet().iterator();
        Map.Entry<String, Field> fieldEntry = null;
        Field field = null;
        Object fieldVal = null;
        while (fieldsIterator.hasNext()) {
            fieldEntry = fieldsIterator.next();
            field = fieldEntry.getValue();
            field.setAccessible(true);
            fieldVal = field.get(reference);
            if (fieldVal == null) {
                fieldVal = NIL;
            }
            params.put(fieldEntry.getKey(), fieldVal);
        }
        String refCacheKey = CommonUtil.wrapText(refCacheKeyOccups, params);
        String idCacheKey = entityClass.getSimpleName() + ":" + idVal;
        String objectJson = JsonUtil.objectToJson(entityToCache);
        HashMap<String, String> valueToCache = new HashMap<String, String>();
        valueToCache.put(idCacheKey, objectJson);
        valueToCache.put(refCacheKey, idCacheKey);
        RedisUtil.setTranMapWithExpire(valueToCache);
    }
}

