/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.caches.aop;

import cn.regionsoft.one.caches.CacheThreadHolder;
import cn.regionsoft.one.caches.RedisUtil;
import cn.regionsoft.one.caches.annotation.Cache;
import cn.regionsoft.one.caches.annotation.Caches;
import cn.regionsoft.one.caches.aop.RedisCacheUtil;
import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.H2OContext;
import cn.regionsoft.one.core.aop.AnnotationListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class CachesListener
implements AnnotationListener {
    private static final Logger logger = Logger.getLogger(CachesListener.class);

    @Override
    public Class<? extends Annotation> targetAnnotation() {
        return Caches.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object beforeInvoke(Object obj, Method method, Object[] args, H2OContext h2oContext) {
        CacheThreadHolder.getInstance().getCacheThreadData().pushStack();
        if (!RedisUtil.isInited()) {
            return null;
        }
        try {
            Caches caches = method.getAnnotation(Caches.class);
            Cache[] cacheArray = caches.value();
            Object resultObj = null;
            for (Cache cacheTag : cacheArray) {
                Object tmp = RedisCacheUtil.handleCacheBeforeInvoke(cacheTag, obj, method, args);
                if (resultObj == null || tmp == null) continue;
                resultObj = tmp;
            }
            Cache[] cacheArray2 = resultObj;
            return cacheArray2;
        }
        catch (Throwable ex) {
            logger.error(ex);
            Object var6_8 = null;
            return var6_8;
        }
    }

    @Override
    public Object afterInvoke(Object obj, Method method, Object[] args, Object result, H2OContext h2oContext) {
        try {
            RedisCacheUtil.handleCacheAfterInvoke(obj, method, args, result);
            return null;
        }
        catch (Throwable ex) {
            logger.error(ex);
            return null;
        }
    }

    @Override
    public void exceptionInvoke(Throwable e, H2OContext context) {
    }

    @Override
    public void finalInvoke(Object obj, Method method, Object[] args, Object result, H2OContext context) {
        CacheThreadHolder.getInstance().getCacheThreadData().popStack();
    }
}

