/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.caches;

import cn.regionsoft.one.caches.EmptyJedis;
import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.properties.ConfigUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPipeline;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.util.Hashing;
import redis.clients.jedis.util.Sharded;

public class RedisUtil {
    public static Logger logger;
    private static volatile boolean inited;
    private static ShardedJedisPool shardedJedisPool;

    public static boolean isInited() {
        return inited;
    }

    public static ShardedJedisPool pool() {
        return shardedJedisPool;
    }

    public static void init() {
    }

    public static boolean constainKey(final String key) {
        return (Boolean)new Executor<Boolean>(){

            @Override
            Boolean execute() {
                return this.shardedJedis.exists(key);
            }
        }.getResult();
    }

    public static Long expire(final String key, final int expire) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                return this.shardedJedis.expire(key, expire);
            }
        }.getResult();
    }

    public static String set(final String key, final String value, final int expire) {
        return (String)new Executor<String>(){

            @Override
            String execute() {
                return this.shardedJedis.setex(key, expire, value);
            }
        }.getResult();
    }

    public static Boolean setLong(final String key, final long value, final int seconds) {
        return (Boolean)new Executor<Boolean>(){

            @Override
            Boolean execute() {
                try {
                    Jedis jedis = (Jedis)this.shardedJedis.getShard(key);
                    Transaction transaction = jedis.multi();
                    transaction.set(key, value + "");
                    transaction.expire(key, seconds);
                    transaction.exec();
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.getResult();
    }

    public static Boolean setLong(final String key, final long value) {
        return (Boolean)new Executor<Boolean>(){

            @Override
            Boolean execute() {
                try {
                    this.shardedJedis.set(key, value + "");
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.getResult();
    }

    public static String setWithExpire(final String key, final String value) {
        return (String)new Executor<String>(){

            @Override
            String execute() {
                return this.shardedJedis.setex(key, Integer.parseInt(ConfigUtil.getProperty("redis.expire.default", "360000")), value);
            }
        }.getResult();
    }

    public static List<String> setTranMapWithExpire(final Map<String, String> map) {
        return (List)new Executor<List<String>>(){

            @Override
            List<String> execute() {
                if (map.size() == 0) {
                    return null;
                }
                ShardedJedisPipeline pipeline = this.shardedJedis.pipelined();
                Iterator iterator = map.entrySet().iterator();
                Map.Entry tmpEntry = null;
                ArrayList<Response> responses = new ArrayList<Response>(map.size());
                ArrayList<String> result = new ArrayList<String>(map.size());
                while (iterator.hasNext()) {
                    tmpEntry = iterator.next();
                    responses.add(pipeline.setex((String)tmpEntry.getKey(), Integer.parseInt(ConfigUtil.getProperty("redis.expire.default", "360000")), (String)tmpEntry.getValue()));
                }
                pipeline.sync();
                for (Response resp : responses) {
                    result.add((String)resp.get());
                }
                return result;
            }
        }.getResult();
    }

    public static String set(final String key, final String value) {
        return (String)new Executor<String>(){

            @Override
            String execute() {
                return this.shardedJedis.set(key, value);
            }
        }.getResult();
    }

    public static Long setIfNotExists(final String key, final String value) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                return this.shardedJedis.setnx(key, value);
            }
        }.getResult();
    }

    public static String get(final String key) {
        return (String)new Executor<String>(){

            @Override
            String execute() {
                return this.shardedJedis.get(key);
            }
        }.getResult();
    }

    public static String getAndRefresh(final String key) {
        return (String)new Executor<String>(){

            @Override
            String execute() {
                ShardedJedisPipeline pipeline = this.shardedJedis.pipelined();
                Response response = pipeline.get(key);
                pipeline.expire(key, Integer.parseInt(ConfigUtil.getProperty("redis.expire.default", "360000")));
                pipeline.sync();
                return (String)response.get();
            }
        }.getResult();
    }

    public static long genId(final String key) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                long id = this.shardedJedis.incr(key);
                if (id + 75807L >= Long.MAX_VALUE) {
                    this.shardedJedis.getSet(key, "0");
                }
                return id;
            }
        }.getResult();
    }

    public static long incrBy(final String key, final int increment) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                return this.shardedJedis.incrBy(key, (long)increment);
            }
        }.getResult();
    }

    public static long decrBy(final String key, final int decrement) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                return this.shardedJedis.decrBy(key, (long)decrement);
            }
        }.getResult();
    }

    public static long delKeysLike(final String likeKey) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                Collection shardedJedisC = this.shardedJedis.getAllShards();
                Iterator iter = shardedJedisC.iterator();
                long count = 0L;
                while (iter.hasNext()) {
                    Jedis jedis = (Jedis)iter.next();
                    Set keys = jedis.keys(likeKey);
                    if (keys.size() <= 0) continue;
                    count += jedis.del(keys.toArray(new String[keys.size()])).longValue();
                }
                return count;
            }
        }.getResult();
    }

    public static Long delKey(final String key) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                return this.shardedJedis.del(key);
            }
        }.getResult();
    }

    public static Long delKeys(final String[] keys) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                Collection shardedJedisC = this.shardedJedis.getAllShards();
                Iterator iter = shardedJedisC.iterator();
                long count = 0L;
                while (iter.hasNext()) {
                    Jedis jedis = (Jedis)iter.next();
                    count += jedis.del(keys).longValue();
                }
                return count;
            }
        }.getResult();
    }

    public static List<Object> batchSet(final List<Pair<String, String>> pairs) {
        return (List)new Executor<List<Object>>(){

            @Override
            List<Object> execute() {
                ShardedJedisPipeline pipeline = this.shardedJedis.pipelined();
                for (Pair pair : pairs) {
                    pipeline.set((String)pair.getKey(), (String)pair.getValue());
                }
                return pipeline.syncAndReturnAll();
            }
        }.getResult();
    }

    public static List<String> batchGet(final String[] keys) {
        return (List)new Executor<List<String>>(){

            @Override
            List<String> execute() {
                ShardedJedisPipeline pipeline = this.shardedJedis.pipelined();
                ArrayList<String> result = new ArrayList<String>(keys.length);
                ArrayList<Response> responses = new ArrayList<Response>(keys.length);
                for (String key : keys) {
                    responses.add(pipeline.get(key));
                }
                pipeline.sync();
                for (Response resp : responses) {
                    result.add((String)resp.get());
                }
                return result;
            }
        }.getResult();
    }

    public static Long hashSet(final String key, final String field, final String value) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                return this.shardedJedis.hset(key, field, value);
            }
        }.getResult();
    }

    public static Long hashDelete(final String key, final String ... fields) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                return this.shardedJedis.hdel(key, fields);
            }
        }.getResult();
    }

    public static Long hashSet(final String key, final String field, final String value, final int expire) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                Pipeline pipeline = ((Jedis)this.shardedJedis.getShard(key)).pipelined();
                Response result = pipeline.hset(key, field, value);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (Long)result.get();
            }
        }.getResult();
    }

    public static String hashGet(final String key, final String field) {
        return (String)new Executor<String>(){

            @Override
            String execute() {
                return this.shardedJedis.hget(key, field);
            }
        }.getResult();
    }

    public static String hashGet(final String key, final String field, final int expire) {
        return (String)new Executor<String>(){

            @Override
            String execute() {
                Pipeline pipeline = ((Jedis)this.shardedJedis.getShard(key)).pipelined();
                Response result = pipeline.hget(key, field);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (String)result.get();
            }
        }.getResult();
    }

    public static String hashMultipleSet(final String key, final Map<String, String> hash) {
        return (String)new Executor<String>(){

            @Override
            String execute() {
                if (hash.size() == 0) {
                    return "0";
                }
                return this.shardedJedis.hmset(key, hash);
            }
        }.getResult();
    }

    public static ScanResult<Map.Entry<String, String>> hashScan(final String key, final String cursor, final ScanParams scanParams) {
        return (ScanResult)new Executor<ScanResult<Map.Entry<String, String>>>(){

            @Override
            ScanResult<Map.Entry<String, String>> execute() {
                return this.shardedJedis.hscan(key, cursor, scanParams);
            }
        }.getResult();
    }

    public static ScanResult<Map.Entry<String, String>> hashScan(final String key, final int adviceReturnCount) {
        return (ScanResult)new Executor<ScanResult<Map.Entry<String, String>>>(){

            @Override
            ScanResult<Map.Entry<String, String>> execute() {
                ScanParams scanParams = new ScanParams();
                scanParams = scanParams.count(Integer.valueOf(adviceReturnCount));
                return this.shardedJedis.hscan(key, ScanParams.SCAN_POINTER_START, scanParams);
            }
        }.getResult();
    }

    public static String hashMultipleSet(final String key, final Map<String, String> hash, final int expire) {
        return (String)new Executor<String>(){

            @Override
            String execute() {
                Pipeline pipeline = ((Jedis)this.shardedJedis.getShard(key)).pipelined();
                Response result = pipeline.hmset(key, hash);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (String)result.get();
            }
        }.getResult();
    }

    public static List<String> hashMultipleGet(final String key, final String ... fields) {
        return (List)new Executor<List<String>>(){

            @Override
            List<String> execute() {
                return this.shardedJedis.hmget(key, fields);
            }
        }.getResult();
    }

    public static List<String> hashMultipleGet(final String key, final int expire, final String ... fields) {
        return (List)new Executor<List<String>>(){

            @Override
            List<String> execute() {
                Pipeline pipeline = ((Jedis)this.shardedJedis.getShard(key)).pipelined();
                Response result = pipeline.hmget(key, fields);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (List)result.get();
            }
        }.getResult();
    }

    public static List<Object> batchHashMultipleSet(final List<Pair<String, Map<String, String>>> pairs) {
        return (List)new Executor<List<Object>>(){

            @Override
            List<Object> execute() {
                ShardedJedisPipeline pipeline = this.shardedJedis.pipelined();
                for (Pair pair : pairs) {
                    pipeline.hmset((String)pair.getKey(), (Map)pair.getValue());
                }
                return pipeline.syncAndReturnAll();
            }
        }.getResult();
    }

    public static List<Object> batchHashMultipleSet(final Map<String, Map<String, String>> data) {
        return (List)new Executor<List<Object>>(){

            @Override
            List<Object> execute() {
                ShardedJedisPipeline pipeline = this.shardedJedis.pipelined();
                for (Map.Entry iter : data.entrySet()) {
                    pipeline.hmset((String)iter.getKey(), (Map)iter.getValue());
                }
                return pipeline.syncAndReturnAll();
            }
        }.getResult();
    }

    public static List<List<String>> batchHashMultipleGet(final List<Pair<String, String[]>> pairs) {
        return (List)new Executor<List<List<String>>>(){

            @Override
            List<List<String>> execute() {
                ShardedJedisPipeline pipeline = this.shardedJedis.pipelined();
                ArrayList<List<String>> result = new ArrayList<List<String>>(pairs.size());
                ArrayList<Response> responses = new ArrayList<Response>(pairs.size());
                for (Pair pair : pairs) {
                    responses.add(pipeline.hmget((String)pair.getKey(), (String[])pair.getValue()));
                }
                pipeline.sync();
                for (Response resp : responses) {
                    result.add((List<String>)resp.get());
                }
                return result;
            }
        }.getResult();
    }

    public static Map<String, String> hashGetAll(final String key) {
        return (Map)new Executor<Map<String, String>>(){

            @Override
            Map<String, String> execute() {
                return this.shardedJedis.hgetAll(key);
            }
        }.getResult();
    }

    public static Map<String, String> hashGetAll(final String key, final int expire) {
        return (Map)new Executor<Map<String, String>>(){

            @Override
            Map<String, String> execute() {
                Pipeline pipeline = ((Jedis)this.shardedJedis.getShard(key)).pipelined();
                Response result = pipeline.hgetAll(key);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (Map)result.get();
            }
        }.getResult();
    }

    public static List<Map<String, String>> batchHashGetAll(final String ... keys) {
        return (List)new Executor<List<Map<String, String>>>(){

            @Override
            List<Map<String, String>> execute() {
                ShardedJedisPipeline pipeline = this.shardedJedis.pipelined();
                ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(keys.length);
                ArrayList<Response> responses = new ArrayList<Response>(keys.length);
                for (String key : keys) {
                    responses.add(pipeline.hgetAll(key));
                }
                pipeline.sync();
                for (Response resp : responses) {
                    result.add((Map<String, String>)resp.get());
                }
                return result;
            }
        }.getResult();
    }

    public static Map<String, Map<String, String>> batchHashGetAllForMap(final String ... keys) {
        return (Map)new Executor<Map<String, Map<String, String>>>(){

            @Override
            Map<String, Map<String, String>> execute() {
                ShardedJedisPipeline pipeline = this.shardedJedis.pipelined();
                int capacity = 1;
                while ((int)((double)capacity * 0.75) <= keys.length) {
                    capacity <<= 1;
                }
                HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(capacity);
                ArrayList<Response> responses = new ArrayList<Response>(keys.length);
                for (String key : keys) {
                    responses.add(pipeline.hgetAll(key));
                }
                pipeline.sync();
                for (int i = 0; i < keys.length; ++i) {
                    result.put(keys[i], (Map<String, String>)((Response)responses.get(i)).get());
                }
                return result;
            }
        }.getResult();
    }

    public static Long listPushTail(final String key, final String ... values) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                return this.shardedJedis.rpush(key, values);
            }
        }.getResult();
    }

    public static Long listPush(final String key, final String value) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                return this.shardedJedis.lpush(key, new String[]{value});
            }
        }.getResult();
    }

    public static Long listPushAndTrim(final String key, final String value, final long size) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                Pipeline pipeline = ((Jedis)this.shardedJedis.getShard(key)).pipelined();
                Response result = pipeline.lpush(key, new String[]{value});
                pipeline.ltrim(key, 0L, size - 1L);
                pipeline.sync();
                return (Long)result.get();
            }
        }.getResult();
    }

    public static Object updateListInTransaction(final String key, final List<String> values) {
        return new Executor<Object>(){

            @Override
            Object execute() {
                Transaction transaction = ((Jedis)this.shardedJedis.getShard(key)).multi();
                transaction.del(key);
                for (String value : values) {
                    transaction.rpush(key, new String[]{value});
                }
                transaction.exec();
                return null;
            }
        }.getResult();
    }

    public static List<String> listGetAll(final String key) {
        return (List)new Executor<List<String>>(){

            @Override
            List<String> execute() {
                return this.shardedJedis.lrange(key, 0L, -1L);
            }
        }.getResult();
    }

    public static List<String> listRange(final String key, final long beginIndex, final long endIndex) {
        return (List)new Executor<List<String>>(){

            @Override
            List<String> execute() {
                return this.shardedJedis.lrange(key, beginIndex, endIndex - 1L);
            }
        }.getResult();
    }

    public static Map<String, List<String>> batchGetAllList(final List<String> keys) {
        return (Map)new Executor<Map<String, List<String>>>(){

            @Override
            Map<String, List<String>> execute() {
                ShardedJedisPipeline pipeline = this.shardedJedis.pipelined();
                HashMap<String, List<String>> result = new HashMap<String, List<String>>();
                ArrayList<Response> responses = new ArrayList<Response>(keys.size());
                for (String key : keys) {
                    responses.add(pipeline.lrange(key, 0L, -1L));
                }
                pipeline.sync();
                for (int i = 0; i < keys.size(); ++i) {
                    result.put((String)keys.get(i), (List<String>)((Response)responses.get(i)).get());
                }
                return result;
            }
        }.getResult();
    }

    public static String lpoppush(final String key) {
        return (String)new Executor<String>(){

            @Override
            String execute() {
                if (!this.shardedJedis.exists(key).booleanValue()) {
                    return null;
                }
                return this.shardedJedis.lpop(key);
            }
        }.getResult();
    }

    public static Long publish(final String channel, final String message) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                Jedis jedis = (Jedis)this.shardedJedis.getShard(channel);
                return jedis.publish(channel, message);
            }
        }.getResult();
    }

    public static void subscribe(final JedisPubSub shardedJedisPubSub, final String channel) {
        new Executor<Object>(){

            @Override
            Object execute() {
                Jedis jedis = (Jedis)this.shardedJedis.getShard(channel);
                jedis.subscribe(shardedJedisPubSub, new String[]{channel});
                return null;
            }
        }.getResult();
    }

    public static void unSubscribe(JedisPubSub shardedJedisPubSub) {
        shardedJedisPubSub.unsubscribe();
    }

    public static Long addSortedSet(final String key, final double score, final String member) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                return this.shardedJedis.zadd(key, score, member);
            }
        }.getResult();
    }

    public static Long addSortedSetWithMap(final String key, final Map<String, Double> scoreMembers) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                if (scoreMembers.size() == 0) {
                    return 0L;
                }
                return this.shardedJedis.zadd(key, scoreMembers);
            }
        }.getResult();
    }

    public static Long deleteSortedSet(final String key, final String ... members) {
        return (Long)new Executor<Long>(){

            @Override
            Long execute() {
                return this.shardedJedis.zrem(key, members);
            }
        }.getResult();
    }

    public static Double getScoreFromSortedSet(final String key, final String member) {
        return (Double)new Executor<Double>(){

            @Override
            Double execute() {
                return this.shardedJedis.zscore(key, member);
            }
        }.getResult();
    }

    public static Set<String> getSortedSet(final String key, final Double min, final Double max, final int count) {
        return (Set)new Executor<Set<String>>(){

            @Override
            Set<String> execute() {
                return this.shardedJedis.zrangeByScore(key, min.doubleValue(), max.doubleValue(), 0, count);
            }
        }.getResult();
    }

    public static LinkedHashSet<Tuple> getSortedSetWithScores(final String key, final Double min, final Double max, final int count) {
        return (LinkedHashSet)new Executor<LinkedHashSet<Tuple>>(){

            @Override
            LinkedHashSet<Tuple> execute() {
                Set result = this.shardedJedis.zrangeByScoreWithScores(key, min.doubleValue(), max.doubleValue(), 0, count);
                if (result.size() == 0) {
                    return new LinkedHashSet<Tuple>();
                }
                return (LinkedHashSet)result;
            }
        }.getResult();
    }

    public static LinkedHashSet<Tuple> getRevertSortedSetWithScores(final String key, final Double max, final Double min, final int count) {
        return (LinkedHashSet)new Executor<LinkedHashSet<Tuple>>(){

            @Override
            LinkedHashSet<Tuple> execute() {
                System.out.println(1);
                Set result = this.shardedJedis.zrevrangeByScoreWithScores(key, max.doubleValue(), min.doubleValue(), 0, count);
                if (result.size() == 0) {
                    return new LinkedHashSet<Tuple>();
                }
                return (LinkedHashSet)result;
            }
        }.getResult();
    }

    public static Set<String> revrangeByScoreWithSortedSet(final String key, final double max, final double min) {
        return (Set)new Executor<Set<String>>(){

            @Override
            Set<String> execute() {
                return this.shardedJedis.zrevrangeByScore(key, max, min);
            }
        }.getResult();
    }

    public static String delAtomic(final String key) {
        return (String)new Executor<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            String execute() {
                Jedis jedis = (Jedis)this.shardedJedis.getShard(key);
                try {
                    jedis.watch(new String[]{key});
                    Transaction transaction = jedis.multi();
                    transaction.get(key);
                    transaction.del(key);
                    List resutList = transaction.exec();
                    if (resutList != null) {
                        String string = (String)resutList.get(0);
                        return string;
                    }
                    String string = null;
                    return string;
                }
                finally {
                    jedis.unwatch();
                }
            }
        }.getResult();
    }

    public static Boolean tryGetDistributedLock(final String key, final int expireSeconds) {
        return (Boolean)new Executor<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Boolean execute() {
                Jedis jedis = (Jedis)this.shardedJedis.getShard(key);
                try {
                    jedis.watch(new String[]{key});
                    if (jedis.exists(key).booleanValue()) {
                        Boolean bl = false;
                        return bl;
                    }
                    Transaction transaction = jedis.multi();
                    transaction.setnx(key, "-");
                    transaction.expire(key, expireSeconds);
                    List resutList = transaction.exec();
                    if (resutList != null) {
                        Boolean bl = true;
                        return bl;
                    }
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    jedis.unwatch();
                }
            }
        }.getResult();
    }

    public static Boolean tryReleaseDistributedLock(final String key) {
        return (Boolean)new Executor<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Boolean execute() {
                Jedis jedis = (Jedis)this.shardedJedis.getShard(key);
                try {
                    jedis.watch(new String[]{key});
                    Transaction transaction = jedis.multi();
                    transaction.del(key);
                    List resutList = transaction.exec();
                    if (resutList != null) {
                        Boolean bl = true;
                        return bl;
                    }
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    jedis.unwatch();
                }
            }
        }.getResult();
    }

    static /* synthetic */ ShardedJedisPool access$000() {
        return shardedJedisPool;
    }

    static {
        String redisHost;
        logger = Logger.getLogger(RedisUtil.class);
        inited = false;
        boolean enableRedis = Boolean.valueOf(ConfigUtil.getProperty("redis.enabled"));
        if (enableRedis && !CommonUtil.isEmpty(redisHost = ConfigUtil.getProperty("redis.host"))) {
            try {
                logger.debug("redis configuration found.");
                logger.debug("redis initing...");
                JedisPoolConfig config = new JedisPoolConfig();
                config.setTestOnBorrow(true);
                config.setMaxIdle(Integer.valueOf(ConfigUtil.getProperty("redis.max.idle", "8")).intValue());
                config.setMaxWaitMillis((long)Integer.valueOf(ConfigUtil.getProperty("redis.max.waitmillis", "60000")).intValue());
                config.setMinIdle(Integer.valueOf(ConfigUtil.getProperty("redis.min.idle", "1")).intValue());
                config.setMaxTotal(Integer.valueOf(ConfigUtil.getProperty("redis.max.total", "8")).intValue());
                int dbIndex = Integer.valueOf(ConfigUtil.getProperty("redis.db", "0"));
                String[] hostsArray = redisHost.split(",");
                ArrayList<JedisShardInfo> redisNodeList = new ArrayList<JedisShardInfo>();
                for (String host : hostsArray) {
                    JedisShardInfo redisNode = new JedisShardInfo(URI.create("redis://" + host + "/" + dbIndex));
                    redisNode.setPassword(ConfigUtil.getProperty("redis.password"));
                    redisNodeList.add(redisNode);
                }
                shardedJedisPool = new ShardedJedisPool((GenericObjectPoolConfig)config, redisNodeList, Hashing.MURMUR_HASH, Sharded.DEFAULT_KEY_TAG_PATTERN);
                RedisUtil.constainKey("test");
                logger.debug("redis inited...");
                inited = true;
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
    }

    static abstract class Executor<T> {
        ShardedJedis shardedJedis = RedisUtil.access$000() != null ? RedisUtil.access$000().getResource() : new EmptyJedis(null);

        abstract T execute();

        public T getResult() {
            T result = null;
            try {
                result = this.execute();
            }
            catch (Throwable e) {
                throw new RuntimeException("Redis execute exception", e);
            }
            finally {
                if (this.shardedJedis != null) {
                    this.shardedJedis.close();
                }
            }
            return result;
        }
    }

    public static class Pair<K, V> {
        private K key;
        private V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public void setKey(K key) {
            this.key = key;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }
    }
}

