/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.bigdata.test;

import cn.regionsoft.one.bigdata.core.object.RDSchema;
import cn.regionsoft.one.bigdata.core.object.RDTable;
import cn.regionsoft.one.bigdata.core.persist.RDEntity;
import cn.regionsoft.one.bigdata.core.persist.RDEntityListResult;
import cn.regionsoft.one.bigdata.criterias.RDCondition;
import cn.regionsoft.one.bigdata.criterias.RDCriteria;
import cn.regionsoft.one.bigdata.ids.IDProducer;
import cn.regionsoft.one.bigdata.impl.hbase.HbaseDBConnection;
import cn.regionsoft.one.bigdata.impl.hbase.HbaseThreadHolder;
import cn.regionsoft.one.bigdata.impl.hbase.HbaseUtil;
import cn.regionsoft.one.core.ids.IDGenerator;
import java.util.LinkedHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;

public class Test {
    public static void main(String[] args) throws Throwable {
        String dataSpaceName = "RDDATA26";
        String appOwner = "liangjun";
        String appName = "testAppId";
        String schema = "MorcblecloudDB";
        Configuration configuration = HBaseConfiguration.create();
        configuration.set("hbase.zookeeper.property.clientPort", "2181");
        configuration.set("hbase.zookeeper.quorum", "hbase-docker");
        Connection connection = ConnectionFactory.createConnection((Configuration)configuration);
        HbaseThreadHolder.getInstance().setThreadDatas(new HbaseDBConnection(connection, configuration, dataSpaceName));
        Scan scan = new Scan();
        scan.withStartRow(Bytes.toBytes((int)0));
        scan.withStopRow(Bytes.toBytes((int)0));
        scan.setRowPrefixFilter(Bytes.toBytes((int)0));
        HbaseUtil.printAllData();
        HbaseUtil.setIDProducer(new IDProducer(){

            @Override
            public Long getNextLongId() {
                try {
                    return IDGenerator.getLongID();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        HbaseUtil.createDataSpaceIfNotExist(connection, dataSpaceName);
        RDSchema rdSchema = HbaseUtil.getRDSchema(appOwner, appName);
        RDTable rdTable = HbaseUtil.getRdTable(rdSchema, "USER");
        rdTable.createRdIndex("acc", "pwd");
        HbaseUtil.printAllData();
        System.out.println(1);
        System.out.println(1);
        LinkedHashMap<String, Object> newRecord = new LinkedHashMap<String, Object>();
        HbaseThreadHolder.getInstance().getThreadDatas().setAutoCommit(false);
        long time2 = System.currentTimeMillis();
        boolean k = false;
        for (int i = 0; i < 10; ++i) {
            newRecord.put("name", "feng" + i);
            newRecord.put("pwd", "password" + i);
            newRecord.put("acc", "acc" + i);
            rdTable.insert(newRecord);
        }
        HbaseThreadHolder.getInstance().getThreadDatas().setAutoCommit(true);
        HbaseUtil.printAllData();
        System.out.println(System.currentTimeMillis() - time2);
        System.out.println("insert completed");
        RDEntity rdEntity = HbaseUtil.findById(rdTable, "4650923910856966145");
        System.out.println(1);
        int pageSize = 10;
        int currentPage = 1;
        Object rowkeyReg = null;
        RDCriteria criteria = RDCriteria.create(RDCondition.and(RDCondition.equal("name", "feng4"), RDCondition.startWith("pwd", "password4")));
        System.out.println("search result with criteria");
        long time22 = System.currentTimeMillis();
        RDEntityListResult result1 = HbaseUtil.getList(rdTable, (Integer)pageSize, currentPage, criteria);
        System.out.println(System.currentTimeMillis() - time22);
        time22 = System.currentTimeMillis();
        RDEntityListResult result2 = HbaseUtil.getList(rdTable, (Integer)pageSize, 2, criteria);
        System.out.println(System.currentTimeMillis() - time22);
        time22 = System.currentTimeMillis();
        RDEntityListResult result3 = HbaseUtil.getList(rdTable, (Integer)pageSize, result1.getNextStartRowKey(), criteria);
        System.out.println(System.currentTimeMillis() - time22);
        System.out.println("search result without criteria");
        time22 = System.currentTimeMillis();
        System.out.println(System.currentTimeMillis() - time22);
    }
}

