/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.bigdata.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class ClouderaTest {
    public static Configuration configuration;
    public static Connection connection;
    public static Admin admin;

    public static void main(String[] args) throws IOException {
        ClouderaTest.createTable("fenglj1", new String[]{"cf1", "cf2"});
        ClouderaTest.init();
        Table table = connection.getTable(TableName.valueOf((String)"t2"));
        long time = System.currentTimeMillis();
        String colFamily = "cf1";
        String col = "q1";
        ArrayList putList = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(Bytes.toBytes((String)("rw" + i)));
            put.addColumn(Bytes.toBytes((String)colFamily), Bytes.toBytes((String)col), Bytes.toBytes((String)("val" + i)));
            table.put(put);
        }
        System.out.println(System.currentTimeMillis() - time);
        table.close();
        ClouderaTest.close();
    }

    public static void init() {
        configuration = HBaseConfiguration.create();
        configuration.set("hbase.zookeeper.property.clientPort", "2181");
        configuration.set("hbase.zookeeper.quorum", "cm0");
        configuration.set("hbase.master", "cm0:60000");
        try {
            connection = ConnectionFactory.createConnection((Configuration)configuration);
            admin = connection.getAdmin();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void close() {
        try {
            if (null != admin) {
                admin.close();
            }
            if (null != connection) {
                connection.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createTable(String tableNmae, String[] colFamilies) throws IOException {
        ClouderaTest.init();
        TableName tableName = TableName.valueOf((String)tableNmae);
        if (admin.tableExists(tableName)) {
            System.out.println("talbe is exists!");
        } else {
            HTableDescriptor hTableDescriptor = new HTableDescriptor(tableName);
            for (String colFamily : colFamilies) {
                HColumnDescriptor hColumnDescriptor = new HColumnDescriptor(colFamily);
                hTableDescriptor.addFamily(hColumnDescriptor);
            }
            admin.createTable(hTableDescriptor);
        }
        ClouderaTest.close();
    }

    public static void deleteTable(String tableName) throws IOException {
        ClouderaTest.init();
        TableName tn = TableName.valueOf((String)tableName);
        if (admin.tableExists(tn)) {
            admin.disableTable(tn);
            admin.deleteTable(tn);
        }
        ClouderaTest.close();
    }

    public static void listTables() throws IOException {
        HTableDescriptor[] hTableDescriptors;
        ClouderaTest.init();
        for (HTableDescriptor hTableDescriptor : hTableDescriptors = admin.listTables()) {
            System.out.println(hTableDescriptor.getNameAsString());
        }
        ClouderaTest.close();
    }

    public static void insterRow(String tableName, String rowkey, String colFamily, String col, String val) throws IOException {
        ClouderaTest.init();
        Table table = connection.getTable(TableName.valueOf((String)tableName));
        Put put = new Put(Bytes.toBytes((String)rowkey));
        put.addColumn(Bytes.toBytes((String)colFamily), Bytes.toBytes((String)col), Bytes.toBytes((String)val));
        table.put(put);
        table.close();
        ClouderaTest.close();
    }

    public static void deleRow(String tableName, String rowkey, String colFamily, String col) throws IOException {
        ClouderaTest.init();
        Table table = connection.getTable(TableName.valueOf((String)tableName));
        Delete delete = new Delete(Bytes.toBytes((String)rowkey));
        table.delete(delete);
        table.close();
        ClouderaTest.close();
    }

    public static void getData(String tableName, String rowkey, String colFamily, String col) throws IOException {
        ClouderaTest.init();
        Table table = connection.getTable(TableName.valueOf((String)tableName));
        Get get = new Get(Bytes.toBytes((String)rowkey));
        Result result = table.get(get);
        ClouderaTest.showCell(result);
        table.close();
        ClouderaTest.close();
    }

    public static void showCell(Result result) {
        Cell[] cells;
        for (Cell cell : cells = result.rawCells()) {
            System.out.println("RowName:" + new String(CellUtil.cloneRow((Cell)cell)) + " ");
            System.out.println("Timetamp:" + cell.getTimestamp() + " ");
            System.out.println("column Family:" + new String(CellUtil.cloneFamily((Cell)cell)) + " ");
            System.out.println("row Name:" + new String(CellUtil.cloneQualifier((Cell)cell)) + " ");
            System.out.println("value:" + new String(CellUtil.cloneValue((Cell)cell)) + " ");
        }
    }

    public static void scanData(String tableName, String startRow, String stopRow) throws IOException {
        ClouderaTest.init();
        Table table = connection.getTable(TableName.valueOf((String)tableName));
        Scan scan = new Scan();
        ResultScanner resultScanner = table.getScanner(scan);
        for (Result result : resultScanner) {
            ClouderaTest.showCell(result);
        }
        table.close();
        ClouderaTest.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Result> getNumRegexRow(String tableName, String startRowKey, String endRowKey, String regxKey, int num) {
        ClouderaTest.init();
        Table table = null;
        ArrayList<Result> list = null;
        try {
            table = connection.getTable(TableName.valueOf((String)tableName));
            FilterList fl = new FilterList(FilterList.Operator.MUST_PASS_ALL);
            RegexStringComparator rc = new RegexStringComparator(regxKey);
            RowFilter rf = new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)rc);
            PageFilter filterNum = new PageFilter((long)num);
            fl.addFilter((Filter)rf);
            fl.addFilter((Filter)filterNum);
            Scan scan = new Scan();
            scan.setStartRow(startRowKey.getBytes());
            scan.setStopRow(endRowKey.getBytes());
            scan.setFilter((Filter)fl);
            ResultScanner scanner = table.getScanner(scan);
            list = new ArrayList<Result>();
            for (Result rs : scanner) {
                list.add(rs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                table.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (Result result : list) {
            ClouderaTest.showCell(result);
        }
        ClouderaTest.close();
        return list;
    }
}

