/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.bigdata.impl.hbase;

import cn.regionsoft.one.bigdata.core.exceptions.ExistException;
import cn.regionsoft.one.bigdata.core.object.RDColumn;
import cn.regionsoft.one.bigdata.core.object.RDIndex;
import cn.regionsoft.one.bigdata.core.object.RDSchema;
import cn.regionsoft.one.bigdata.core.object.RDTable;
import cn.regionsoft.one.bigdata.core.persist.RDEntity;
import cn.regionsoft.one.bigdata.core.persist.RDEntityListResult;
import cn.regionsoft.one.bigdata.criterias.RDCriteria;
import cn.regionsoft.one.bigdata.criterias.RDFilterType;
import cn.regionsoft.one.bigdata.criterias.indexfilter.RDRootIndexFilterInfo;
import cn.regionsoft.one.bigdata.enums.DataType;
import cn.regionsoft.one.bigdata.ids.IDProducer;
import cn.regionsoft.one.bigdata.impl.RDConstants;
import cn.regionsoft.one.bigdata.impl.hbase.HbaseDBConnection;
import cn.regionsoft.one.bigdata.impl.hbase.HbaseThreadHolder;
import cn.regionsoft.one.core.CommonUtil;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.LongColumnInterpreter;
import org.apache.hadoop.hbase.coprocessor.AggregateImplementation;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class HbaseUtil {
    private static IDProducer idProducer;
    private static Set<String> exsitSpace;
    private static boolean enableIndexSerach;

    public static void setIDProducer(IDProducer idProducer) {
        HbaseUtil.idProducer = idProducer;
    }

    public static void deleteRDSchema(String userId, String appName) throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        RDSchema rdSchema = HbaseUtil.getRDSchema(userId, appName);
        if (rdSchema != null) {
            HbaseUtil.deleteByRowKeyStartWith(table, userId + "_" + rdSchema.getSeq());
            String schemaFlagRowKey = "schema_enable";
            Put tableFlagOp = new Put(Bytes.toBytes((String)schemaFlagRowKey));
            tableFlagOp.addColumn(RDConstants.FAMILY_BYTES, Bytes.toBytes((int)rdSchema.getSeq()), Bytes.toBytes((String)"0"));
            table.put(tableFlagOp);
        }
    }

    public static RDSchema createRDSchema(String userId, String appName, String rdSchemaNm) throws Exception {
        String schemaRowKey = "schema_" + userId;
        String schemaAppIdRowKey = schemaRowKey + "_" + "appids";
        String schemaFlagRowKey = schemaRowKey + "_" + "enable";
        RDSchema rdSchema = null;
        try {
            int index = HbaseUtil.createMetaData(new String[]{schemaRowKey, schemaAppIdRowKey}, schemaFlagRowKey, new String[]{rdSchemaNm, appName}, 0);
            rdSchema = new RDSchema(userId, appName, rdSchemaNm, index);
            return rdSchema;
        }
        catch (ExistException e) {
            throw new ExistException("Exsits schema:" + e.getMessage());
        }
    }

    public static int createMetaData(String[] rowKeys, String flagKey, String[] vals, int notDuplicateIndex) throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        ArrayList<Get> gets = new ArrayList<Get>();
        Get getFlagOfLogicTables = new Get(Bytes.toBytes((String)flagKey));
        gets.add(getFlagOfLogicTables);
        for (String rowKey : rowKeys) {
            gets.add(new Get(rowKey.getBytes()));
        }
        Result[] r = table.get(gets);
        Cell[] logicTableFlags = r[0].rawCells();
        int length = logicTableFlags.length;
        if (notDuplicateIndex != -1) {
            Cell[] compareCells = r[notDuplicateIndex + 1].rawCells();
            String newVal = vals[notDuplicateIndex];
            for (int i = 0; i < length; ++i) {
                String checkVal;
                String enableFlag = Bytes.toString((byte[])CellUtil.cloneValue((Cell)logicTableFlags[i]));
                if (!"1".equals(enableFlag) || !(checkVal = Bytes.toString((byte[])CellUtil.cloneValue((Cell)compareCells[i]))).equals(newVal)) continue;
                throw new ExistException(newVal);
            }
        }
        ArrayList<Put> puts = new ArrayList<Put>();
        Put tableInfoOp = new Put(Bytes.toBytes((String)flagKey));
        tableInfoOp.addColumn(RDConstants.FAMILY_BYTES, Bytes.toBytes((int)length), Bytes.toBytes((String)"1"));
        puts.add(tableInfoOp);
        int index = 0;
        for (String rowKey : rowKeys) {
            Put tableFlagOp = new Put(Bytes.toBytes((String)rowKey));
            tableFlagOp.addColumn(RDConstants.FAMILY_BYTES, Bytes.toBytes((int)length), Bytes.toBytes((String)vals[index]));
            puts.add(tableFlagOp);
            ++index;
        }
        table.put(puts);
        return length;
    }

    private static String[][] getMetaData(String flagKey, String[] rowKeys) throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        ArrayList<Get> gets = new ArrayList<Get>();
        Get getFlagOfLogicTables = new Get(flagKey.getBytes());
        gets.add(getFlagOfLogicTables);
        for (String rowKey : rowKeys) {
            gets.add(new Get(rowKey.getBytes()));
        }
        Result[] r = table.get(gets);
        Cell[] logicTableFlags = r[0].rawCells();
        String[][] result = new String[gets.size()][logicTableFlags.length];
        for (int i = 0; i < result.length; ++i) {
            String[] tmp = result[i];
            for (int j = 0; j < tmp.length; ++j) {
                result[i][j] = Bytes.toString((byte[])CellUtil.cloneValue((Cell)r[i].rawCells()[j]));
            }
        }
        return result;
    }

    public static RDSchema getRDSchema(String userId, String appName) throws Exception {
        String schemaRowKey = "schema_" + userId;
        String schemaAppIdRowKey = schemaRowKey + "_" + "appids";
        String schemaFlagRowKey = schemaRowKey + "_" + "enable";
        String[][] schemaMetaData = HbaseUtil.getMetaData(schemaFlagRowKey, new String[]{schemaAppIdRowKey, schemaRowKey});
        RDSchema rdSchema = null;
        int index = 0;
        for (String enableFlag : schemaMetaData[0]) {
            if ("1".equals(enableFlag) && appName.equals(schemaMetaData[1][index])) {
                rdSchema = new RDSchema(userId, appName, schemaMetaData[2][index], index);
                break;
            }
            ++index;
        }
        return rdSchema;
    }

    public static RDTable getRdTable(RDSchema rdSchema, String rdTableNm) throws Exception {
        String logicTableKey = rdSchema.getUserId() + "_" + rdSchema.getSeq() + "_" + "tbls";
        String logicTableFlagKey = logicTableKey + "_" + "enable";
        String[][] schemaMetaData = HbaseUtil.getMetaData(logicTableFlagKey, new String[]{logicTableKey});
        RDTable rdTable = null;
        int index = 0;
        for (String enableFlag : schemaMetaData[0]) {
            if ("1".equals(enableFlag) && rdTableNm.equals(schemaMetaData[1][index])) {
                rdTable = new RDTable(rdSchema, rdTableNm, index);
                break;
            }
            ++index;
        }
        if (rdTable == null) {
            return null;
        }
        String logicColsKey = rdSchema.getUserId() + "_" + rdSchema.getSeq() + "_" + rdTable.getSeq() + "_" + "cols";
        String logicColsDataTypeKey = logicColsKey + "_" + "datatype";
        String logicColsFlagKey = logicColsKey + "_" + "enable";
        String[][] colsMetaData = HbaseUtil.getMetaData(logicColsFlagKey, new String[]{logicColsKey, logicColsDataTypeKey});
        index = 0;
        for (String enableFlag : colsMetaData[0]) {
            if ("1".equals(enableFlag)) {
                rdTable.registerColumn(new RDColumn(colsMetaData[1][index], DataType.getDataType(colsMetaData[2][index]), index));
            }
            ++index;
        }
        String logicIndexKey = rdSchema.getUserId() + "_" + rdSchema.getSeq() + "_" + rdTable.getSeq() + "_" + "index";
        String logicIndexFlagKey = logicIndexKey + "_" + "enable";
        String[][] indexMetaData = HbaseUtil.getMetaData(logicIndexFlagKey, new String[]{logicIndexKey});
        index = 0;
        for (String enableFlag : indexMetaData[0]) {
            if ("1".equals(enableFlag)) {
                rdTable.registerIndex(new RDIndex(indexMetaData[1][index], index));
            }
            ++index;
        }
        return rdTable;
    }

    public static RDTable createRdTable(RDSchema rdSchema, String rdTableName) throws Exception {
        String logicTableKey = rdSchema.getUserId() + "_" + rdSchema.getSeq() + "_" + "tbls";
        String logicTableFlagKey = logicTableKey + "_" + "enable";
        try {
            int index = HbaseUtil.createMetaData(new String[]{logicTableKey}, logicTableFlagKey, new String[]{rdTableName}, 0);
            return new RDTable(rdSchema, rdTableName, index);
        }
        catch (ExistException e) {
            throw new ExistException("Exsits Table:" + e.getMessage());
        }
    }

    public static RDColumn createRdColumn(RDTable rdTable, String rdColumnNm, String label, DataType dataType) throws Exception {
        RDSchema rdSchema = rdTable.getRdSchema();
        String logicColsKey = rdSchema.getUserId() + "_" + rdSchema.getSeq() + "_" + rdTable.getSeq() + "_" + "cols";
        String logicColsDataTypeKey = logicColsKey + "_" + "datatype";
        String logicColsLabeleKey = logicColsKey + "_" + "label";
        String logicColsFlagKey = logicColsKey + "_" + "enable";
        try {
            int columnIndex = HbaseUtil.createMetaData(new String[]{logicColsKey, logicColsDataTypeKey, logicColsLabeleKey}, logicColsFlagKey, new String[]{rdColumnNm, dataType.name(), label}, 0);
            RDColumn rdColumn = new RDColumn(rdColumnNm, dataType, columnIndex);
            return rdColumn;
        }
        catch (ExistException e) {
            throw new ExistException("Exsits column:" + e.getMessage());
        }
    }

    public static void clearTable(RDSchema rdSchema, String rdTableName) throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        RDTable rdTable = HbaseUtil.getRdTable(rdSchema, rdTableName);
        String dataStartKey = rdSchema.getUserId() + "_" + rdSchema.getSeq() + "_" + rdTable.getSeq() + "_" + "data";
        HbaseUtil.deleteByRowKeyStartWith(table, dataStartKey);
        String indexDataStartKey = rdSchema.getUserId() + "_" + rdSchema.getSeq() + "_" + rdTable.getSeq() + "_" + "index" + "_" + "data";
        HbaseUtil.deleteByRowKeyStartWith(table, indexDataStartKey);
    }

    public static void deleteTable(RDSchema rdSchema, String rdTableName) throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        RDTable rdTable = HbaseUtil.getRdTable(rdSchema, rdTableName);
        if (rdTable == null) {
            return;
        }
        String dataStartKey = rdSchema.getUserId() + "_" + rdSchema.getSeq() + "_" + rdTable.getSeq();
        HbaseUtil.deleteByRowKeyStartWith(table, dataStartKey);
        String logicTableFlagKey = rdSchema.getUserId() + "_" + rdSchema.getSeq() + "_" + "tbls" + "_" + "enable";
        Put putOp = new Put(Bytes.toBytes((String)logicTableFlagKey));
        putOp.addColumn(RDConstants.FAMILY_BYTES, Bytes.toBytes((int)rdTable.getSeq()), Bytes.toBytes((String)"0"));
        table.put(putOp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printAllData() throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        try (ResultScanner resultScanner1 = null;){
            Scan scan1 = new Scan();
            resultScanner1 = table.getScanner(scan1);
            for (Result resRow : resultScanner1) {
                String tmp = Bytes.toString((byte[])resRow.getRow()) + " : ";
                CellScanner cellScanner = resRow.cellScanner();
                int i = 0;
                Cell tmpCell = null;
                String cellVal = null;
                while (cellScanner.advance()) {
                    tmpCell = cellScanner.current();
                    byte[] bytes = CellUtil.cloneValue((Cell)tmpCell);
                    cellVal = Bytes.toString((byte[])CellUtil.cloneValue((Cell)tmpCell));
                    tmp = tmp + "[" + i + ":" + cellVal + "] ";
                    ++i;
                }
                System.out.println(tmp);
            }
        }
    }

    public static Long insert(RDTable rdTable, Map<String, Object> newRecord) throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        Map<String, RDColumn> tableCols = rdTable.getRdColumns();
        ArrayList<Put> puts = new ArrayList<Put>();
        Long recordId = idProducer.getNextLongId();
        RDSchema rdSchema = rdTable.getRdSchema();
        Put put = new Put(Bytes.toBytes((String)(rdSchema.getUserId() + "_" + rdTable.getRdSchema().getSeq() + "_" + rdTable.getSeq() + "_" + "data" + "_" + recordId)));
        Iterator<Map.Entry<String, Object>> iterator = newRecord.entrySet().iterator();
        RDColumn rdColumn = null;
        while (iterator.hasNext()) {
            byte[] tmpBytes;
            Map.Entry<String, Object> tmp = iterator.next();
            rdColumn = tableCols.get(tmp.getKey());
            if (rdColumn == null || (tmpBytes = HbaseUtil.getBytesFromColumnVal(rdColumn, tmp.getValue())) == null) continue;
            put.addColumn(RDConstants.FAMILY_BYTES, Bytes.toBytes((int)rdColumn.getSeq()), tmpBytes);
        }
        puts.add(put);
        if (rdTable.getRdIndexes().size() != 0) {
            String indexKeyPrefix = rdSchema.getUserId() + "_" + rdTable.getRdSchema().getSeq() + "_" + rdTable.getSeq() + "_" + "index" + "_" + "data" + "_";
            StringBuilder indexKey = null;
            Map<Integer, String> columnIndexToNameMap = rdTable.getColumnIndexToNameMap();
            String[] columnSeqArray = null;
            String columnName = null;
            Object columnVal = null;
            for (RDIndex rdIndex : rdTable.getRdIndexes().values()) {
                indexKey = new StringBuilder();
                indexKey.append(indexKeyPrefix);
                indexKey.append(rdIndex.getSeq());
                indexKey.append("_");
                for (String columnSeq : columnSeqArray = rdIndex.getName().split("_")) {
                    columnName = columnIndexToNameMap.get(Integer.parseInt(columnSeq));
                    columnVal = newRecord.get(columnName);
                    indexKey.append(String.valueOf(columnVal));
                    indexKey.append("_");
                }
                indexKey.append(recordId);
                Put tableInfoOp = new Put(Bytes.toBytes((String)indexKey.toString()));
                tableInfoOp.addColumn(RDConstants.FAMILY_BYTES, Bytes.toBytes((int)0), Bytes.toBytes((long)0L));
                puts.add(tableInfoOp);
            }
        }
        table.put(puts);
        return recordId;
    }

    public static Long getAmount(RDTable rdTable, RDCriteria rdCriteria) throws Throwable {
        if (rdTable == null) {
            throw new Exception("rdTable is null");
        }
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        Scan scan = new Scan();
        HbaseUtil.wrapScanner(scan, rdTable, null, rdCriteria, null);
        if (Bytes.toString((byte[])scan.getStartRow()).compareTo(Bytes.toString((byte[])scan.getStopRow())) > 0) {
            return 0L;
        }
        return HbaseThreadHolder.getInstance().getThreadDatas().getAggregationClient().rowCount((Table)table, (ColumnInterpreter)new LongColumnInterpreter(), scan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RDEntity> findAll(RDTable rdTable) throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        ArrayList<RDEntity> listResult = new ArrayList<RDEntity>();
        RDSchema rdSchema = rdTable.getRdSchema();
        String rowPrefix = rdSchema.getUserId() + "_" + rdTable.getRdSchema().getSeq() + "_" + rdTable.getSeq() + "_" + "data";
        Scan scan = new Scan();
        scan.withStartRow(Bytes.toBytes((String)rowPrefix));
        scan.setRowPrefixFilter(Bytes.toBytes((String)rowPrefix));
        scan.withStopRow(Bytes.toBytes((String)(rowPrefix + "~")));
        ResultScanner resultScanner = null;
        try {
            resultScanner = table.getScanner(scan);
            for (Result resRow : resultScanner) {
                listResult.add(HbaseUtil.wrapEntityFromRowData(rdTable, resRow));
            }
        }
        finally {
            CommonUtil.closeQuietly((Closeable)resultScanner);
        }
        return listResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RDEntity> findRecycledData(RDTable rdTable) throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getRecycleDataTable();
        ArrayList<RDEntity> listResult = new ArrayList<RDEntity>();
        RDSchema rdSchema = rdTable.getRdSchema();
        String rowPrefix = rdSchema.getUserId() + "_" + rdTable.getRdSchema().getSeq() + "_" + rdTable.getSeq() + "_" + "data";
        Scan scan = new Scan();
        scan.withStartRow(Bytes.toBytes((String)rowPrefix));
        scan.setRowPrefixFilter(Bytes.toBytes((String)rowPrefix));
        scan.withStopRow(Bytes.toBytes((String)(rowPrefix + "~")));
        ResultScanner resultScanner = null;
        try {
            resultScanner = table.getScanner(scan);
            for (Result resRow : resultScanner) {
                listResult.add(HbaseUtil.wrapEntityFromRowData(rdTable, resRow));
            }
        }
        finally {
            CommonUtil.closeQuietly((Closeable)resultScanner);
        }
        return listResult;
    }

    public static RDEntityListResult getList(RDTable rdTable, Integer pageSize, Integer pageNo, RDCriteria rdCriteria) throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        if (pageNo == null || pageNo < 1) {
            pageNo = 1;
        }
        return HbaseUtil.subGetList(table, rdTable, pageNo, pageSize, rdCriteria, null);
    }

    public static RDEntityListResult getList(RDTable rdTable, Integer pageSize, String startRowKey, RDCriteria rdCriteria) throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        if (startRowKey == null) {
            throw new Exception("startRowKey is empty");
        }
        return HbaseUtil.subGetList(table, rdTable, null, pageSize, rdCriteria, startRowKey);
    }

    private static RDEntityListResult subGetList(HTable table, RDTable rdTable, Integer pageNo, Integer pageSize, RDCriteria rdCriteria, String startRowKey) throws Exception {
        Scan scan = new Scan();
        RDRootIndexFilterInfo rdIndexFilterInfo = HbaseUtil.wrapScanner(scan, rdTable, pageSize, rdCriteria, startRowKey);
        RDEntityListResult rdListResult = null;
        if (rdIndexFilterInfo != null) {
            rdListResult = HbaseUtil.subOfSubGetList(table, scan, rdTable, pageNo, pageSize, startRowKey);
            List<RDEntity> idList = rdListResult.getList();
            rdListResult = new RDEntityListResult();
            if (idList != null) {
                if (idList.size() == 1) {
                    ArrayList<RDEntity> listResult = new ArrayList<RDEntity>();
                    listResult.add(HbaseUtil.findById(rdTable, idList.get(0).getId()));
                    rdListResult.setList(listResult);
                } else {
                    String[] ids = new String[idList.size()];
                    int index = 0;
                    for (RDEntity rdEntity : idList) {
                        ids[index] = rdEntity.getId();
                        ++index;
                    }
                    List<RDEntity> listResult = HbaseUtil.findByIds(rdTable, ids);
                    rdListResult.setList(listResult);
                }
            }
        } else {
            rdListResult = HbaseUtil.subOfSubGetList(table, scan, rdTable, pageNo, pageSize, startRowKey);
        }
        return rdListResult;
    }

    private static RDRootIndexFilterInfo wrapScanner(Scan scan, RDTable rdTable, Integer pageSize, RDCriteria rdCriteria, String startRowKey) throws Exception {
        if (rdTable == null) {
            throw new Exception("rdTable is null");
        }
        if ("EOF".equals(startRowKey)) {
            return null;
        }
        RDSchema rdSchema = rdTable.getRdSchema();
        RDRootIndexFilterInfo rdIndexFilterInfo = null;
        PageFilter pageFilter = null;
        if (pageSize != null) {
            pageFilter = new PageFilter((long)(pageSize + 1));
        }
        if (rdCriteria != null) {
            if (enableIndexSerach) {
                rdIndexFilterInfo = rdCriteria.getIndexFilter(rdTable);
            }
            if (rdIndexFilterInfo != null) {
                startRowKey = RDCriteria.biggerStr(startRowKey, rdIndexFilterInfo.getStartRowKey());
                String stopRowKey = null;
                if (rdIndexFilterInfo.getRdFilterType() == RDFilterType.START_WITH) {
                    stopRowKey = rdIndexFilterInfo.getStopRowKey();
                    scan.setRowPrefixFilter(Bytes.toBytes((String)rdIndexFilterInfo.getCompareStr()));
                    if (pageFilter != null) {
                        scan.setFilter((Filter)pageFilter);
                    }
                } else if (rdIndexFilterInfo.getRdFilterType() == RDFilterType.EQUAL) {
                    stopRowKey = rdIndexFilterInfo.getStopRowKey();
                    scan.setRowPrefixFilter(Bytes.toBytes((String)rdIndexFilterInfo.getCompareStr()));
                    if (pageFilter != null) {
                        scan.setFilter((Filter)pageFilter);
                    }
                } else if (rdIndexFilterInfo.getRdFilterType() == RDFilterType.GT) {
                    stopRowKey = rdIndexFilterInfo.getStopRowKey();
                    scan.setRowPrefixFilter(Bytes.toBytes((String)rdIndexFilterInfo.getRowPrefix()));
                    if (pageFilter != null) {
                        scan.setFilter((Filter)pageFilter);
                    }
                } else if (rdIndexFilterInfo.getRdFilterType() == RDFilterType.STOP_WITH || rdIndexFilterInfo.getRdFilterType() == RDFilterType.REGEX) {
                    stopRowKey = rdIndexFilterInfo.getStopRowKey();
                    FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                    filterList.addFilter((Filter)new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator(rdIndexFilterInfo.getCompareStr() + "_")));
                    if (pageFilter != null) {
                        filterList.addFilter((Filter)pageFilter);
                    }
                    scan.setFilter((Filter)filterList);
                }
                if (startRowKey != null) {
                    scan.withStartRow(Bytes.toBytes((String)startRowKey));
                }
                if (stopRowKey != null) {
                    scan.withStopRow(Bytes.toBytes((String)stopRowKey));
                }
            } else {
                FilterList childFilterList = rdCriteria.toFilterList(rdTable);
                if (childFilterList == null) {
                    if (pageFilter != null) {
                        scan.setFilter((Filter)pageFilter);
                    }
                } else {
                    FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                    filterList.addFilter((Filter)childFilterList);
                    if (pageFilter != null) {
                        filterList.addFilter((Filter)pageFilter);
                    }
                    scan.setFilter((Filter)filterList);
                }
                String rowPrefix = rdSchema.getUserId() + "_" + rdTable.getRdSchema().getSeq() + "_" + rdTable.getSeq() + "_" + "data";
                scan.withStartRow(Bytes.toBytes((String)rowPrefix));
                scan.setRowPrefixFilter(Bytes.toBytes((String)rowPrefix));
                scan.withStopRow(Bytes.toBytes((String)(rowPrefix + "~")));
            }
        } else {
            String rowPrefix = rdSchema.getUserId() + "_" + rdTable.getRdSchema().getSeq() + "_" + rdTable.getSeq() + "_" + "data";
            scan.setRowPrefixFilter(Bytes.toBytes((String)rowPrefix));
            if (startRowKey == null) {
                scan.withStartRow(Bytes.toBytes((String)rowPrefix));
            } else {
                startRowKey = RDCriteria.biggerStr(startRowKey, rowPrefix);
            }
            scan.withStopRow(Bytes.toBytes((String)(rowPrefix + "~")));
            scan.setFilter((Filter)pageFilter);
        }
        return rdIndexFilterInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RDEntityListResult subOfSubGetList(HTable table, Scan scan, RDTable rdTable, Integer pageNo, Integer pageSize, String startRowKey) throws Exception {
        RDEntityListResult rdListResult = new RDEntityListResult();
        ArrayList<RDEntity> listResult = new ArrayList<RDEntity>();
        rdListResult.setList(listResult);
        if (pageSize == null) {
            try (ResultScanner resultScanner = table.getScanner(scan);){
                for (Result resRow : resultScanner) {
                    listResult.add(HbaseUtil.wrapEntityFromRowData(rdTable, resRow));
                }
                RDEntityListResult rDEntityListResult = rdListResult;
                return rDEntityListResult;
            }
        }
        if (startRowKey == null) {
            for (int i = 1; i < pageNo + 1; ++i) {
                int count = 0;
                try (ResultScanner resultScanner = table.getScanner(scan);){
                    rdListResult.setNextStartRowKey("EOF");
                    for (Result resRow : resultScanner) {
                        if (++count == pageSize + 1) {
                            startRowKey = Bytes.toString((byte[])resRow.getRow());
                            if (i == pageNo) {
                                rdListResult.setNextStartRowKey(startRowKey);
                                break;
                            }
                            scan.withStartRow(startRowKey.getBytes());
                            break;
                        }
                        if (i != pageNo || count > pageSize) continue;
                        listResult.add(HbaseUtil.wrapEntityFromRowData(rdTable, resRow));
                    }
                    if (count >= pageSize + 1) continue;
                    break;
                }
            }
        } else {
            scan.withStartRow(startRowKey.getBytes());
            if (Bytes.toString((byte[])scan.getStartRow()).compareTo(Bytes.toString((byte[])scan.getStopRow())) > 0) {
                return rdListResult;
            }
            int count = 0;
            try (ResultScanner resultScanner = table.getScanner(scan);){
                rdListResult.setNextStartRowKey("EOF");
                for (Result resRow : resultScanner) {
                    if (++count == pageSize + 1) {
                        startRowKey = Bytes.toString((byte[])resRow.getRow());
                        rdListResult.setNextStartRowKey(startRowKey);
                    }
                    if (count > pageSize) continue;
                    listResult.add(HbaseUtil.wrapEntityFromRowData(rdTable, resRow));
                }
            }
        }
        return rdListResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RDEntity findById(RDTable rdTable, String id) throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        try (ResultScanner resultScanner = null;){
            RDSchema rdSchema = rdTable.getRdSchema();
            String startRowKey = rdSchema.getUserId() + "_" + rdTable.getRdSchema().getSeq() + "_" + rdTable.getSeq() + "_" + "data" + "_" + id;
            Scan scan = new Scan();
            scan.withStartRow(startRowKey.getBytes());
            scan.setRowPrefixFilter(Bytes.toBytes((String)startRowKey));
            scan.setFilter((Filter)new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)startRowKey))));
            resultScanner = table.getScanner(scan);
            RDEntity result = null;
            Iterator iterator = resultScanner.iterator();
            if (iterator.hasNext()) {
                Result resRow = (Result)iterator.next();
                result = HbaseUtil.wrapEntityFromRowData(rdTable, resRow);
            }
            iterator = result;
            return iterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RDEntity> findByIds(RDTable rdTable, String[] ids) throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        try (Object resultScanner = null;){
            Result[] resRows;
            ArrayList<RDEntity> result = new ArrayList<RDEntity>();
            ArrayList<Get> getList = new ArrayList<Get>();
            RDSchema rdSchema = rdTable.getRdSchema();
            String startRowKey = rdSchema.getUserId() + "_" + rdTable.getRdSchema().getSeq() + "_" + rdTable.getSeq() + "_" + "data" + "_";
            for (String id : ids) {
                Get get = new Get(Bytes.toBytes((String)(startRowKey + id)));
                get.addFamily(RDConstants.FAMILY_BYTES);
                getList.add(get);
            }
            for (Result resRow : resRows = table.get(getList)) {
                result.add(HbaseUtil.wrapEntityFromRowData(rdTable, resRow));
            }
            ArrayList<RDEntity> arrayList = result;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteByRowKeyStartWith(HTable table, String startWith) throws Exception {
        int pageSize = 2;
        int insertBatchSize = 1000;
        String stopWith = startWith + "~";
        Scan scan = new Scan();
        PageFilter pageFilter = new PageFilter((long)(pageSize + 1));
        KeyOnlyFilter filter = new KeyOnlyFilter();
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        filterList.addFilter((Filter)pageFilter);
        filterList.addFilter((Filter)filter);
        scan.setFilter((Filter)filterList);
        scan.withStartRow(Bytes.toBytes((String)startWith));
        scan.withStopRow(Bytes.toBytes((String)stopWith));
        String startRowKey = null;
        String rowKey = null;
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        while (true) {
            ResultScanner resultScanner = table.getScanner(scan);
            int count = 0;
            try {
                for (Result resRow : resultScanner) {
                    if (++count == pageSize + 1) {
                        startRowKey = Bytes.toString((byte[])resRow.getRow());
                        scan.withStartRow(startRowKey.getBytes());
                        break;
                    }
                    rowKey = Bytes.toString((byte[])resRow.getRow());
                    Delete delete = new Delete(Bytes.toBytes((String)rowKey));
                    deletes.add(delete);
                    if (deletes.size() <= insertBatchSize) continue;
                    table.delete(deletes);
                    deletes = new ArrayList();
                }
                if (count >= pageSize + 1) continue;
            }
            finally {
                resultScanner.close();
                continue;
            }
            break;
        }
        if (deletes.size() > 0) {
            table.delete(deletes);
        }
    }

    private static RDEntity wrapEntityFromRowData(RDTable rdTable, Result resRow) throws Exception {
        Iterator<Map.Entry<String, RDColumn>> iterator = rdTable.getRdColumns().entrySet().iterator();
        RDEntity rdEntity = new RDEntity();
        Map.Entry<String, RDColumn> tmpEntry = null;
        String propName = null;
        RDColumn rdColumn = null;
        Cell tmpCell = null;
        String rowKey = Bytes.toString((byte[])resRow.getRow());
        rdEntity.setId(rowKey.substring(rowKey.lastIndexOf("_") + 1));
        while (iterator.hasNext()) {
            tmpEntry = iterator.next();
            propName = tmpEntry.getKey();
            rdColumn = tmpEntry.getValue();
            tmpCell = resRow.getColumnLatestCell(RDConstants.FAMILY_BYTES, Bytes.toBytes((int)rdColumn.getSeq()));
            if (tmpCell == null) continue;
            rdEntity.put(propName, HbaseUtil.getColumnValFromCell(rdColumn, tmpCell));
        }
        return rdEntity;
    }

    public static Object getColumnValFromCell(RDColumn rdColumn, Cell cell) throws Exception {
        if (DataType.STRING == rdColumn.getDataType()) {
            return Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell));
        }
        if (DataType.INT == rdColumn.getDataType()) {
            return Bytes.toInt((byte[])CellUtil.cloneValue((Cell)cell));
        }
        if (DataType.LONG == rdColumn.getDataType()) {
            return Bytes.toLong((byte[])CellUtil.cloneValue((Cell)cell));
        }
        if (DataType.FLOAT == rdColumn.getDataType()) {
            return Float.valueOf(Bytes.toFloat((byte[])CellUtil.cloneValue((Cell)cell)));
        }
        if (DataType.DOUBLE == rdColumn.getDataType()) {
            return Bytes.toDouble((byte[])CellUtil.cloneValue((Cell)cell));
        }
        if (DataType.BOOLEAN == rdColumn.getDataType()) {
            return Bytes.toBoolean((byte[])CellUtil.cloneValue((Cell)cell));
        }
        if (DataType.DATE == rdColumn.getDataType()) {
            return new Date(Bytes.toLong((byte[])CellUtil.cloneValue((Cell)cell)));
        }
        if (DataType.BIGDECIMAL == rdColumn.getDataType()) {
            return Bytes.toBigDecimal((byte[])CellUtil.cloneValue((Cell)cell));
        }
        throw new Exception("Data type is invalid:" + (Object)((Object)rdColumn.getDataType()));
    }

    public static byte[] getBytesFromColumnVal(RDColumn rdColumn, Object columnVal) throws Exception {
        if (columnVal == null) {
            return null;
        }
        if (DataType.STRING == rdColumn.getDataType()) {
            return Bytes.toBytes((String)((String)columnVal));
        }
        if (DataType.INT == rdColumn.getDataType()) {
            if (columnVal instanceof String) {
                return Bytes.toBytes((int)Integer.valueOf((String)columnVal));
            }
            return Bytes.toBytes((int)((Integer)columnVal));
        }
        if (DataType.LONG == rdColumn.getDataType()) {
            if (columnVal instanceof String) {
                return Bytes.toBytes((long)Long.valueOf((String)columnVal));
            }
            return Bytes.toBytes((long)((Long)columnVal));
        }
        if (DataType.FLOAT == rdColumn.getDataType()) {
            if (columnVal instanceof String) {
                return Bytes.toBytes((float)Float.valueOf((String)columnVal).floatValue());
            }
            return Bytes.toBytes((float)((Float)columnVal).floatValue());
        }
        if (DataType.DOUBLE == rdColumn.getDataType()) {
            if (columnVal instanceof String) {
                return Bytes.toBytes((double)Double.valueOf((String)columnVal));
            }
            return Bytes.toBytes((double)((Double)columnVal));
        }
        if (DataType.BOOLEAN == rdColumn.getDataType()) {
            return Bytes.toBytes((boolean)((Boolean)columnVal));
        }
        if (DataType.DATE == rdColumn.getDataType()) {
            return Bytes.toBytes((long)((Date)columnVal).getTime());
        }
        if (DataType.BIGDECIMAL == rdColumn.getDataType()) {
            return Bytes.toBytes((BigDecimal)((BigDecimal)columnVal));
        }
        throw new Exception("Data type is invalid:" + (Object)((Object)rdColumn.getDataType()));
    }

    public static void createDataSpaceIfNotExist(Connection connection, String dataSpaceName) throws Exception {
        Admin admin = null;
        try {
            if (!exsitSpace.contains(dataSpaceName)) {
                TableName tbName;
                admin = connection.getAdmin();
                if (!admin.tableExists(tbName = TableName.valueOf((String)dataSpaceName))) {
                    HTableDescriptor hTableDescriptor = new HTableDescriptor(tbName);
                    HColumnDescriptor hColumnDescriptor = new HColumnDescriptor("fm0");
                    hTableDescriptor.addFamily(hColumnDescriptor);
                    hTableDescriptor.addCoprocessor(AggregateImplementation.class.getName());
                    admin.createTable(hTableDescriptor);
                }
                exsitSpace.add(dataSpaceName);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (admin != null) {
                try {
                    admin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void enableAggregate(Connection connection, String dataSpaceName) throws Exception {
        Admin admin = null;
        try {
            admin = connection.getAdmin();
            TableName tbName = TableName.valueOf((String)dataSpaceName);
            HTableDescriptor htd = admin.getTableDescriptor(tbName);
            htd.addCoprocessor(AggregateImplementation.class.getName());
            admin.modifyTable(tbName, htd);
            admin.enableTable(tbName);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (admin != null) {
                try {
                    admin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDataSpaceIfExist(Connection connection, String dataSpaceName) throws Exception {
        try (Admin admin = null;){
            admin = connection.getAdmin();
            TableName tbName = TableName.valueOf((String)dataSpaceName);
            if (admin.tableExists(tbName)) {
                admin.disableTable(tbName);
                admin.deleteTable(tbName);
            }
            exsitSpace.remove(dataSpaceName);
        }
    }

    public static void updateById(RDTable rdTable, String recordId, Map<String, Object> updateRecord) throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        Map<String, RDColumn> tableCols = rdTable.getRdColumns();
        RDSchema rdSchema = rdTable.getRdSchema();
        String recordRowKey = rdSchema.getUserId() + "_" + rdTable.getRdSchema().getSeq() + "_" + rdTable.getSeq() + "_" + "data" + "_" + recordId;
        Put put = new Put(Bytes.toBytes((String)recordRowKey));
        Delete delete = new Delete(Bytes.toBytes((String)recordRowKey));
        Iterator<Map.Entry<String, Object>> iterator = updateRecord.entrySet().iterator();
        RDColumn rdColumn = null;
        boolean hasSomeThingToDelete = false;
        while (iterator.hasNext()) {
            Map.Entry<String, Object> tmp = iterator.next();
            rdColumn = tableCols.get(tmp.getKey());
            if (rdColumn == null) continue;
            if (tmp.getValue() != null) {
                put.addColumn(RDConstants.FAMILY_BYTES, Bytes.toBytes((int)rdColumn.getSeq()), HbaseUtil.getBytesFromColumnVal(rdColumn, tmp.getValue()));
                continue;
            }
            hasSomeThingToDelete = true;
            delete.addColumn(RDConstants.FAMILY_BYTES, Bytes.toBytes((int)rdColumn.getSeq()));
        }
        table.put(put);
        if (hasSomeThingToDelete) {
            table.delete(delete);
        }
    }

    public static void moveRecordIntoRecycle(RDTable rdTable, String recordId, String operator) throws Exception {
        HbaseDBConnection hbaseDBConnection = HbaseThreadHolder.getInstance().getThreadDatas();
        HTable dataTable = hbaseDBConnection.getDataTable();
        HTable recycleDataTable = hbaseDBConnection.getRecycleDataTable();
        RDSchema rdSchema = rdTable.getRdSchema();
        String recordRowKey = rdSchema.getUserId() + "_" + rdTable.getRdSchema().getSeq() + "_" + rdTable.getSeq() + "_" + "data" + "_" + recordId;
        RDColumn updateDtColumn = null;
        RDColumn updateByColumn = null;
        for (RDColumn rdColumn : rdTable.getRdColumns().values()) {
            if (updateDtColumn == null && rdColumn.getName().equals("updateBy")) {
                updateDtColumn = rdColumn;
                continue;
            }
            if (updateByColumn != null || !rdColumn.getName().equals("updateDt")) continue;
            updateByColumn = rdColumn;
        }
        Put put = new Put(Bytes.toBytes((String)recordRowKey));
        Get getDeleteData = new Get(Bytes.toBytes((String)recordRowKey));
        Result r = dataTable.get(getDeleteData);
        Cell[] existData = r.rawCells();
        int cellLength = existData.length;
        if (cellLength > 0) {
            for (int i = 0; i < existData.length; ++i) {
                Cell tmp = existData[i];
                if (updateDtColumn != null && updateDtColumn.getSeq() == i) {
                    put.addColumn(RDConstants.FAMILY_BYTES, Bytes.toBytes((int)i), Bytes.toBytes((long)new Date().getTime()));
                    updateDtColumn = null;
                    continue;
                }
                if (updateByColumn != null && updateByColumn.getSeq() == i) {
                    put.addColumn(RDConstants.FAMILY_BYTES, Bytes.toBytes((int)i), Bytes.toBytes((String)operator));
                    updateDtColumn = null;
                    continue;
                }
                put.addColumn(RDConstants.FAMILY_BYTES, Bytes.toBytes((int)i), CellUtil.cloneValue((Cell)tmp));
            }
            recycleDataTable.put(put);
        }
        Delete delete = new Delete(Bytes.toBytes((String)recordRowKey));
        dataTable.delete(delete);
    }

    public static void deleteByRowKey(RDTable rdTable, String recordId) throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        RDSchema rdSchema = rdTable.getRdSchema();
        String recordRowKey = rdSchema.getUserId() + "_" + rdTable.getRdSchema().getSeq() + "_" + rdTable.getSeq() + "_" + "data" + "_" + recordId;
        Delete delete = new Delete(Bytes.toBytes((String)recordRowKey));
        table.delete(delete);
    }

    static {
        exsitSpace = new HashSet<String>();
        enableIndexSerach = true;
    }
}

