/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.bigdata.impl.hbase;

import cn.regionsoft.one.bigdata.impl.hbase.HbaseThreadHolder;
import cn.regionsoft.one.core.CommonUtil;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.AggregationClient;
import org.apache.hadoop.hbase.client.coprocessor.LongColumnInterpreter;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.util.Bytes;

public class HbaseDBConnection {
    private HTable dataTable;
    private boolean autoCommit = true;
    private Connection connection;
    private AggregationClient aggregationClient;
    private String dataSpaceName;
    private Configuration configuration;
    private HTable recycleDataTable;

    public HbaseDBConnection(Configuration configuration, String dataSpaceName) throws Exception {
        this.connection = ConnectionFactory.createConnection((Configuration)configuration);
        this.aggregationClient = new AggregationClient(configuration);
        this.dataSpaceName = dataSpaceName;
        this.configuration = configuration;
        TableName tbName = TableName.valueOf((String)this.dataSpaceName);
        this.dataTable = (HTable)this.connection.getTable(tbName);
        this.dataTable.setWriteBufferSize(0x600000L);
        String dataRecycleSpaceName = dataSpaceName + "_recycle";
        TableName recycleTbName = TableName.valueOf((String)dataRecycleSpaceName);
        this.recycleDataTable = (HTable)this.connection.getTable(recycleTbName);
        this.recycleDataTable.setWriteBufferSize(0x600000L);
    }

    public HbaseDBConnection(Connection connection, Configuration configuration, String dataSpaceName) throws Exception {
        this.connection = connection;
        this.aggregationClient = new AggregationClient(configuration);
        this.dataSpaceName = dataSpaceName;
        this.configuration = configuration;
        TableName tbName = TableName.valueOf((String)dataSpaceName);
        this.dataTable = (HTable)connection.getTable(tbName);
        this.dataTable.setWriteBufferSize(0x600000L);
        String dataRecycleSpaceName = dataSpaceName + "_recycle";
        TableName recycleTbName = TableName.valueOf((String)dataRecycleSpaceName);
        this.recycleDataTable = (HTable)connection.getTable(recycleTbName);
        this.recycleDataTable.setWriteBufferSize(0x600000L);
    }

    public void setAutoCommit(boolean autoPara) throws IOException {
        if (this.autoCommit == autoPara) {
            return;
        }
        if (autoPara) {
            this.dataTable.flushCommits();
            this.dataTable.setAutoFlushTo(true);
        } else {
            this.dataTable.setAutoFlushTo(false);
        }
        this.autoCommit = autoPara;
    }

    public HTable getDataTable() {
        return this.dataTable;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public AggregationClient getAggregationClient() {
        return this.aggregationClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectivity() throws Exception {
        Admin admin = null;
        try {
            admin = this.connection.getAdmin();
            TableName tbName = TableName.valueOf((String)this.dataSpaceName);
            admin.tableExists(tbName);
        }
        catch (Throwable e) {
            CommonUtil.closeQuietly((Closeable)this.connection);
            this.connection = ConnectionFactory.createConnection((Configuration)this.configuration);
            TableName tbName = TableName.valueOf((String)this.dataSpaceName);
            this.dataTable = (HTable)this.connection.getTable(tbName);
            this.dataTable.setWriteBufferSize(0x600000L);
            String dataRecycleSpaceName = this.dataSpaceName + "_recycle";
            TableName recycleTbName = TableName.valueOf((String)dataRecycleSpaceName);
            this.recycleDataTable = (HTable)this.connection.getTable(recycleTbName);
            this.recycleDataTable.setWriteBufferSize(0x600000L);
        }
        finally {
            CommonUtil.closeQuietly((Closeable)admin);
        }
        try {
            Scan scan = new Scan();
            scan.withStartRow(Bytes.toBytes((int)0));
            scan.withStopRow(Bytes.toBytes((int)0));
            scan.setRowPrefixFilter(Bytes.toBytes((int)0));
            this.aggregationClient.rowCount((Table)HbaseThreadHolder.getInstance().getThreadDatas().getDataTable(), (ColumnInterpreter)new LongColumnInterpreter(), scan);
        }
        catch (Throwable e) {
            CommonUtil.closeQuietly((Closeable)this.aggregationClient);
            this.aggregationClient = new AggregationClient(this.configuration);
        }
    }

    public HTable getRecycleDataTable() {
        return this.recycleDataTable;
    }
}

