/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.bigdata.criterias;

import cn.regionsoft.one.bigdata.core.exceptions.NotFoundException;
import cn.regionsoft.one.bigdata.core.object.RDColumn;
import cn.regionsoft.one.bigdata.core.object.RDIndex;
import cn.regionsoft.one.bigdata.core.object.RDTable;
import cn.regionsoft.one.bigdata.criterias.RDCondition;
import cn.regionsoft.one.bigdata.criterias.RDFilterType;
import cn.regionsoft.one.bigdata.criterias.indexfilter.RDChildIndexFilterInfo;
import cn.regionsoft.one.bigdata.criterias.indexfilter.RDIndexFilterInfo;
import cn.regionsoft.one.bigdata.criterias.indexfilter.RDRootIndexFilterInfo;
import cn.regionsoft.one.bigdata.enums.ConditionType;
import cn.regionsoft.one.bigdata.enums.DataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.util.Bytes;

public class RDCriteria {
    private RDCondition rdCondition;

    private RDCriteria() {
    }

    public RDCondition getRdCondition() {
        return this.rdCondition;
    }

    public void setRdCondition(RDCondition rdCondition) {
        this.rdCondition = rdCondition;
    }

    public static RDCriteria create(RDCondition rdCondition) {
        RDCriteria rdCriteria = new RDCriteria();
        rdCriteria.setRdCondition(rdCondition);
        return rdCriteria;
    }

    public FilterList toFilterList(RDTable rdTable) throws Exception {
        if (this.rdCondition == null) {
            return null;
        }
        this.optimize(rdTable);
        return RDCriteria.subToFilterList(this.rdCondition, rdTable, null);
    }

    private static FilterList subToFilterList(RDCondition rdCondition, RDTable rdTable, FilterList parentlist) throws Exception {
        if (rdCondition.getContitionType() == ConditionType.AND) {
            if (rdCondition.getChildConditions() == null || rdCondition.getChildConditions().length == 0) {
                return null;
            }
            FilterList result = null;
            FilterList list = new FilterList(FilterList.Operator.MUST_PASS_ALL);
            if (parentlist == null) {
                result = list;
            } else {
                parentlist.addFilter((Filter)list);
                result = parentlist;
            }
            for (RDCondition childCondition : rdCondition.getChildConditions()) {
                RDCriteria.subToFilterList(childCondition, rdTable, list);
            }
            return result;
        }
        if (rdCondition.getContitionType() == ConditionType.OR) {
            if (rdCondition.getChildConditions() == null || rdCondition.getChildConditions().length == 0) {
                return null;
            }
            FilterList result = null;
            FilterList list = new FilterList(FilterList.Operator.MUST_PASS_ONE);
            if (parentlist == null) {
                result = list;
            } else {
                parentlist.addFilter((Filter)list);
                result = parentlist;
            }
            for (RDCondition childCondition : rdCondition.getChildConditions()) {
                RDCriteria.subToFilterList(childCondition, rdTable, list);
            }
            return result;
        }
        FilterList result = parentlist;
        if (result == null) {
            throw new Exception("condition config error");
        }
        RDCondition.Para para = rdCondition.getPara();
        RDColumn rdColumn = rdTable.getRdColumn(para.getKey());
        if (rdColumn == null) {
            throw new NotFoundException("column not exists:" + para.getKey() + " in table " + rdTable.getName());
        }
        if (rdCondition.getContitionType() == ConditionType.EQUAL || rdCondition.getContitionType() == ConditionType.GT || rdCondition.getContitionType() == ConditionType.LT) {
            CompareFilter.CompareOp compareOp = null;
            if (rdCondition.getContitionType() == ConditionType.EQUAL) {
                compareOp = CompareFilter.CompareOp.EQUAL;
            }
            if (rdCondition.getContitionType() == ConditionType.GT) {
                compareOp = CompareFilter.CompareOp.GREATER;
            }
            if (rdCondition.getContitionType() == ConditionType.LT) {
                compareOp = CompareFilter.CompareOp.LESS;
            }
            SingleColumnValueFilter tmpFilter = null;
            if (rdColumn.getDataType() == DataType.STRING) {
                tmpFilter = new SingleColumnValueFilter(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)rdColumn.getSeq()), compareOp, Bytes.toBytes((String)((String)para.getValue())));
            } else if (rdColumn.getDataType() == DataType.INT) {
                int val = 0;
                if (para.getValue() instanceof Integer) {
                    val = (Integer)para.getValue();
                } else if (para.getValue() instanceof String) {
                    val = Integer.valueOf((String)para.getValue());
                }
                tmpFilter = new SingleColumnValueFilter(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)rdColumn.getSeq()), compareOp, Bytes.toBytes((int)val));
            } else if (rdColumn.getDataType() == DataType.LONG) {
                long val = 0L;
                if (para.getValue() instanceof Long) {
                    val = (Long)para.getValue();
                } else if (para.getValue() instanceof String) {
                    val = Long.valueOf((String)para.getValue());
                }
                tmpFilter = new SingleColumnValueFilter(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)rdColumn.getSeq()), compareOp, Bytes.toBytes((long)val));
            } else if (rdColumn.getDataType() == DataType.FLOAT) {
                float val = 0.0f;
                if (para.getValue() instanceof Float) {
                    val = ((Float)para.getValue()).floatValue();
                } else if (para.getValue() instanceof String) {
                    val = Float.valueOf((String)para.getValue()).floatValue();
                }
                tmpFilter = new SingleColumnValueFilter(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)rdColumn.getSeq()), compareOp, Bytes.toBytes((float)val));
            } else if (rdColumn.getDataType() == DataType.DOUBLE) {
                double val = 0.0;
                if (para.getValue() instanceof Double) {
                    val = (Double)para.getValue();
                } else if (para.getValue() instanceof String) {
                    val = Double.valueOf((String)para.getValue());
                }
                tmpFilter = new SingleColumnValueFilter(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)rdColumn.getSeq()), compareOp, Bytes.toBytes((double)val));
            } else if (rdColumn.getDataType() == DataType.BOOLEAN) {
                boolean val = false;
                if (para.getValue() instanceof Boolean) {
                    val = (Boolean)para.getValue();
                } else if (para.getValue() instanceof String) {
                    val = Boolean.valueOf((String)para.getValue());
                }
                tmpFilter = new SingleColumnValueFilter(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)rdColumn.getSeq()), compareOp, Bytes.toBytes((boolean)val));
            } else if (rdColumn.getDataType() == DataType.DATE) {
                long val = 0L;
                if (para.getValue() instanceof Date) {
                    val = ((Date)para.getValue()).getTime();
                }
                val = para.getValue() instanceof Long ? ((Long)para.getValue()).longValue() : ((Long)para.getValue()).longValue();
                tmpFilter = new SingleColumnValueFilter(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)rdColumn.getSeq()), compareOp, Bytes.toBytes((long)val));
            } else if (rdColumn.getDataType() == DataType.BIGDECIMAL) {
                tmpFilter = new SingleColumnValueFilter(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)rdColumn.getSeq()), compareOp, Bytes.toBytes((BigDecimal)((BigDecimal)para.getValue())));
            }
            result.addFilter((Filter)tmpFilter);
        } else if (rdCondition.getContitionType() == ConditionType.REGEX) {
            if (rdColumn.getDataType() == DataType.STRING) {
                RegexStringComparator comparator = new RegexStringComparator((String)para.getValue());
                SingleColumnValueFilter tmpFilter = new SingleColumnValueFilter(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)rdColumn.getSeq()), CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)comparator);
                result.addFilter((Filter)tmpFilter);
            }
        } else if (rdCondition.getContitionType() == ConditionType.CONTAIN) {
            if (rdColumn.getDataType() == DataType.STRING) {
                SubstringComparator comparator = new SubstringComparator((String)para.getValue());
                SingleColumnValueFilter tmpFilter = new SingleColumnValueFilter(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)rdColumn.getSeq()), CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)comparator);
                result.addFilter((Filter)tmpFilter);
            }
        } else if (rdCondition.getContitionType() == ConditionType.START_WITH) {
            if (rdColumn.getDataType() == DataType.STRING) {
                RegexStringComparator comparator = new RegexStringComparator((String)para.getValue());
                SingleColumnValueFilter tmpFilter = new SingleColumnValueFilter(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)rdColumn.getSeq()), CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)comparator);
                result.addFilter((Filter)tmpFilter);
            }
        } else if (rdCondition.getContitionType() == ConditionType.END_WITH && rdColumn.getDataType() == DataType.STRING) {
            RegexStringComparator comparator = new RegexStringComparator((String)para.getValue());
            SingleColumnValueFilter tmpFilter = new SingleColumnValueFilter(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)rdColumn.getSeq()), CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)comparator);
            result.addFilter((Filter)tmpFilter);
        }
        return result;
    }

    public RDRootIndexFilterInfo getIndexFilter(RDTable rdTable) throws Exception {
        Map<String, RDIndex> rdIndexes = rdTable.getRdIndexes();
        if (rdIndexes == null || rdIndexes.size() == 0) {
            return null;
        }
        this.optimize(rdTable);
        LinkedHashMap<String, Integer> indexColumnRealNames = new LinkedHashMap<String, Integer>();
        RDIndex rdIndex = RDCriteria.getRDIndex(this.rdCondition, rdTable, indexColumnRealNames);
        if (rdIndex == null) {
            System.err.println("No index found for data search operation");
            return null;
        }
        RDRootIndexFilterInfo rdIndexFilterInfo = this.getIndexFilterRegex(rdTable, rdIndex, indexColumnRealNames);
        return rdIndexFilterInfo;
    }

    private RDRootIndexFilterInfo getIndexFilterRegex(RDTable rdTable, RDIndex rdIndex, LinkedHashMap<String, Integer> indexColumnRealNames) throws Exception {
        String rowPrefix = rdTable.getRdSchema().getUserId() + "_" + rdTable.getRdSchema().getSeq() + "_" + rdTable.getSeq() + "_" + "index" + "_" + "data" + "_" + rdIndex.getSeq() + "_";
        RDRootIndexFilterInfo rdIndexFilterInfo = (RDRootIndexFilterInfo)RDCriteria.getRDIndexFilterInfo(rdTable, this.rdCondition, rowPrefix, indexColumnRealNames, true);
        System.out.println("CompareStr" + rdIndexFilterInfo.getCompareStr());
        System.out.println("rdIndexFilterInfo.getRowPrefix()=" + rdIndexFilterInfo.getRowPrefix());
        System.out.println("rdIndexFilterInfo.getRdFilterType()=" + rdIndexFilterInfo.getRdFilterType().name());
        System.out.println("RDCriteria-259:rdIndexFilterInfo.getStartRowKey()=" + rdIndexFilterInfo.getStartRowKey());
        System.out.println("rdIndexFilterInfo.getStopRowKey()=" + rdIndexFilterInfo.getStopRowKey());
        return rdIndexFilterInfo;
    }

    private static RDIndexFilterInfo getRDIndexFilterInfo(RDTable rdTable, RDCondition rdCondition, String rowPrefix, LinkedHashMap<String, Integer> indexColumnRealNames, boolean isRootNode) throws Exception {
        if (rdCondition.getContitionType() == ConditionType.AND || rdCondition.getContitionType() == ConditionType.OR) {
            if (rdCondition.getChildConditions() != null) {
                RDChildIndexFilterInfo[] childIndexFilterInfoArray = new RDChildIndexFilterInfo[indexColumnRealNames.size()];
                ArrayList<RDChildIndexFilterInfo> complexFilterInfoLs = null;
                HashMap<String, RDChildIndexFilterInfo> childIndexFilterInfoListMap = new HashMap<String, RDChildIndexFilterInfo>();
                for (RDCondition childCondition : rdCondition.getChildConditions()) {
                    RDChildIndexFilterInfo rdChildIndexFilterInfo = (RDChildIndexFilterInfo)RDCriteria.getRDIndexFilterInfo(rdTable, childCondition, rowPrefix, indexColumnRealNames, false);
                    if (rdChildIndexFilterInfo.getComplexFilterType() == null) {
                        childIndexFilterInfoListMap.put(rdChildIndexFilterInfo.getColumnName(), rdChildIndexFilterInfo);
                        continue;
                    }
                    if (complexFilterInfoLs == null) {
                        complexFilterInfoLs = new ArrayList<RDChildIndexFilterInfo>();
                        complexFilterInfoLs.add(rdChildIndexFilterInfo);
                        continue;
                    }
                    complexFilterInfoLs.add(rdChildIndexFilterInfo);
                }
                Iterator<Map.Entry<String, Integer>> iterator = indexColumnRealNames.entrySet().iterator();
                int index = 0;
                Map.Entry<String, Integer> tmpEntry = null;
                RDChildIndexFilterInfo tmpChildRDIndexFilterInfo = null;
                boolean hasSimpleFilter = false;
                while (iterator.hasNext()) {
                    tmpEntry = iterator.next();
                    childIndexFilterInfoArray[index] = tmpChildRDIndexFilterInfo = (RDChildIndexFilterInfo)childIndexFilterInfoListMap.get(tmpEntry.getKey());
                    if (tmpChildRDIndexFilterInfo != null) {
                        hasSimpleFilter = true;
                    }
                    ++index;
                }
                RDFilterType resultRdFilterType = null;
                String resultStartRowKey = "";
                String resultStopRowKey = "";
                String resultCompareStr = "";
                String resultRowPrefix = "";
                RDFilterType currentRdFilterType = null;
                if (hasSimpleFilter && childIndexFilterInfoArray[0] == null) {
                    resultRdFilterType = RDFilterType.REGEX;
                    resultStartRowKey = rowPrefix;
                }
                for (int i = 0; hasSimpleFilter && i < childIndexFilterInfoArray.length; ++i) {
                    tmpChildRDIndexFilterInfo = childIndexFilterInfoArray[i];
                    String tmpCompareStr = null;
                    if (tmpChildRDIndexFilterInfo == null) {
                        tmpCompareStr = ".*";
                        resultRdFilterType = RDFilterType.REGEX;
                        resultCompareStr = resultCompareStr + "_" + tmpCompareStr;
                        continue;
                    }
                    currentRdFilterType = tmpChildRDIndexFilterInfo.getRdFilterType();
                    tmpCompareStr = tmpChildRDIndexFilterInfo.getCompareStr();
                    if (currentRdFilterType == RDFilterType.EQUAL) {
                        if (resultRdFilterType == null) {
                            resultRdFilterType = currentRdFilterType;
                            resultStartRowKey = rowPrefix + tmpCompareStr + "_";
                            resultStopRowKey = resultStartRowKey + "~";
                            resultCompareStr = rowPrefix + tmpCompareStr;
                            continue;
                        }
                        if (resultRdFilterType == RDFilterType.EQUAL) {
                            resultCompareStr = resultCompareStr + "_" + tmpCompareStr;
                            resultStopRowKey = resultCompareStr + "_" + "~";
                            resultStartRowKey = resultCompareStr;
                            continue;
                        }
                        if (resultRdFilterType == RDFilterType.START_WITH) {
                            resultRdFilterType = RDFilterType.REGEX;
                            resultCompareStr = resultCompareStr + "_" + tmpCompareStr;
                            resultStopRowKey = resultStartRowKey + "~";
                            continue;
                        }
                        if (resultRdFilterType == RDFilterType.STOP_WITH) {
                            resultRdFilterType = RDFilterType.REGEX;
                            resultCompareStr = resultCompareStr + "_" + ".*" + tmpCompareStr;
                            resultStopRowKey = resultCompareStr + "_" + tmpCompareStr;
                            continue;
                        }
                        if (resultRdFilterType == RDFilterType.REGEX) {
                            resultRdFilterType = RDFilterType.REGEX;
                            resultCompareStr = resultCompareStr + "_" + tmpCompareStr;
                            continue;
                        }
                        if (resultRdFilterType != RDFilterType.GT) continue;
                        resultRdFilterType = RDFilterType.REGEX;
                        resultCompareStr = rowPrefix + ".*" + "_" + tmpCompareStr;
                        resultStopRowKey = rowPrefix + "~";
                        continue;
                    }
                    if (currentRdFilterType == RDFilterType.START_WITH) {
                        if (resultRdFilterType == null) {
                            resultRdFilterType = currentRdFilterType;
                            resultRowPrefix = rowPrefix + tmpCompareStr;
                            resultStartRowKey = rowPrefix + tmpCompareStr;
                            resultStopRowKey = resultStartRowKey + "~";
                            resultCompareStr = resultStartRowKey + ".*";
                            continue;
                        }
                        if (resultRdFilterType == RDFilterType.EQUAL) {
                            resultRdFilterType = RDFilterType.REGEX;
                            resultCompareStr = resultCompareStr + "_" + tmpCompareStr + ".*";
                            resultStartRowKey = resultStartRowKey + tmpCompareStr;
                            resultStopRowKey = resultStartRowKey + "~";
                            continue;
                        }
                        if (resultRdFilterType == RDFilterType.START_WITH) {
                            resultRdFilterType = RDFilterType.REGEX;
                            resultCompareStr = resultCompareStr + "_" + tmpCompareStr + ".*";
                            resultStopRowKey = null;
                            continue;
                        }
                        if (resultRdFilterType == RDFilterType.STOP_WITH) {
                            resultRdFilterType = RDFilterType.REGEX;
                            resultCompareStr = resultCompareStr + "_" + tmpCompareStr + ".*";
                            resultStopRowKey = null;
                            continue;
                        }
                        if (resultRdFilterType == RDFilterType.REGEX) {
                            resultRdFilterType = RDFilterType.REGEX;
                            resultCompareStr = resultCompareStr + "_" + tmpCompareStr + ".*";
                            continue;
                        }
                        if (resultRdFilterType != RDFilterType.GT) continue;
                        resultRdFilterType = RDFilterType.REGEX;
                        resultCompareStr = rowPrefix + ".*" + "_" + tmpCompareStr + ".*";
                        resultStopRowKey = rowPrefix + "~";
                        continue;
                    }
                    if (currentRdFilterType == RDFilterType.STOP_WITH) {
                        if (resultRdFilterType == null) {
                            resultRdFilterType = RDFilterType.REGEX;
                            resultStartRowKey = rowPrefix;
                            resultStopRowKey = rowPrefix + tmpCompareStr;
                            resultCompareStr = rowPrefix + ".*";
                            continue;
                        }
                        if (resultRdFilterType == RDFilterType.EQUAL) {
                            resultRdFilterType = RDFilterType.START_WITH;
                            resultRowPrefix = RDCriteria.biggerStr(resultRowPrefix, resultCompareStr + "_");
                            resultStopRowKey = resultCompareStr + "_" + tmpCompareStr;
                            continue;
                        }
                        if (resultRdFilterType == RDFilterType.START_WITH) {
                            resultRdFilterType = RDFilterType.REGEX;
                            resultRowPrefix = RDCriteria.biggerStr(resultRowPrefix, resultCompareStr + "_");
                            continue;
                        }
                        if (resultRdFilterType == RDFilterType.GT) {
                            resultRdFilterType = RDFilterType.REGEX;
                            resultCompareStr = resultCompareStr + ".*_.*";
                            continue;
                        }
                        if (resultRdFilterType == RDFilterType.REGEX) {
                            resultRdFilterType = RDFilterType.REGEX;
                            resultCompareStr = resultCompareStr + "_.*";
                            continue;
                        }
                        resultStopRowKey = null;
                        continue;
                    }
                    if (currentRdFilterType == RDFilterType.REGEX) {
                        resultStopRowKey = null;
                        if (resultRdFilterType == null) {
                            resultRdFilterType = currentRdFilterType;
                            resultStartRowKey = rowPrefix;
                            resultCompareStr = rowPrefix + tmpCompareStr;
                            continue;
                        }
                        if (resultRdFilterType == RDFilterType.EQUAL) {
                            resultRdFilterType = RDFilterType.REGEX;
                            resultCompareStr = resultCompareStr + "_" + tmpCompareStr;
                            continue;
                        }
                        if (resultRdFilterType == RDFilterType.START_WITH) {
                            resultRdFilterType = RDFilterType.REGEX;
                            resultCompareStr = resultCompareStr + "_" + tmpCompareStr;
                            continue;
                        }
                        if (resultRdFilterType == RDFilterType.STOP_WITH) {
                            resultRdFilterType = RDFilterType.REGEX;
                            resultCompareStr = resultCompareStr + "_" + ".*" + tmpCompareStr;
                            continue;
                        }
                        if (resultRdFilterType != RDFilterType.REGEX) continue;
                        resultRdFilterType = RDFilterType.REGEX;
                        resultCompareStr = resultCompareStr + "_" + tmpCompareStr;
                        continue;
                    }
                    if (currentRdFilterType != RDFilterType.GT) continue;
                    if (resultRdFilterType == null) {
                        resultRdFilterType = currentRdFilterType;
                        resultRowPrefix = rowPrefix;
                        resultStopRowKey = rowPrefix + "~";
                        resultStartRowKey = rowPrefix + tmpCompareStr;
                        resultCompareStr = rowPrefix;
                        continue;
                    }
                    if (resultRdFilterType == RDFilterType.EQUAL) {
                        resultRdFilterType = RDFilterType.GT;
                        resultRowPrefix = RDCriteria.biggerStr(resultRowPrefix, resultCompareStr);
                        resultStopRowKey = resultCompareStr + "_" + "~";
                        resultStartRowKey = resultCompareStr = resultCompareStr + "_" + tmpCompareStr;
                        continue;
                    }
                    if (resultRdFilterType == RDFilterType.START_WITH) {
                        resultRdFilterType = RDFilterType.REGEX;
                        resultRowPrefix = rowPrefix;
                        resultStopRowKey = resultStartRowKey + "~";
                        resultCompareStr = resultCompareStr + "_" + ".*";
                        continue;
                    }
                    if (resultRdFilterType == RDFilterType.STOP_WITH) {
                        resultRdFilterType = RDFilterType.REGEX;
                        resultCompareStr = resultCompareStr + "_" + ".*" + tmpCompareStr;
                        continue;
                    }
                    if (resultRdFilterType == RDFilterType.REGEX) {
                        resultRdFilterType = RDFilterType.REGEX;
                        resultCompareStr = resultCompareStr + "_" + ".*";
                        continue;
                    }
                    if (resultRdFilterType != RDFilterType.GT) continue;
                    resultRdFilterType = RDFilterType.REGEX;
                    resultStopRowKey = rowPrefix + "~";
                    resultCompareStr = rowPrefix + ".*" + "_" + ".*";
                }
                if (complexFilterInfoLs != null && complexFilterInfoLs.size() > 0) {
                    String complexCompareStr = resultCompareStr;
                    for (RDChildIndexFilterInfo complexFilterInfo : complexFilterInfoLs) {
                        if (rdCondition.getContitionType() == ConditionType.AND) {
                            resultStartRowKey = RDCriteria.biggerStr(complexFilterInfo.getStartRowKey(), resultStartRowKey);
                            resultStopRowKey = RDCriteria.smallerStr(complexFilterInfo.getStopRowKey(), resultStopRowKey);
                        } else {
                            resultStartRowKey = RDCriteria.smallerStr(complexFilterInfo.getStartRowKey(), resultStartRowKey);
                            resultStopRowKey = RDCriteria.biggerStr(complexFilterInfo.getStopRowKey(), resultStopRowKey);
                        }
                        if (complexFilterInfo.getRdFilterType() == RDFilterType.EQUAL || complexFilterInfo.getRdFilterType() == RDFilterType.REGEX || complexFilterInfo.getRdFilterType() == RDFilterType.START_WITH) {
                            if (rdCondition.getContitionType() == ConditionType.AND) {
                                complexCompareStr = "(?=(" + complexCompareStr + ")(" + complexFilterInfo.getCompareStr() + "))";
                                continue;
                            }
                            if (complexCompareStr.equals("")) {
                                complexCompareStr = complexFilterInfo.getCompareStr();
                                continue;
                            }
                            complexCompareStr = "(" + complexCompareStr + ")|(" + complexFilterInfo.getCompareStr() + ")";
                            continue;
                        }
                        if (complexFilterInfo.getRdFilterType() != RDFilterType.STOP_WITH) continue;
                    }
                    resultCompareStr = complexCompareStr;
                    resultRdFilterType = RDFilterType.REGEX;
                }
                if (isRootNode) {
                    RDRootIndexFilterInfo result = new RDRootIndexFilterInfo();
                    if (rdCondition.getContitionType() == ConditionType.AND) {
                        result.setComplexFilterType(RDFilterType.AND);
                    } else if (rdCondition.getContitionType() == ConditionType.OR) {
                        result.setComplexFilterType(RDFilterType.OR);
                    }
                    result.setRowPrefix(resultRowPrefix);
                    result.setStartRowKey(resultStartRowKey);
                    result.setStopRowKey(resultStopRowKey);
                    result.setCompareStr(resultCompareStr);
                    result.setRdFilterType(resultRdFilterType);
                    return result;
                }
                RDChildIndexFilterInfo result = new RDChildIndexFilterInfo();
                if (rdCondition.getContitionType() == ConditionType.AND) {
                    result.setComplexFilterType(RDFilterType.AND);
                } else if (rdCondition.getContitionType() == ConditionType.OR) {
                    result.setComplexFilterType(RDFilterType.OR);
                }
                result.setRowPrefix(resultRowPrefix);
                result.setStartRowKey(resultStartRowKey);
                result.setStopRowKey(resultStopRowKey);
                result.setCompareStr(resultCompareStr);
                result.setRdFilterType(resultRdFilterType);
                return result;
            }
            return null;
        }
        if (isRootNode) {
            return RDCriteria.getRootSingleColumnIndexFilter(rowPrefix, rdCondition);
        }
        return RDCriteria.getChildColumnIndexFilter(rowPrefix, rdCondition);
    }

    private static RDChildIndexFilterInfo getChildColumnIndexFilter(String rowPrefix, RDCondition rdCondition) {
        RDChildIndexFilterInfo result = new RDChildIndexFilterInfo();
        if (rdCondition.getContitionType() == ConditionType.EQUAL) {
            result.setRdFilterType(RDFilterType.EQUAL);
            result.setColumnName(rdCondition.getPara().getKey());
            result.setCompareStr(String.valueOf(rdCondition.getPara().getValue()));
        } else if (rdCondition.getContitionType() == ConditionType.GT) {
            result.setRdFilterType(RDFilterType.GT);
            result.setColumnName(rdCondition.getPara().getKey());
            result.setCompareStr(String.valueOf(rdCondition.getPara().getValue()));
        } else if (rdCondition.getContitionType() == ConditionType.START_WITH) {
            result.setRdFilterType(RDFilterType.START_WITH);
            result.setColumnName(rdCondition.getPara().getKey());
            result.setCompareStr(String.valueOf(rdCondition.getPara().getValue()));
        } else if (rdCondition.getContitionType() == ConditionType.LT) {
            result.setRdFilterType(RDFilterType.STOP_WITH);
            result.setColumnName(rdCondition.getPara().getKey());
            result.setCompareStr(String.valueOf(rdCondition.getPara().getValue()));
        } else if (rdCondition.getContitionType() == ConditionType.CONTAIN) {
            result.setRdFilterType(RDFilterType.REGEX);
            result.setColumnName(rdCondition.getPara().getKey());
            result.setCompareStr(".*" + rdCondition.getPara().getValue() + ".*");
        } else if (rdCondition.getContitionType() == ConditionType.END_WITH) {
            result.setRdFilterType(RDFilterType.REGEX);
            result.setColumnName(rdCondition.getPara().getKey());
            result.setCompareStr(".*" + rdCondition.getPara().getValue());
        } else if (rdCondition.getContitionType() == ConditionType.REGEX) {
            result.setRdFilterType(RDFilterType.REGEX);
            result.setColumnName(rdCondition.getPara().getKey());
            result.setCompareStr(String.valueOf(rdCondition.getPara().getValue()));
        }
        return result;
    }

    private static RDRootIndexFilterInfo getRootSingleColumnIndexFilter(String rowPrefix, RDCondition rdCondition) {
        RDRootIndexFilterInfo result = new RDRootIndexFilterInfo();
        if (rdCondition.getContitionType() == ConditionType.EQUAL) {
            result.setRdFilterType(RDFilterType.START_WITH);
            result.setStartRowKey(rowPrefix + String.valueOf(rdCondition.getPara().getValue()));
        } else if (rdCondition.getContitionType() == ConditionType.GT) {
            result.setRdFilterType(RDFilterType.START_WITH);
            result.setStartRowKey(rowPrefix + rdCondition.getPara().getValue() + "!");
        } else if (rdCondition.getContitionType() == ConditionType.START_WITH) {
            result.setRdFilterType(RDFilterType.START_WITH);
            result.setStartRowKey(rowPrefix + String.valueOf(rdCondition.getPara().getValue()));
        } else if (rdCondition.getContitionType() == ConditionType.LT) {
            result.setRdFilterType(RDFilterType.STOP_WITH);
            result.setStartRowKey(rowPrefix);
            result.setStopRowKey(rowPrefix + String.valueOf(rdCondition.getPara().getValue()));
        } else if (rdCondition.getContitionType() == ConditionType.CONTAIN) {
            result.setRdFilterType(RDFilterType.REGEX);
            result.setStartRowKey(rowPrefix);
            result.setCompareStr(rowPrefix + ".*" + rdCondition.getPara().getValue() + ".*");
        } else if (rdCondition.getContitionType() == ConditionType.END_WITH) {
            result.setRdFilterType(RDFilterType.REGEX);
            result.setStartRowKey(rowPrefix);
            result.setCompareStr(rowPrefix + ".*" + rdCondition.getPara().getValue());
        } else if (rdCondition.getContitionType() == ConditionType.REGEX) {
            result.setRdFilterType(RDFilterType.REGEX);
            result.setStartRowKey(rowPrefix);
            result.setCompareStr(rowPrefix + String.valueOf(rdCondition.getPara().getValue()));
        }
        return result;
    }

    private static RDIndex getRDIndex(RDCondition rdCondition, RDTable rdTable, LinkedHashMap<String, Integer> indexColumnRealNames) throws Exception {
        HashSet<String> columnNames = new HashSet<String>();
        RDCriteria.fillConditionColumnNames(rdCondition, columnNames);
        RDColumn rdColumn = null;
        ArrayList<RDColumn> indexColumns = new ArrayList<RDColumn>();
        for (String rdColNm : columnNames) {
            rdColumn = rdTable.getRdColumns().get(rdColNm);
            if (rdColumn == null) {
                throw new NotFoundException("Column " + rdColNm + " is not found");
            }
            indexColumns.add(rdColumn);
        }
        Collections.sort(indexColumns, new Comparator<RDColumn>(){

            @Override
            public int compare(RDColumn o1, RDColumn o2) {
                if (o1.getSeq() > o2.getSeq()) {
                    return 1;
                }
                if (o1.getSeq() < o2.getSeq()) {
                    return -1;
                }
                return 0;
            }
        });
        StringBuilder indexName = new StringBuilder();
        int columnsCount = indexColumns.size();
        for (int i = 0; i < columnsCount; ++i) {
            indexName.append(((RDColumn)indexColumns.get(i)).getSeq());
            if (i == columnsCount - 1) continue;
            indexName.append("_");
        }
        RDIndex rdIndex = rdTable.getRdIndexes().get(indexName.toString());
        if (rdIndex != null) {
            for (RDColumn tmpColumn : indexColumns) {
                indexColumnRealNames.put(tmpColumn.getName(), tmpColumn.getSeq());
            }
        }
        return rdIndex;
    }

    private static void fillConditionColumnNames(RDCondition rdCondition, HashSet<String> columnNames) {
        if (rdCondition.getContitionType() == ConditionType.AND || rdCondition.getContitionType() == ConditionType.OR) {
            for (RDCondition childCondition : rdCondition.getChildConditions()) {
                RDCriteria.fillConditionColumnNames(childCondition, columnNames);
            }
        } else {
            columnNames.add(rdCondition.getPara().getKey());
        }
    }

    public static void main(String[] args) {
        String str = "Windows 3.1123123";
        String regEx = "((?=(?!(Windows1 .*)))(.*3.1123123))";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(str);
        boolean rs = matcher.matches();
        System.out.println(rs);
    }

    public static String biggerStr(String str1, String str2) {
        if (str1 == null || str1.equals("")) {
            return str2;
        }
        if (str2 == null || str2.equals("")) {
            return str1;
        }
        if (str1.compareTo(str2) > 0) {
            return str1;
        }
        return str2;
    }

    public static String smallerStr(String str1, String str2) {
        if (str1 == null || str1.equals("")) {
            return str2;
        }
        if (str2 == null || str2.equals("")) {
            return str1;
        }
        if (str1.compareTo(str2) > 0) {
            return str2;
        }
        return str1;
    }

    public void optimize(RDTable rdTable) {
        this.rdCondition = RDCriteria.subOptimize(rdTable, this.rdCondition, true);
    }

    private static RDCondition subOptimize(RDTable rdTable, RDCondition parendtRdCondition, boolean isRootNode) {
        RDCondition[] childConditions = parendtRdCondition.getChildConditions();
        if (childConditions == null || childConditions.length == 0) {
            return parendtRdCondition;
        }
        ConditionType parentRdConditionType = parendtRdCondition.getContitionType();
        ArrayList<RDCondition> newChildConditions = new ArrayList<RDCondition>();
        if (parentRdConditionType == ConditionType.OR) {
            for (RDCondition childCondition : childConditions) {
                RDCondition rdCondition = RDCondition.or(childCondition);
                newChildConditions.add(rdCondition);
            }
            parendtRdCondition.setChildConditions(newChildConditions.toArray(new RDCondition[newChildConditions.size()]));
            return parendtRdCondition;
        }
        HashMap<String, RDCondition> columnsSet = new HashMap<String, RDCondition>();
        ArrayList<RDCondition> duplicateChildConditions = new ArrayList<RDCondition>();
        for (RDCondition childCondition : childConditions) {
            RDCondition tmpRDCondition = RDCriteria.subOptimize(rdTable, childCondition, false);
            if (tmpRDCondition.getContitionType() == ConditionType.AND) {
                RDCondition[] childsOfChild = tmpRDCondition.getChildConditions();
                for (int i = 0; i < childsOfChild.length; ++i) {
                    RDCriteria.handleChildCondition(newChildConditions, duplicateChildConditions, columnsSet, childsOfChild[i]);
                }
                continue;
            }
            RDCriteria.handleChildCondition(newChildConditions, duplicateChildConditions, columnsSet, tmpRDCondition);
        }
        if (duplicateChildConditions.size() > 0) {
            newChildConditions.add(RDCriteria.resolveDuplicate(duplicateChildConditions, parentRdConditionType));
        }
        parendtRdCondition.setChildConditions(newChildConditions.toArray(new RDCondition[newChildConditions.size()]));
        return parendtRdCondition;
    }

    private static RDCondition resolveDuplicate(List<RDCondition> duplicateChildConditions, ConditionType parentRdConditionType) {
        RDCondition rdCondition = null;
        rdCondition = parentRdConditionType == ConditionType.AND ? RDCondition.and(duplicateChildConditions.toArray(new RDCondition[duplicateChildConditions.size()])) : RDCondition.or(duplicateChildConditions.toArray(new RDCondition[duplicateChildConditions.size()]));
        RDCondition[] childConditions = rdCondition.getChildConditions();
        ArrayList<RDCondition> newChildConditions = new ArrayList<RDCondition>();
        HashMap<String, RDCondition> columnsSet = new HashMap<String, RDCondition>();
        duplicateChildConditions = new ArrayList<RDCondition>();
        for (RDCondition tmpRDCondition : childConditions) {
            RDCriteria.handleChildCondition(newChildConditions, duplicateChildConditions, columnsSet, tmpRDCondition);
        }
        if (duplicateChildConditions.size() > 0) {
            newChildConditions.add(RDCriteria.resolveDuplicate(duplicateChildConditions, parentRdConditionType));
        }
        return rdCondition;
    }

    private static void handleChildCondition(List<RDCondition> newChildConditions, List<RDCondition> duplicateChildConditions, Map<String, RDCondition> columnsSet, RDCondition tmpRDCondition) {
        if (tmpRDCondition.getPara() != null && !columnsSet.containsKey(tmpRDCondition.getPara().getKey())) {
            newChildConditions.add(tmpRDCondition);
            columnsSet.put(tmpRDCondition.getPara().getKey(), tmpRDCondition);
        } else {
            RDCondition exsit = columnsSet.get(tmpRDCondition.getPara().getKey());
            if (exsit.getContitionType() != tmpRDCondition.getContitionType() || !exsit.getPara().getKey().equals(tmpRDCondition.getPara().getKey()) || !exsit.getPara().getValue().equals(tmpRDCondition.getPara().getValue())) {
                duplicateChildConditions.add(tmpRDCondition);
            }
        }
    }
}

