/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.bigdata.core.object;

import cn.regionsoft.one.bigdata.core.exceptions.ExistException;
import cn.regionsoft.one.bigdata.core.exceptions.NotFoundException;
import cn.regionsoft.one.bigdata.core.object.RDColumn;
import cn.regionsoft.one.bigdata.core.object.RDIndex;
import cn.regionsoft.one.bigdata.core.object.RDSchema;
import cn.regionsoft.one.bigdata.enums.DataType;
import cn.regionsoft.one.bigdata.impl.RDObject;
import cn.regionsoft.one.bigdata.impl.hbase.HbaseThreadHolder;
import cn.regionsoft.one.bigdata.impl.hbase.HbaseUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class RDTable
extends RDObject {
    private RDSchema rdSchema;
    private Map<String, RDColumn> rdColumns = new LinkedHashMap<String, RDColumn>();
    private Map<Integer, String> columnIndexToNameMap = new LinkedHashMap<Integer, String>();
    private int seq;
    private Map<String, RDIndex> rdIndexes = new LinkedHashMap<String, RDIndex>();

    public RDTable(RDSchema rdSchema, String rdTableName, int seq) {
        this.name = rdTableName;
        this.rdSchema = rdSchema;
        this.seq = seq;
    }

    public void createRdColumn(String rdColumnNm, String label, DataType dataType) throws Exception {
        RDColumn rdColumn = HbaseUtil.createRdColumn(this, rdColumnNm, label, dataType);
        this.rdColumns.put(rdColumnNm, rdColumn);
        this.columnIndexToNameMap.put(rdColumn.getSeq(), rdColumn.getName());
    }

    public void deleteRDColumn(String rdColumnNm) throws Exception {
        RDTable.deleteRDColumn(this, rdColumnNm);
        RDColumn rdColumn = this.rdColumns.remove(rdColumnNm);
        this.columnIndexToNameMap.remove(rdColumn.getSeq());
    }

    public boolean createRdIndex(String ... rdColumnNms) throws Exception {
        if (rdColumnNms == null || rdColumnNms.length == 0) {
            throw new Exception("rdColumnNms is empty");
        }
        RDColumn rdColumn = null;
        ArrayList<RDColumn> indexColumns = new ArrayList<RDColumn>();
        for (String rdColNm : rdColumnNms) {
            rdColumn = this.rdColumns.get(rdColNm);
            if (rdColumn == null) {
                System.err.println("Column " + rdColNm + " is not found");
                return false;
            }
            indexColumns.add(rdColumn);
        }
        String indexName = this.genIndexName(indexColumns);
        try {
            HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
            int tableSeq = this.getSeq();
            String logicIndexKey = this.getRdSchema().getUserId() + "_" + this.getRdSchema().getSeq() + "_" + tableSeq + "_" + "index";
            String logicIndexFlagKey = logicIndexKey + "_" + "enable";
            int indexSeq = HbaseUtil.createMetaData(new String[]{logicIndexKey}, logicIndexFlagKey, new String[]{indexName}, 0);
            RDTable.genIndexData(table, this, String.valueOf(indexSeq), indexColumns);
            RDIndex rdIndex = new RDIndex(indexName, indexSeq);
            this.rdIndexes.put(indexName, rdIndex);
            return true;
        }
        catch (ExistException existException) {
            StringBuilder sb = new StringBuilder("Index exsits for ");
            System.err.println(sb.toString());
            return false;
        }
    }

    public boolean deleteRdIndex(String ... rdColumnNms) throws Exception {
        if (rdColumnNms == null || rdColumnNms.length == 0) {
            throw new Exception("rdColumnNms is empty");
        }
        RDColumn rdColumn = null;
        ArrayList<RDColumn> indexColumns = new ArrayList<RDColumn>();
        for (String rdColNm : rdColumnNms) {
            rdColumn = this.rdColumns.get(rdColNm);
            if (rdColumn == null) {
                return false;
            }
            indexColumns.add(rdColumn);
        }
        String indexName = this.genIndexName(indexColumns);
        RDIndex rdIndex = this.rdIndexes.get(indexName);
        if (rdIndex == null) {
            System.err.println("index not found");
            return false;
        }
        RDTable.deleteRdIndex(this, rdIndex);
        this.rdIndexes.remove(indexName);
        return true;
    }

    public RDSchema getRdSchema() {
        return this.rdSchema;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public Map<String, RDColumn> getRdColumns() {
        return this.rdColumns;
    }

    public RDColumn getRdColumn(String rdColumnName) {
        return this.rdColumns.get(rdColumnName);
    }

    public Map<String, RDIndex> getRdIndexes() {
        return this.rdIndexes;
    }

    private String genIndexName(List<RDColumn> indexColumns) throws NotFoundException {
        Collections.sort(indexColumns, new Comparator<RDColumn>(){

            @Override
            public int compare(RDColumn o1, RDColumn o2) {
                if (o1.getSeq() > o2.getSeq()) {
                    return 1;
                }
                if (o1.getSeq() < o2.getSeq()) {
                    return -1;
                }
                return 0;
            }
        });
        StringBuilder indexNameBuilder = new StringBuilder();
        int columnsCount = indexColumns.size();
        for (int i = 0; i < columnsCount; ++i) {
            indexNameBuilder.append(indexColumns.get(i).getSeq());
            if (i == columnsCount - 1) continue;
            indexNameBuilder.append("_");
        }
        return indexNameBuilder.toString();
    }

    public void registerColumn(RDColumn rdColumn) {
        this.rdColumns.put(rdColumn.getName(), rdColumn);
        this.columnIndexToNameMap.put(rdColumn.getSeq(), rdColumn.getName());
    }

    public void registerIndex(RDIndex rdIndex) {
        this.rdIndexes.put(rdIndex.getName(), rdIndex);
    }

    public void refresh() throws Exception {
        RDTable rdTable = HbaseUtil.getRdTable(this.rdSchema, this.name);
        this.rdColumns = rdTable.getRdColumns();
        this.rdIndexes = rdTable.getRdIndexes();
        this.columnIndexToNameMap = rdTable.getColumnIndexToNameMap();
    }

    public void insert(Map<String, Object> newRecord) throws Exception {
        HbaseUtil.insert(this, newRecord);
    }

    public Map<Integer, String> getColumnIndexToNameMap() {
        return this.columnIndexToNameMap;
    }

    public void setColumnIndexToNameMap(Map<Integer, String> columnIndexToNameMap) {
        this.columnIndexToNameMap = columnIndexToNameMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void genIndexData(HTable table, RDTable rdTable, String indexSeq, List<RDColumn> indexColumns) throws Exception {
        int pageSize = 200;
        int insertBatchSize = 1000;
        Scan scan = new Scan();
        PageFilter pageFilter = new PageFilter((long)(pageSize + 1));
        scan.setFilter((Filter)pageFilter);
        scan.setRowPrefixFilter(Bytes.toBytes((String)(rdTable.getRdSchema().getUserId() + "_" + rdTable.getRdSchema().getSeq() + "_" + rdTable.getSeq() + "_" + "data")));
        String startRowKey = null;
        String rowKey = null;
        String recordId = null;
        String indexKeyPrefix = rdTable.getRdSchema().getUserId() + "_" + rdTable.getRdSchema().getSeq() + "_" + rdTable.getSeq() + "_" + "index" + "_" + "data" + "_" + indexSeq + "_";
        ArrayList<Put> puts = new ArrayList<Put>();
        while (true) {
            ResultScanner resultScanner = table.getScanner(scan);
            int count = 0;
            try {
                for (Result resRow : resultScanner) {
                    if (++count == pageSize + 1) {
                        startRowKey = Bytes.toString((byte[])resRow.getRow());
                        scan.setStartRow(startRowKey.getBytes());
                        break;
                    }
                    rowKey = Bytes.toString((byte[])resRow.getRow());
                    recordId = rowKey.substring(rowKey.lastIndexOf("_") + 1);
                    StringBuilder indexKey = new StringBuilder();
                    indexKey.append(indexKeyPrefix);
                    for (RDColumn rdColumn : indexColumns) {
                        Cell tmpCell = resRow.getColumnLatestCell(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)rdColumn.getSeq()));
                        indexKey.append(String.valueOf(HbaseUtil.getColumnValFromCell(rdColumn, tmpCell)));
                        indexKey.append("_");
                    }
                    indexKey.append(recordId);
                    Put tableInfoOp = new Put(Bytes.toBytes((String)indexKey.toString()));
                    tableInfoOp.addColumn(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)0), Bytes.toBytes((long)0L));
                    puts.add(tableInfoOp);
                    if (puts.size() <= insertBatchSize) continue;
                    table.put(puts);
                    puts = new ArrayList();
                }
                if (count >= pageSize + 1) continue;
            }
            finally {
                resultScanner.close();
                continue;
            }
            break;
        }
        if (puts.size() > 0) {
            table.put(puts);
        }
    }

    private static boolean deleteRDColumn(RDTable rdTable, String rdColumnNm) throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        RDColumn rdColumn = rdTable.getRdColumn(rdColumnNm);
        if (rdColumn == null) {
            rdTable.refresh();
            rdColumn = rdTable.getRdColumn(rdColumnNm);
        }
        if (rdColumn == null) {
            System.err.println("Column not found : " + rdColumnNm);
            return false;
        }
        Iterator<String> iterator = rdTable.getRdIndexes().keySet().iterator();
        String indexName = null;
        String[] tmpArray = null;
        block0: while (iterator.hasNext()) {
            indexName = iterator.next();
            for (String tmpStr : tmpArray = indexName.split("_")) {
                if (Integer.valueOf(tmpStr).intValue() != rdColumn.getSeq()) continue;
                RDTable.deleteRdIndex(rdTable, rdTable.getRdIndexes().get(indexName));
                continue block0;
            }
        }
        int tableSeq = rdTable.getSeq();
        String logicColsFlagKey = rdTable.getRdSchema().getUserId() + "_" + rdTable.getRdSchema().getSeq() + "_" + tableSeq + "_" + "cols" + "_" + "enable";
        Get get = new Get(logicColsFlagKey.getBytes());
        Result r = table.get(get);
        Cell cell = r.getColumnLatestCell(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)rdColumn.getSeq()));
        String flag = Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell));
        if ("1".equals(flag)) {
            Put putOp = new Put(Bytes.toBytes((String)logicColsFlagKey.toString()));
            putOp.addColumn(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)rdColumn.getSeq()), Bytes.toBytes((String)"0"));
            table.put(putOp);
            return true;
        }
        System.err.println("No Column found for deletion");
        return false;
    }

    private static boolean deleteRdIndex(RDTable rdTable, RDIndex rdIndex) throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        int tableSeq = rdTable.getSeq();
        String logicIndexFlagKey = rdTable.getRdSchema().getUserId() + "_" + rdTable.getRdSchema().getSeq() + "_" + tableSeq + "_" + "index" + "_" + "enable";
        Get get = new Get(logicIndexFlagKey.getBytes());
        Result r = table.get(get);
        Cell cell = r.getColumnLatestCell(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)rdIndex.getSeq()));
        String flag = Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell));
        if ("1".equals(flag)) {
            RDTable.deleteIndexData(rdTable, rdIndex.getSeq());
            Put putOp = new Put(Bytes.toBytes((String)logicIndexFlagKey.toString()));
            putOp.addColumn(Bytes.toBytes((String)"fm0"), Bytes.toBytes((int)rdIndex.getSeq()), Bytes.toBytes((String)"0"));
            table.put(putOp);
            return true;
        }
        System.err.println("No index found for deletion");
        return false;
    }

    private static void deleteIndexData(RDTable rdTable, int indexSeq) throws Exception {
        HTable table = HbaseThreadHolder.getInstance().getThreadDatas().getDataTable();
        String indexDataStartKey = rdTable.getRdSchema().getUserId() + "_" + rdTable.getRdSchema().getSeq() + "_" + rdTable.getSeq() + "_" + "index" + "_" + "data" + "_" + indexSeq;
        HbaseUtil.deleteByRowKeyStartWith(table, indexDataStartKey);
    }
}

