/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.udp.mqtt;

import com.ds.cluster.ServerNode;
import com.ds.cluster.udp.ClusterEvent;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.engine.ConnectInfo;
import com.ds.org.Person;
import com.ds.org.PersonNotFoundException;
import com.ds.server.JDSServer;
import com.ds.server.JDSUDPServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.udp.UDPServerEventTask;
import com.ds.web.RemoteConnectionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class RepeatMqttMsg
implements Runnable {
    private static final Log logger = LogFactory.getLog((String)"JDS", RepeatMqttMsg.class);
    private final String subsystemCode;
    private final ClusterEvent event;

    public RepeatMqttMsg(ClusterEvent event, String subsystemCode) {
        this.subsystemCode = subsystemCode;
        this.event = event;
    }

    @Override
    public void run() {
        ServerNode remoteServerBean = JDSServer.getClusterClient().getServerNodeById(this.subsystemCode);
        ExecutorService service = RemoteConnectionManager.getConntctionService((String)("RepeatSeverMsg[" + remoteServerBean.getId() + "]"));
        try {
            ServerNode currServerBean = JDSServer.getInstance().getCurrServerBean();
            if (this.event.getEventId() == null) {
                this.event.setMsgId(UUID.randomUUID().toString());
            }
            ArrayList<UDPServerEventTask> taskList = new ArrayList<UDPServerEventTask>();
            if (currServerBean.getType() != null && currServerBean.getType().equals((Object)"main")) {
                List systems = JDSServer.getClusterClient().getAllServer();
                for (ServerNode serverNode : systems) {
                    if (serverNode.getAdminPersonId() == null) continue;
                    try {
                        Set personIds = remoteServerBean.getAdminPersonIds();
                        for (String personId : personIds) {
                            Person toPerson = OrgManagerFactory.getOrgManager().getPersonByAccount(personId);
                            ConnectInfo connInfo = new ConnectInfo(toPerson.getID(), toPerson.getAccount(), toPerson.getPassword());
                            Set sessionHandleList = JDSServer.getInstance().getSessionHandleList(connInfo);
                            Set<String> serverKeys = JDSUDPServer.getInstance().getRepeatEventKey(serverNode.getId());
                            if (!serverKeys.contains(this.event.getExpression()) || sessionHandleList == null || sessionHandleList.size() <= 0) continue;
                            taskList.add(new UDPServerEventTask(serverNode.getId(), this.event.clone()));
                        }
                    }
                    catch (PersonNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
            logger.info((Object)("taskList  =======size=" + taskList.size()));
            List tasks = service.invokeAll(taskList);
            for (Future future : tasks) {
                List list = (List)future.get(5L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

