/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.udp;

import com.alibaba.fastjson.JSONObject;
import com.ds.cluster.udp.ClusterCommand;
import com.ds.common.ConfigCode;
import com.ds.common.JDSException;
import com.ds.common.MsgStatus;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.engine.ConnectionHandle;
import com.ds.engine.JDSSessionHandle;
import com.ds.server.JDSClientService;
import com.ds.server.JDSServer;
import com.ds.server.udp.AbstractUDPHandle;
import com.ds.web.ConnectionLogFactory;
import com.ds.web.RuntimeLog;
import java.util.ArrayList;
import java.util.concurrent.Callable;

class SendCommandMsgTask
implements Callable<Boolean> {
    private final JDSSessionHandle serverhandle;
    private final ClusterCommand cloneevent;
    private final String sysCode;
    private static final Log logger = LogFactory.getLog((String)"JDS", SendCommandMsgTask.class);

    SendCommandMsgTask(JDSSessionHandle serverhandle, ClusterCommand cloneevent, String sysCode) {
        this.serverhandle = serverhandle;
        this.cloneevent = cloneevent;
        this.sysCode = sysCode;
    }

    @Override
    public Boolean call() {
        block14: {
            ArrayList<String> portList = new ArrayList<String>();
            try {
                JDSClientService client = JDSServer.getInstance().getJDSClientService(this.serverhandle, ConfigCode.app);
                ConnectionHandle cnnectionHandle = client.getConnectionHandle();
                if (!(cnnectionHandle instanceof AbstractUDPHandle)) break block14;
                AbstractUDPHandle udpCnnectionHandle = (AbstractUDPHandle)client.getConnectionHandle();
                String key = udpCnnectionHandle.getIp() + ":" + udpCnnectionHandle.getPort();
                logger.info((Object)("msg cnnectionHandle =======key=[" + key + "]" + (cnnectionHandle instanceof AbstractUDPHandle)));
                if (client.getConnectInfo() == null || portList.contains(key) || udpCnnectionHandle.getIp() == null) break block14;
                String msgId = this.cloneevent.getMsgId();
                String token = this.cloneevent.getToken();
                RuntimeLog log = ConnectionLogFactory.getInstance().createLog(token, "UDP://" + key + ":[" + this.sysCode + "]", this.cloneevent.getCommand() + "[" + this.cloneevent.getEventId() + "]", msgId);
                String eventStr = JSONObject.toJSONString((Object)this.cloneevent);
                log.setStartTime(System.currentTimeMillis());
                log.setRequestJson(eventStr);
                client.getConnectionHandle().send(eventStr);
                portList.add(key);
                int times = 1;
                for (int k = 0; log.getStatus().equals((Object)MsgStatus.NORMAL) && k < this.cloneevent.getTimeout(); k += k * 2) {
                    try {
                        Thread.sleep(2L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (log.getStatus().equals((Object)MsgStatus.NORMAL)) {
                    switch (this.cloneevent.getDeadLine()) {
                        case GOON: {
                            return true;
                        }
                        case STOP: {
                            return false;
                        }
                        case DELAY: {
                            while (log.getStatus().equals((Object)MsgStatus.NORMAL) && times < this.cloneevent.getMaxtimes()) {
                                client.getConnectionHandle().send(eventStr);
                                ++times;
                                try {
                                    Thread.sleep(this.cloneevent.getTimeout().intValue());
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            break block14;
                        }
                        default: {
                            return true;
                        }
                    }
                }
                return true;
            }
            catch (JDSException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

