/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.udp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ds.cluster.ServerNode;
import com.ds.cluster.udp.ClusterEvent;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.engine.ConnectInfo;
import com.ds.org.Person;
import com.ds.org.PersonNotFoundException;
import com.ds.org.conf.OrgConstants;
import com.ds.server.JDSServer;
import com.ds.server.JDSUDPServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.udp.UDPServerEventTask;
import com.ds.web.RemoteConnectionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class RepeatEventMsg
implements Runnable {
    private static final Log logger = LogFactory.getLog((String)"JDS", RepeatEventMsg.class);
    private final String subsystemCode;
    private final ClusterEvent event;
    private static final SerializeConfig config = new SerializeConfig();

    public RepeatEventMsg(ClusterEvent event, String subsystemCode) {
        this.subsystemCode = subsystemCode;
        this.event = event;
    }

    @Override
    public void run() {
        ServerNode remoteServerBean = JDSServer.getClusterClient().getServerNodeById(this.subsystemCode);
        if (remoteServerBean == null) {
            try {
                remoteServerBean = JDSServer.getInstance().getCurrServerBean();
            }
            catch (JDSException e) {
                e.printStackTrace();
            }
        }
        ExecutorService service = RemoteConnectionManager.getConntctionService((String)("RepeatSeverMsg[" + remoteServerBean.getId() + "]"));
        try {
            ServerNode currServerBean = JDSServer.getInstance().getCurrServerBean();
            if (this.event.getEventId() == null) {
                this.event.setMsgId(UUID.randomUUID().toString());
            }
            ArrayList<UDPServerEventTask> taskList = new ArrayList<UDPServerEventTask>();
            logger.info((Object)("currServerBeanInfo  " + JSON.toJSONString((Object)currServerBean, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0])));
            List systems = JDSServer.getClusterClient().getAllServer();
            for (ServerNode node : systems) {
                if (node.getAdminPersonId() == null || node.getId().equals(OrgConstants.UDPCONFIG_KEY)) continue;
                Set personIds = node.getAdminPersonIds();
                Set<String> personSetIds = JDSUDPServer.getInstance().getRepeatPersonEventKey(node.getId(), this.event.getExpression());
                personIds.addAll(personSetIds);
                for (String personId : personIds) {
                    if (personId == null) continue;
                    try {
                        Person toPerson = OrgManagerFactory.getOrgManager().getPersonByID(personId);
                        ConnectInfo connInfo = new ConnectInfo(toPerson.getID(), toPerson.getAccount(), toPerson.getPassword());
                        Set sessionHandleList = JDSServer.getInstance().getSessionHandleList(connInfo);
                        Set<String> serverKeys = JDSUDPServer.getInstance().getRepeatEventKey(node.getId());
                        logger.info((Object)("node.getId()=  " + node.getId() + "serverKeys=" + serverKeys));
                        logger.info((Object)("sessionHandleList=  " + sessionHandleList + "event.getExpression()=" + this.event.getExpression()));
                        if (!serverKeys.contains(this.event.getExpression()) || sessionHandleList == null || sessionHandleList.size() <= 0) continue;
                        taskList.add(new UDPServerEventTask(node.getId(), this.event.clone()));
                    }
                    catch (PersonNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
            logger.info((Object)("taskList  =======size=" + taskList.size()));
            List tasks = service.invokeAll(taskList);
            for (Future future : tasks) {
                List list = (List)future.get(5L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        RepeatEventMsg.config.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }
}

