/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.udp;

import com.ds.cluster.ServerNode;
import com.ds.cluster.udp.ClusterCommand;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.engine.ConnectInfo;
import com.ds.engine.JDSSessionHandle;
import com.ds.org.Person;
import com.ds.server.JDSServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.udp.SendCommandMsgTask;
import com.ds.web.RemoteConnectionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class RepeatCMDMsg
implements Runnable {
    private final String systemCode;
    private final ClusterCommand event;
    private static final Log logger = LogFactory.getLog((String)"JDS", RepeatCMDMsg.class);

    public RepeatCMDMsg(ClusterCommand event, String systemCode) {
        this.systemCode = systemCode;
        this.event = event;
    }

    @Override
    public void run() {
        ArrayList<ClusterCommand> events = new ArrayList<ClusterCommand>();
        ServerNode remoteServerBean = JDSServer.getClusterClient().getServerNodeById(this.systemCode);
        if (remoteServerBean != null) {
            try {
                Set personIds = remoteServerBean.getAdminPersonIds();
                block7: for (String personId : personIds) {
                    Person toPerson = OrgManagerFactory.getOrgManager().getPersonByAccount(personId);
                    ConnectInfo connInfo = new ConnectInfo(toPerson.getID(), toPerson.getAccount(), toPerson.getPassword());
                    Set sessionHandleList = JDSServer.getInstance().getSessionHandleList(connInfo);
                    ArrayList<SendCommandMsgTask> taskList = new ArrayList<SendCommandMsgTask>();
                    logger.info((Object)("msg json =======sessionHandleList=" + sessionHandleList + "[" + sessionHandleList.size() + "]"));
                    if (sessionHandleList == null || sessionHandleList.size() <= 0) continue;
                    for (JDSSessionHandle serverhandle : sessionHandleList) {
                        long currentTime = System.currentTimeMillis();
                        Long loginTime = (Long)JDSServer.getInstance().getConnectTimeCache().get((Object)serverhandle.toString());
                        if (loginTime == null || currentTime - loginTime >= 30000L) continue;
                        logger.info((Object)("msg json =======serverhandle=" + serverhandle));
                        ClusterCommand cevent = this.event.clone();
                        events.add(cevent);
                        SendCommandMsgTask task = new SendCommandMsgTask(serverhandle, cevent, this.systemCode);
                        taskList.add(task);
                    }
                    ExecutorService service = RemoteConnectionManager.getConntctionService((String)remoteServerBean.getUrl());
                    switch (this.event.getSequence()) {
                        case FIRST: {
                            service.submit((Callable)taskList.get(0)).get();
                            break;
                        }
                        case MEANWHILE: {
                            List tasks = service.invokeAll(taskList);
                            for (Future future : tasks) {
                                future.get(5L, TimeUnit.SECONDS);
                            }
                            continue block7;
                        }
                        case SEQUENCE: {
                            SendCommandMsgTask task;
                            Boolean result;
                            Iterator iterator = taskList.iterator();
                            while (iterator.hasNext() && (result = service.submit(task = (SendCommandMsgTask)iterator.next()).get()) != null && result.booleanValue()) {
                            }
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

