/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.udp;

import com.ds.client.JDSSessionFactory;
import com.ds.cluster.udp.HeardInfo;
import com.ds.common.ConfigCode;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.context.JDSContext;
import com.ds.engine.ConnectInfo;
import com.ds.engine.ConnectionHandle;
import com.ds.engine.JDSSessionHandle;
import com.ds.org.OrgManager;
import com.ds.org.Person;
import com.ds.server.JDSClientService;
import com.ds.server.JDSServer;
import com.ds.server.JDSUDPServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.context.UDPActionContextImpl;
import com.ds.server.udp.AbstractUDPHandle;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Set;

public class HeartCommand
implements Runnable {
    private HeardInfo heardInfo;
    private InetAddress address;
    public int port;
    private String sessionId;
    private ConfigCode configCode;
    private String systemCode;
    private static final Log logger = LogFactory.getLog((String)"JDS", HeartCommand.class);

    public HeartCommand(HeardInfo heardInfo, InetAddress address, int port) {
        this.address = address;
        this.heardInfo = heardInfo;
        this.port = port;
        this.sessionId = heardInfo.getSessionId();
        this.configCode = ConfigCode.app;
        this.systemCode = heardInfo.getSystemCode();
    }

    private String login(String systemCode, String address, Integer port, JDSSessionHandle sessionHandle) {
        String sendPacket = "success";
        try {
            JDSClientService client = this.getClient(sessionHandle.getSessionID(), systemCode, this.configCode, address, port);
            if (client != null) {
                client.getConnectionHandle().connect(client.getContext());
            } else {
                sendPacket = "{\"event\":1001,\"msgStr\":\"session error\"}";
            }
        }
        catch (JDSException e) {
            sendPacket = "{\"event\":1001,\"msgStr\":\"session error\"}";
        }
        return sendPacket;
    }

    private JDSClientService getClient(String sessionId, String systemCode, ConfigCode configCode, String ip, Integer port) throws JDSException {
        UDPActionContextImpl context = new UDPActionContextImpl(ip, port, systemCode, configCode);
        JDSClientService appClient = null;
        context.getContext().put("SYSID", configCode);
        context.setSessionId(sessionId);
        JDSSessionFactory factory = new JDSSessionFactory((JDSContext)context);
        JDSSessionHandle handle = factory.getSessionHandleBySessionId(sessionId);
        if (handle != null && ip != null && port != null && port > 0) {
            appClient = factory.getJDSClientBySessionId(sessionId, configCode);
            AbstractUDPHandle udp = (AbstractUDPHandle)appClient.getConnectionHandle();
            if (udp != null) {
                udp.setIp(ip);
                udp.setPort(port);
                appClient.setConnectionHandle((ConnectionHandle)udp);
            }
            ConnectInfo connectInfo = JDSServer.getInstance().getConnectInfo(handle);
            if (appClient != null) {
                appClient.setContext((JDSContext)context);
                appClient.connect(connectInfo);
            }
            if (appClient == null && connectInfo != null) {
                appClient = JDSServer.getInstance().newJDSClientService(handle, configCode);
                appClient.connect(connectInfo);
            }
        }
        return appClient;
    }

    @Override
    public void run() {
        String msgStr = "success";
        try {
            ConnectInfo connectionInfo = null;
            JDSClientService appClient = this.getClient(this.sessionId, this.systemCode, this.configCode, this.address.getHostAddress(), this.port);
            if (appClient == null) {
                msgStr = "{\"event\":1001,\"msgStr\":\"appClient is null\"}";
                logger.error((Object)(" appClient is null userId:[" + this.heardInfo.getUserid() + "] sessionid:[" + this.heardInfo.getSessionId() + "]"));
            } else {
                JDSSessionHandle sessionhandle = (JDSSessionHandle)JDSServer.getInstance().getSessionHandleCache().get((Object)this.sessionId);
                ConnectionHandle handle = appClient.getConnectionHandle();
                connectionInfo = appClient.getConnectInfo();
                if (connectionInfo == null || !connectionInfo.getUserID().equals(this.heardInfo.getUserid())) {
                    Person person = OrgManagerFactory.getOrgManager().getPersonByID(this.heardInfo.getUserid());
                    connectionInfo = new ConnectInfo(person.getID(), person.getAccount(), person.getPassword());
                    appClient.connect(connectionInfo);
                }
                if (sessionhandle != null) {
                    JDSServer.getInstance();
                    JDSServer.activeSession((JDSSessionHandle)sessionhandle);
                } else {
                    Set handles = JDSServer.getInstance().getSessionHandleList(connectionInfo);
                    for (JDSSessionHandle ohandle : handles) {
                        if (ohandle == null || !ohandle.getSessionID().equals(this.sessionId) && !ohandle.getSessionID().equals(handle.getClient().getSessionHandle().getSessionID())) continue;
                        sessionhandle = ohandle;
                        sessionhandle.setIp(this.address.getHostAddress());
                        sessionhandle.setPort(Integer.valueOf(this.port));
                        JDSServer.getInstance();
                        JDSServer.activeSession((JDSSessionHandle)sessionhandle);
                    }
                    if (sessionhandle == null) {
                        OrgManager orgManager = OrgManagerFactory.getOrgManager((ConfigCode)this.configCode);
                        msgStr = "{\"event\":1001,\"msgStr\":\"sessionhandle=is null or systemStatus is -1\"}";
                        logger.error((Object)(msgStr + " sessionhandle=" + handle.getClient().getConnectionHandle()));
                    }
                }
                if (this.getSystemStatus(connectionInfo) == -1) {
                    msgStr = "{\"event\":1001,\"msgStr\":\"connectionInfo=" + connectionInfo + " systemStatus is -1\"}";
                    logger.error((Object)msgStr);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error((Object)e);
            msgStr = "{\"event\":1001,\"msgStr\":\"sessionhandle is null\"}";
        }
        DatagramPacket sendPacket = new DatagramPacket(msgStr.getBytes(), msgStr.getBytes().length, this.address, this.port);
        try {
            DatagramSocket socket = JDSUDPServer.getInstance().getPushMsgSocket();
            socket.send(sendPacket);
        }
        catch (JDSException | IOException e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
    }

    public Integer getSystemStatus(ConnectInfo connectInfo) {
        try {
            Set handles = JDSServer.getInstance().getSessionHandleList(connectInfo);
            long expireTime = 15000L;
            for (JDSSessionHandle handle : handles) {
                Long loginTime;
                long currentTime;
                if (JDSServer.getInstance().getConnectTimeCache().get((Object)handle.getSessionID()) == null || (currentTime = System.currentTimeMillis()) - (loginTime = (Long)JDSServer.getInstance().getConnectTimeCache().get((Object)handle.getSessionID())) >= expireTime) continue;
                logger.info((Object)("user[" + connectInfo.getLoginName() + "]handles.size=" + handles.size() + "  getSessionID()=" + handle.getSessionID() + "time=" + (currentTime - loginTime)));
                return 0;
            }
        }
        catch (JDSException jDSException) {
            // empty catch block
        }
        return -1;
    }
}

