/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.udp;

import com.alibaba.fastjson.JSONObject;
import com.ds.cluster.ServerNode;
import com.ds.cluster.udp.ClusterClient;
import com.ds.common.JDSException;
import com.ds.context.JDSContext;
import com.ds.context.JDSUDPContext;
import com.ds.engine.ConnectInfo;
import com.ds.engine.JDSSessionHandle;
import com.ds.msg.Msg;
import com.ds.org.Person;
import com.ds.org.PersonNotFoundException;
import com.ds.org.conf.OrgConstants;
import com.ds.server.JDSClientService;
import com.ds.server.JDSServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.udp.AbstractUDPHandle;
import java.util.List;
import java.util.Set;

public class DefaultUDPHandle
extends AbstractUDPHandle {
    public DefaultUDPHandle(JDSClientService client, JDSSessionHandle sessionHandle, String systemCode) throws JDSException {
        super(client, sessionHandle, systemCode);
    }

    private Boolean sendServerMessage(String eventStr, String systemCode) throws JDSException {
        logger.debug((Object)("start sendEvent  eventStr [" + systemCode + "]" + eventStr));
        ServerNode remoteServerBean = JDSServer.getClusterClient().getServerNodeById(systemCode);
        if (remoteServerBean != null) {
            try {
                Person toPerson = OrgManagerFactory.getOrgManager().getPersonByAccount(remoteServerBean.getId() + remoteServerBean.getId());
                ConnectInfo connInfo = new ConnectInfo(toPerson.getID(), toPerson.getAccount(), toPerson.getPassword());
                Set sessionHandleList = JDSServer.getInstance().getSessionHandleList(connInfo);
                for (JDSSessionHandle serverhandle : sessionHandleList) {
                    JDSClientService client = JDSServer.getInstance().getJDSClientService(serverhandle, OrgConstants.CONFIG_KEY);
                    if (client.getConnectInfo() == null) continue;
                    logger.info((Object)("end sendEvent to  [" + client.getConnectionHandle() + "]"));
                    client.getConnectionHandle().send(eventStr);
                }
                return true;
            }
            catch (PersonNotFoundException connInfo) {
            }
            catch (JDSException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void receive(String receiveStr) throws JDSException {
        JSONObject jsonobj = JSONObject.parseObject((String)receiveStr);
        if (jsonobj.containsKey((Object)"expression") && !jsonobj.containsKey((Object)"commandJson") && jsonobj.containsKey((Object)"sourceJson")) {
            ClusterClient client = JDSServer.getClusterClient();
            ServerNode currServerBean = JDSServer.getInstance().getCurrServerBean();
            if (currServerBean.getType() != null && currServerBean.getType().equals((Object)"main")) {
                List systems = client.getAllServer();
                for (ServerNode node : systems) {
                    if (!client.getSystem(node.getId()).getConfigname().equals((Object)"app")) continue;
                    this.sendServerMessage(receiveStr, node.getId());
                }
            }
        }
    }

    public boolean send(String msgString) throws JDSException {
        if (this.getConnectInfo() != null) {
            logger.info((Object)("send user:[" + this.getConnectInfo().getLoginName() + "] "));
            logger.debug((Object)msgString);
        }
        Boolean canSend = false;
        if (this.getIp() != null && this.getPort() != null) {
            canSend = this.getUdpServer().send(msgString, this.getIp(), this.getPort());
        }
        return canSend;
    }

    @Override
    public void connect(JDSContext context) throws JDSException {
        super.connect(context);
        JDSUDPContext updContext = (JDSUDPContext)context;
        this.setIp(updContext.getIpAddr());
        this.setPort(updContext.getPort());
        JDSUDPContext jdsUDPContext = (JDSUDPContext)context;
        Person eiperson = null;
        try {
            eiperson = OrgManagerFactory.getOrgManager().getPersonByID(this.getClient().getConnectInfo().getUserID());
        }
        catch (PersonNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    public String toString() {
        return this.getIp() + ":" + this.getPort() + "[" + this.getSessionHandle() + "]";
    }

    @Override
    public void disconnect() throws JDSException {
        super.disconnect();
    }

    @Override
    public boolean repeatMsg(Msg msg, JDSSessionHandle handle) throws JDSException {
        return true;
    }
}

