/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.udp;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ds.annotation.Enumstype;
import com.ds.cluster.udp.ClusterCommand;
import com.ds.common.JDSCommand;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.context.JDSContext;
import com.ds.context.JDSUDPContext;
import com.ds.engine.ConnectInfo;
import com.ds.engine.ConnectionHandle;
import com.ds.engine.JDSSessionHandle;
import com.ds.msg.Msg;
import com.ds.server.JDSClientService;
import com.ds.server.JDSUDPServer;
import com.ds.thread.JDSThreadFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import net.sf.cglib.beans.BeanMap;

public abstract class AbstractUDPHandle
implements ConnectionHandle {
    private JDSSessionHandle sessionHandle;
    private String ip;
    private Integer port;
    private ConnectInfo connectInfo;
    public String systemCode;
    private JDSClientService client;
    private static final SerializeConfig config = new SerializeConfig();
    public static final Log logger;
    static Map<String, ScheduledExecutorService> heartServiceMap;

    public JDSUDPServer getUdpServer() {
        JDSUDPServer server = null;
        try {
            server = JDSUDPServer.getInstance();
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return server;
    }

    public boolean send(JDSCommand command) throws JDSException {
        BeanMap commandBeanmap = BeanMap.create((Object)command);
        String commandCMD = (String)commandBeanmap.get("command");
        if (commandCMD == null || commandCMD.equals("")) {
            return false;
        }
        ClusterCommand clusterCommand = new ClusterCommand();
        clusterCommand.setCommand(commandCMD);
        clusterCommand.setCommandJson(JSONObject.toJSONString((Object)command, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]));
        clusterCommand.setExpression("$RepeatCommand");
        clusterCommand.setSessionId(this.getSessionHandle().getSessionID());
        clusterCommand.setSessionHandle(this.sessionHandle);
        clusterCommand.setSystemCode(this.getSystemCode());
        String commandStr = JSONObject.toJSON((Object)clusterCommand, (SerializeConfig)config).toString();
        logger.info((Object)("satrt commandStr " + commandStr));
        boolean isSend = this.send(commandStr);
        logger.info((Object)("start send [" + isSend + "]" + commandStr));
        return this.send(commandStr);
    }

    public static synchronized ScheduledExecutorService getHandleService(String ipport) {
        ScheduledExecutorService service = heartServiceMap.get(ipport);
        if (service == null) {
            service = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new JDSThreadFactory("AbstractUDPHandle.getHandleService"));
            heartServiceMap.put(ipport, service);
        }
        return service;
    }

    public AbstractUDPHandle(JDSClientService client, JDSSessionHandle sessionHandle, String systemCode) throws JDSException {
        this.client = client;
        this.systemCode = systemCode;
        this.sessionHandle = sessionHandle;
    }

    public void disconnect() throws JDSException {
        logger.info((Object)("user:" + this.connectInfo.getLoginName() + "[" + this.sessionHandle.getSessionID() + "," + this.ip + ":" + this.port + "] udpLogout "));
        try {
            this.getClient().disconnect();
        }
        catch (JDSException e) {
            throw new JDSException((Throwable)e);
        }
    }

    public void connect(JDSContext context) throws JDSException {
        if (context instanceof JDSUDPContext) {
            JDSUDPContext updContext = (JDSUDPContext)context;
            this.ip = updContext.getIpAddr();
            this.port = updContext.getPort();
        }
        if (this.connectInfo == null) {
            this.connectInfo = this.getClient().getConnectInfo();
        }
        this.client.connect(this.connectInfo);
        if (this.connectInfo != null) {
            // empty if block
        }
    }

    public boolean repeatCommand(JDSCommand command, JDSSessionHandle handle) throws JDSException {
        JDSClientService client = this.getClient();
        if (client != null && client.getConnectInfo() != null && client.getConnectionHandle().isconnect()) {
            logger.info((Object)("comet command [" + JSONObject.toJSONString((Object)command, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]) + "]"));
            BeanMap commandBeanmap = BeanMap.create((Object)command);
            Enumstype commandCMD = (Enumstype)commandBeanmap.get("command");
            if (commandCMD == null || commandCMD.equals("")) {
                return false;
            }
            ClusterCommand clusterCommand = new ClusterCommand();
            clusterCommand.setCommand(commandCMD.getType());
            clusterCommand.setCommandJson(JSONObject.toJSONString((Object)command, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]));
            clusterCommand.setExpression("$RepeatCommand");
            clusterCommand.setSessionId(handle.getSessionID());
            clusterCommand.setSessionHandle(handle);
            clusterCommand.setSystemCode(command.getSystemCode());
            String commandStr = JSONObject.toJSON((Object)clusterCommand, (SerializeConfig)config).toString();
            logger.info((Object)("satrt commandStr " + commandStr));
            boolean isSend = this.send(commandStr);
            logger.info((Object)("end repeatCommand [" + isSend + "]" + commandStr));
            return isSend;
        }
        return false;
    }

    public abstract boolean repeatMsg(Msg var1, JDSSessionHandle var2) throws JDSException;

    public boolean isconnect() throws JDSException {
        return this.ip != null && this.port != null;
    }

    public JDSClientService getClient() throws JDSException {
        return this.client;
    }

    public JDSSessionHandle getSessionHandle() {
        return this.sessionHandle;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public ConnectInfo getConnectInfo() {
        return this.connectInfo;
    }

    public void setConnectInfo(ConnectInfo connectInfo) {
        this.connectInfo = connectInfo;
    }

    public String getSystemCode() {
        return this.systemCode;
    }

    public void setSystemCode(String systemCode) {
        this.systemCode = systemCode;
    }

    static {
        AbstractUDPHandle.config.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
        logger = LogFactory.getLog((String)"JDS", ConnectionHandle.class);
        heartServiceMap = new HashMap<String, ScheduledExecutorService>();
    }
}

