/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.nioproxy.handle;

import com.ds.server.httpproxy.nioproxy.handle.ProxyHttpExchange;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.protocol.HttpContext;

public class ProxyResponseProducer
implements HttpAsyncResponseProducer {
    private final ProxyHttpExchange httpExchange;

    public ProxyResponseProducer(ProxyHttpExchange httpExchange) {
        this.httpExchange = httpExchange;
    }

    public void close() {
        this.httpExchange.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse generateResponse() {
        ProxyHttpExchange proxyHttpExchange = this.httpExchange;
        synchronized (proxyHttpExchange) {
            HttpResponse response = this.httpExchange.getResponse();
            BasicHttpResponse r = new BasicHttpResponse(response.getStatusLine());
            r.setEntity(response.getEntity());
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        ProxyHttpExchange proxyHttpExchange = this.httpExchange;
        synchronized (proxyHttpExchange) {
            this.httpExchange.setClientIOControl(ioctrl);
            ByteBuffer buf = this.httpExchange.getOutBuffer();
            buf.flip();
            int n = encoder.write(buf);
            buf.compact();
            if (buf.hasRemaining() && !this.httpExchange.isResponseReceived() && this.httpExchange.getOriginIOControl() != null) {
                this.httpExchange.getOriginIOControl().requestInput();
            }
            if (buf.position() == 0) {
                if (this.httpExchange.isResponseReceived()) {
                    encoder.complete();
                } else {
                    ioctrl.suspendOutput();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseCompleted(HttpContext context) {
        ProxyHttpExchange proxyHttpExchange = this.httpExchange;
        synchronized (proxyHttpExchange) {
        }
    }

    public void failed(Exception ex) {
    }
}

