/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.nioproxy.handle;

import com.ds.server.httpproxy.nioproxy.handle.ProxyHttpExchange;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpContext;

public class ProxyRequestProducer
implements HttpAsyncRequestProducer {
    private final ProxyHttpExchange httpExchange;

    public ProxyRequestProducer(ProxyHttpExchange httpExchange) {
        this.httpExchange = httpExchange;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpHost getTarget() {
        ProxyHttpExchange proxyHttpExchange = this.httpExchange;
        synchronized (proxyHttpExchange) {
            return this.httpExchange.getTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequest generateRequest() {
        ProxyHttpExchange proxyHttpExchange = this.httpExchange;
        synchronized (proxyHttpExchange) {
            Header[] exHeaders;
            HttpRequest request = this.httpExchange.getRequest();
            if (request instanceof HttpEntityEnclosingRequest) {
                Header[] exHeaders2;
                BasicHttpEntityEnclosingRequest closeRequest = new BasicHttpEntityEnclosingRequest(request.getRequestLine());
                for (Header header : exHeaders2 = request.getAllHeaders()) {
                    String name = header.getName().toLowerCase();
                    if (name.equals("Transfer-encoding".toLowerCase()) || name.equals("Content-Length".toLowerCase())) continue;
                    closeRequest.addHeader(header);
                }
                closeRequest.setEntity(((HttpEntityEnclosingRequest)request).getEntity());
                return closeRequest;
            }
            BasicHttpRequest basicHttpRequest = new BasicHttpRequest(request.getRequestLine());
            for (Header header : exHeaders = request.getAllHeaders()) {
                String name = header.getName().toLowerCase();
                if (name.equals("Transfer-encoding".toLowerCase()) || name.equals("Content-Length".toLowerCase())) continue;
                basicHttpRequest.addHeader(header);
            }
            return basicHttpRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        ProxyHttpExchange proxyHttpExchange = this.httpExchange;
        synchronized (proxyHttpExchange) {
            this.httpExchange.setOriginIOControl(ioctrl);
            ByteBuffer buf = this.httpExchange.getInBuffer();
            buf.flip();
            int n = encoder.write(buf);
            buf.compact();
            if (buf.hasRemaining() && !this.httpExchange.isRequestReceived() && this.httpExchange.getClientIOControl() != null) {
                this.httpExchange.getClientIOControl().requestInput();
            }
            if (buf.position() == 0) {
                if (this.httpExchange.isRequestReceived()) {
                    encoder.complete();
                } else {
                    ioctrl.suspendOutput();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCompleted(HttpContext context) {
        ProxyHttpExchange proxyHttpExchange = this.httpExchange;
        synchronized (proxyHttpExchange) {
        }
    }

    public boolean isRepeatable() {
        return false;
    }

    public void resetRequest() {
    }

    public void failed(Exception ex) {
    }
}

