/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.nioproxy.handle;

import com.ds.server.httpproxy.ServerProxyFactory;
import com.ds.server.httpproxy.nioproxy.handle.ProxyHttpExchange;
import com.ds.server.httpproxy.nioproxy.handle.ProxyRequestConsumer;
import com.ds.server.httpproxy.nioproxy.handle.ProxyResponseProducer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.apache.http.impl.nio.pool.BasicNIOConnPool;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.BasicAsyncResponseProducer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncRequester;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.protocol.HttpContext;

public class ProxyRequestHandler
implements HttpAsyncRequestHandler<ProxyHttpExchange> {
    private final HttpAsyncRequester executor;
    private final BasicNIOConnPool connPool;
    private final AtomicLong counter;
    Map<String, HttpHost> hostMap = new HashMap<String, HttpHost>();

    public ProxyRequestHandler(HttpAsyncRequester executor, BasicNIOConnPool connPool) {
        this.executor = executor;
        this.connPool = connPool;
        this.counter = new AtomicLong(1L);
    }

    public HttpAsyncRequestConsumer<ProxyHttpExchange> processRequest(HttpRequest request, HttpContext context) {
        ProxyHttpExchange httpExchange = (ProxyHttpExchange)context.getAttribute("http-exchange");
        ServerProxyFactory factory = ServerProxyFactory.getInstance();
        HttpHost target = factory.getProxyHost(request);
        if (httpExchange == null || httpExchange.getException() != null) {
            httpExchange = new ProxyHttpExchange();
            context.setAttribute("http-exchange", (Object)httpExchange);
        } else {
            httpExchange.reset();
        }
        String id = String.format("%08X", this.counter.getAndIncrement());
        httpExchange.setId(id);
        httpExchange.setTarget(target);
        return new ProxyRequestConsumer(httpExchange, this.executor, this.connPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ProxyHttpExchange httpExchange, HttpAsyncExchange responseTrigger, HttpContext context) {
        ProxyHttpExchange proxyHttpExchange = httpExchange;
        synchronized (proxyHttpExchange) {
            Exception ex = httpExchange.getException();
            if (ex != null) {
                int status = 500;
                BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, status, EnglishReasonPhraseCatalog.INSTANCE.getReason(status, Locale.CHINESE));
                String message = ex.getMessage();
                if (message == null || message.equals("")) {
                    message = "Unexpected error";
                }
                response.setEntity((HttpEntity)new NStringEntity(message, ContentType.DEFAULT_TEXT));
                responseTrigger.submitResponse((HttpAsyncResponseProducer)new BasicAsyncResponseProducer((HttpResponse)response));
                httpExchange.setResponse((HttpResponse)response);
                httpExchange.setResponseTrigger(responseTrigger);
            } else {
                HttpResponse response = httpExchange.getResponse();
                if (response != null) {
                    responseTrigger.submitResponse((HttpAsyncResponseProducer)new ProxyResponseProducer(httpExchange));
                }
                httpExchange.setResponseTrigger(responseTrigger);
            }
        }
    }
}

