/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.nioproxy.handle;

import com.ds.server.httpproxy.nioproxy.handle.ProxyHttpExchange;
import com.ds.server.httpproxy.nioproxy.handle.ProxyRequestProducer;
import com.ds.server.httpproxy.nioproxy.handle.ProxyResponseConsumer;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.http.HttpRequest;
import org.apache.http.impl.nio.pool.BasicNIOConnPool;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncRequester;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.pool.ConnPool;
import org.apache.http.protocol.HttpContext;

public class ProxyRequestConsumer
implements HttpAsyncRequestConsumer<ProxyHttpExchange> {
    private final ProxyHttpExchange httpExchange;
    private final HttpAsyncRequester executor;
    private final BasicNIOConnPool connPool;
    private volatile boolean completed;

    public ProxyRequestConsumer(ProxyHttpExchange httpExchange, HttpAsyncRequester executor, BasicNIOConnPool connPool) {
        this.httpExchange = httpExchange;
        this.executor = executor;
        this.connPool = connPool;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestReceived(HttpRequest request) {
        ProxyHttpExchange proxyHttpExchange = this.httpExchange;
        synchronized (proxyHttpExchange) {
            this.httpExchange.setRequest(request);
            this.executor.execute((HttpAsyncRequestProducer)new ProxyRequestProducer(this.httpExchange), (HttpAsyncResponseConsumer)new ProxyResponseConsumer(this.httpExchange), (ConnPool)this.connPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        ProxyHttpExchange proxyHttpExchange = this.httpExchange;
        synchronized (proxyHttpExchange) {
            this.httpExchange.setClientIOControl(ioctrl);
            ByteBuffer buf = this.httpExchange.getInBuffer();
            int n = decoder.read(buf);
            if (decoder.isCompleted()) {
                // empty if block
            }
            if (!buf.hasRemaining()) {
                ioctrl.suspendInput();
            }
            if (buf.position() > 0 && this.httpExchange.getOriginIOControl() != null) {
                this.httpExchange.getOriginIOControl().requestOutput();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCompleted(HttpContext context) {
        ProxyHttpExchange proxyHttpExchange = this.httpExchange;
        synchronized (proxyHttpExchange) {
            this.completed = true;
            this.httpExchange.setRequestReceived();
            if (this.httpExchange.getOriginIOControl() != null) {
                this.httpExchange.getOriginIOControl().requestOutput();
            }
        }
    }

    public Exception getException() {
        return null;
    }

    public ProxyHttpExchange getResult() {
        return this.httpExchange;
    }

    public boolean isDone() {
        return this.completed;
    }

    public void failed(Exception ex) {
        ex.printStackTrace();
    }
}

