/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.handler.multipart;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ds.config.ErrorResultModel;
import com.ds.server.httpproxy.core.AbstractHandler;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import com.ds.server.httpproxy.handler.multipart.CommonsMultipartFile;
import com.ds.server.httpproxy.handler.multipart.SimpleRequestContext;
import com.ds.web.RequestMethodBean;
import com.ds.web.RequestParamBean;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import ognl.OgnlContext;
import ognl.OgnlRuntime;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.springframework.web.multipart.MultipartFile;

public class CustomFileHandler
extends AbstractHandler {
    public static final ConfigOption RULE_OPTION = new ConfigOption("rule", true, "Regular expression for matching URLs.");
    Pattern rule;

    @Override
    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        this.rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
        return true;
    }

    @Override
    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        String contentType;
        String resource = request.getPath();
        boolean ruleMatches = this.rule.matcher(resource).matches();
        if (!ruleMatches) {
            return false;
        }
        String mimeType = this.getMimeType(resource);
        if (mimeType != null) {
            response.setMimeType(mimeType);
        }
        if ((contentType = this.getContentType(request)) != null && contentType.indexOf("multipart/form-data") > -1) {
            return this.sendMultiparPostProxy(request, response);
        }
        return true;
    }

    public boolean sendMultiparPostProxy(HttpRequest request, HttpResponse response) throws IOException {
        HashMap params = new HashMap();
        String json = "";
        RequestMethodBean methodBean = this.getRequestMethodBean(request);
        if (methodBean == null) {
            return false;
        }
        LinkedHashSet paramBeanSet = methodBean.getParamSet();
        Boolean isMulti = false;
        for (RequestParamBean paramBean : paramBeanSet) {
            if (!MultipartFile.class.isAssignableFrom(paramBean.getParamClass())) continue;
            isMulti = true;
        }
        ArrayList<Object> paramObjs = new ArrayList<Object>();
        if (isMulti.booleanValue()) {
            SimpleRequestContext requestContext = new SimpleRequestContext(StandardCharsets.UTF_8, this.getContentType(request), new ByteArrayInputStream(request.getPostData()));
            PortletFileUpload fileUploadBase = new PortletFileUpload();
            DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
            fileUploadBase.setFileItemFactory((FileItemFactory)fileItemFactory);
            fileUploadBase.setHeaderEncoding("utf-8");
            List fileItems = null;
            try {
                fileItems = fileUploadBase.parseRequest((RequestContext)requestContext);
            }
            catch (FileUploadException e) {
                e.printStackTrace();
            }
            for (RequestParamBean paramBean : paramBeanSet) {
                for (FileItem f : fileItems) {
                    if (!f.getFieldName().equals(paramBean.getParamName())) continue;
                    if (f.isFormField()) {
                        paramObjs.add(f.getString());
                        continue;
                    }
                    CommonsMultipartFile commonsMultipartFile = new CommonsMultipartFile(f);
                    paramObjs.add(commonsMultipartFile);
                }
            }
        }
        try {
            Object service = this.getService(methodBean, request);
            if (service != null) {
                Object obj = OgnlRuntime.callMethod((OgnlContext)this.getOgnlContext(), (Object)service, (String)methodBean.getMethodName(), (Object[])paramObjs.toArray());
                json = obj instanceof String ? obj.toString() : JSONObject.toJSONString((Object)obj, (boolean)false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorResultModel resultModel = new ErrorResultModel();
            resultModel.setErrdes(e.getMessage());
            json = JSON.toJSONString((Object)resultModel);
        }
        return this.sendJSON(methodBean, response, json);
    }
}

