/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.handler.cls;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.md5.MD5;
import com.ds.common.util.StringUtility;
import com.ds.config.JDSUtil;
import com.ds.server.httpproxy.core.AbstractHandler;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.Handler;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.regex.Pattern;

public class ClsHandler
extends AbstractHandler
implements Handler {
    private static final Log log = LogFactory.getLog((String)"JDS", AbstractHandler.class);
    public static final ConfigOption RESOURCE_MOUNT_OPTION = new ConfigOption("resourceMount", "/", "A path within the classpath to the root of the folder to share.");
    public static final ConfigOption DEFAULT_RESOURCE_OPTION = new ConfigOption("default", "index.html", "The default resource name.");
    public static final ConfigOption RULE_OPTION = new ConfigOption("rule", true, "Regular expression for matching URLs.");
    private String resourceMount;
    private String defaultResource;
    Pattern rule;

    @Override
    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        this.resourceMount = RESOURCE_MOUNT_OPTION.getProperty(server, handlerName);
        this.defaultResource = DEFAULT_RESOURCE_OPTION.getProperty(server, handlerName);
        this.rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
        return true;
    }

    @Override
    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        File file;
        String path = request.getPath();
        boolean ruleMatches = this.rule.matcher(path).matches();
        if (!ruleMatches) {
            return false;
        }
        String projectName = this.getProjectName(request);
        boolean projectMatches = false;
        if (projectName != null) {
            Pattern projectRule = Pattern.compile(".*/(" + projectName + ")?.*");
            projectMatches = projectRule.matcher(path).matches();
        }
        if (!projectMatches) {
            return false;
        }
        path = this.formatPath(request.getUrl(), projectName);
        String mimeType = this.getMimeType(path);
        path = StringUtility.replace((String)path, (String)".js", (String)"");
        path = StringUtility.replace((String)path, (String)".cls", (String)"");
        String className = StringUtility.replace((String)path, (String)"/", (String)".");
        if (projectName.indexOf("VVVERSION") > -1) {
            projectName = projectName.split("VVVERSION")[0];
        }
        if (!(file = new File(JDSUtil.getJdsRealPath() + "webapp/" + projectName + "/cls/" + MD5.getHashString((String)className))).exists()) {
            file = new File(JDSUtil.getJdsRealPath() + this.resourceMount + "/" + projectName + "/cls/" + MD5.getHashString((String)className));
        }
        log.info((Object)("className=" + className));
        log.info((Object)("file=" + file.getPath()));
        FileInputStream is = null;
        if (file.exists()) {
            is = new FileInputStream(file);
        }
        if (mimeType == null || is == null) {
            log.warn((Object)("Resource was not found or the mime type was not understood. (Found file=" + (is != null) + ") (Found mime-type=" + (mimeType != null) + ")"));
            return false;
        }
        if (is != null) {
            response.setMimeType(mimeType);
            response.sendResponse(is, Integer.valueOf(Long.toString(file.length())));
            return true;
        }
        return false;
    }
}

