/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.handler;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.config.JDSUtil;
import com.ds.server.httpproxy.core.AbstractHandler;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.Handler;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.regex.Pattern;

public class ResourceHandler
extends AbstractHandler
implements Handler {
    private static final Log log = LogFactory.getLog((String)"JDS", ResourceHandler.class);
    public static final ConfigOption RESOURCE_MOUNT_OPTION = new ConfigOption("resourceMount", "/", "A path within the classpath to the root of the folder to share.");
    public static final ConfigOption DEFAULT_RESOURCE_OPTION = new ConfigOption("default", "index.html", "The default resource name.");
    public static final ConfigOption RULE_OPTION = new ConfigOption("rule", true, "Regular expression for matching URLs.");
    private String resourceMount;
    private String defaultResource;
    Pattern rule;

    @Override
    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        this.resourceMount = RESOURCE_MOUNT_OPTION.getProperty(server, handlerName);
        this.defaultResource = DEFAULT_RESOURCE_OPTION.getProperty(server, handlerName);
        this.rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
        return true;
    }

    @Override
    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        String path = request.getPath();
        if (!this.rule.matcher(path).matches()) {
            return false;
        }
        String projectName = this.getProjectName(request);
        String filePath = this.formatPath(request.getUrl(), projectName);
        if (projectName.indexOf("VVVERSION") > -1) {
            projectName = projectName.split("VVVERSION")[0];
        }
        String mimeType = this.getMimeType(filePath);
        File file = new File(JDSUtil.getJdsRealPath() + this.resourceMount + "/" + filePath);
        if (!file.exists()) {
            file = new File(JDSUtil.getJdsRealPath() + this.resourceMount + "/" + projectName + "/" + filePath);
        }
        if (!file.exists()) {
            file = new File(JDSUtil.getJdsRealPath() + "export/" + projectName + "/" + filePath);
        }
        if (!file.exists()) {
            file = new File(JDSUtil.getJdsRealPath() + "webapp/" + projectName + "/" + filePath);
        }
        log.info((Object)file.getAbsolutePath());
        FileInputStream is = null;
        if (file.exists()) {
            is = new FileInputStream(file);
            if (mimeType == null || is == null) {
                log.warn((Object)("Resource was not found or the mime type was not understood. (Found file=" + (is != null) + ") (Found mime-type=" + (mimeType != null) + ")"));
                return false;
            }
            response.setMimeType(mimeType);
            response.sendResponse(is, Integer.valueOf(Long.toString(file.length())));
            return true;
        }
        return false;
    }
}

