/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.handler;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.server.httpproxy.core.AbstractHandler;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RedirectHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog((String)"JDS", RedirectHandler.class);
    public static final ConfigOption RULE_OPTION = new ConfigOption("rule", true, "Regular expression for matching URLs.");
    public static final ConfigOption SUBST_OPTION = new ConfigOption("subst", true, "The substiution expression to re-writing the new URL.");
    public static final ConfigOption INTERNAL_OPTION = new ConfigOption("useInternal", "false", "Internal redirect without sending a response.");
    public static final ConfigOption REDIRECT_CODE_OPTION = new ConfigOption("redirectCode", "302", "The HTTP code to send back to the client when the URL matches the rule.");
    Pattern rule;
    String substitution;
    boolean isInternalRedirect;
    int redirectHttpCode = 302;

    @Override
    public boolean initialize(String handlerName, Server server) {
        try {
            super.initialize(handlerName, server);
            String rulestr = RULE_OPTION.getProperty(server, handlerName);
            this.rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName), 2);
            this.substitution = SUBST_OPTION.getProperty(server, handlerName);
            this.isInternalRedirect = INTERNAL_OPTION.getBoolean(server, handlerName);
            try {
                this.redirectHttpCode = REDIRECT_CODE_OPTION.getInteger(server, handlerName);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("redirectCode was not a number!  Defaulting to " + this.redirectHttpCode));
            }
            log.info((Object)("Rule=" + this.rule.pattern() + ",subst=" + this.substitution + ",useInternal=" + this.isInternalRedirect + ",redirectCode=" + this.redirectHttpCode));
            return true;
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e.toString());
            return false;
        }
    }

    @Override
    protected boolean isRequestdForHandler(HttpRequest request) {
        return !request.isInternal();
    }

    @Override
    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        Matcher urlMatch = this.rule.matcher(request.getUrl());
        StringBuffer buffer = null;
        if (urlMatch.find()) {
            if (buffer == null) {
                buffer = new StringBuffer(this.substitution);
            }
            int lastIndex = 0;
            while ((lastIndex = this.replaceGroupInSubst(buffer, urlMatch)) < buffer.length()) {
            }
            if (this.isInternalRedirect) {
                return this.server.post(new HttpRequest(buffer.toString(), this.server.getConfig(), true), response);
            }
            response.setStatusCode(this.redirectHttpCode);
            response.addHeader("Location", buffer.toString());
            return true;
        }
        return false;
    }

    private int replaceGroupInSubst(StringBuffer buffer, Matcher urlMatch) {
        int index = buffer.indexOf("${");
        if (index >= 0) {
            int endIndex = this.substitution.indexOf("}");
            String reference = this.substitution.substring(index + 2, endIndex);
            String subst = null;
            if (Character.isDigit(reference.charAt(0))) {
                int group = Integer.parseInt(reference);
                subst = urlMatch.group(group);
            } else {
                subst = this.server.getProperty(subst);
            }
            if (subst != null) {
                buffer.replace(index, endIndex + 1, subst);
            }
            return endIndex + 1;
        }
        return buffer.length();
    }
}

