/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.handler;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.config.JDSUtil;
import com.ds.server.httpproxy.core.AbstractHandler;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;

public class OtherUrlProxyHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog((String)"JDS", OtherUrlProxyHandler.class);
    public static final ConfigOption RESOURCE_MOUNT_OPTION = new ConfigOption("resourceMount", "/", "A path within the classpath to the root of the folder to share.");
    public static final ConfigOption DEFAULT_RESOURCE_OPTION = new ConfigOption("default", "index.html", "The default resource name.");
    public static final ConfigOption RULE_OPTION = new ConfigOption("rule", true, "Regular expression for matching URLs.");
    Pattern rule;
    private String resourceMount;

    @Override
    public boolean initialize(String handlerName, Server server) {
        try {
            super.initialize(handlerName, server);
            this.rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
            this.resourceMount = RESOURCE_MOUNT_OPTION.getProperty(server, handlerName);
            log.info((Object)("Rule=" + this.rule.pattern()));
            return true;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            log.error((Object)e.toString());
            return false;
        }
    }

    @Override
    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        boolean ruleMatches = this.rule.matcher(request.getUrl()).matches();
        if (!ruleMatches) {
            return false;
        }
        String resource = request.getUrl();
        if (resource.startsWith("http://")) {
            resource = resource.substring("http://".length());
        }
        File file = new File(JDSUtil.getJdsRealPath() + "\\" + this.resourceMount + "\\" + resource);
        FileInputStream is = null;
        if (file.exists() && !file.isDirectory()) {
            is = new FileInputStream(file);
        } else {
            String url = resource;
            this.copyStreamToFile("http://" + url, file);
            if (file.exists() && !file.isDirectory()) {
                is = new FileInputStream(file);
            }
        }
        response.addHeader("Access-Control-Allow-Origin", "*");
        String mimeType = this.getMimeType(resource);
        response.setMimeType(mimeType);
        response.sendResponse(is, Integer.valueOf(Long.toString(file.length())));
        return true;
    }

    @Override
    public InputStream getInputStream(String content, String charSet) {
        if (content == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(content.getBytes(charSet));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        Pattern rule = Pattern.compile(".*\\.(action|do|ajax)(|\\?.*)");
        System.out.println("aaa.action?aaa=" + rule.matcher("aaa.action?aaad").matches());
        String rules = rule.matcher("http//192.168.0.7/aaa.action?aaad=&bbba").replaceAll("aaa");
        System.out.println(rules);
    }
}

