/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.handler;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.config.JDSUtil;
import com.ds.jds.core.esb.util.ActionContext;
import com.ds.server.httpproxy.core.AbstractHandler;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.Handler;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import com.ds.template.JDSFreemarkerResult;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public class FtlResourceHandler
extends AbstractHandler
implements Handler {
    private static final Log log = LogFactory.getLog((String)"JDS", FtlResourceHandler.class);
    public static final ConfigOption RULE_OPTION = new ConfigOption("rule", true, "Regular expression for matching URLs.");
    Pattern rule;
    private HashMap contextMap;

    @Override
    public boolean initialize(String handlerName, Server server) {
        try {
            super.initialize(handlerName, server);
            this.rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
            log.debug((Object)("Rule=" + this.rule.pattern()));
            return true;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            log.error((Object)e.toString());
            return false;
        }
    }

    @Override
    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        String resource = request.getPath();
        if (!this.rule.matcher(resource).matches()) {
            return false;
        }
        String responseStr = "";
        try {
            JDSFreemarkerResult result = new JDSFreemarkerResult();
            resource = "/ftl" + resource;
            StringWriter stringWriter = (StringWriter)result.doExecute(resource, null);
            responseStr = stringWriter.toString();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        Iterator it = request.getHeaders().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            response.addHeader(key, request.getParameter(key));
        }
        response.setMimeType("text/html;charset=utf-8");
        response.sendResponse(this.getInputStream(responseStr, "utf-8"), -1);
        return true;
    }

    @Override
    public Map getContextMap() {
        if (this.contextMap == null) {
            this.contextMap = new HashMap();
            for (Object obj : ActionContext.getContext().getValueStack().getRoot()) {
                if (!(obj instanceof Map)) continue;
                this.contextMap.putAll((Map)obj);
            }
        }
        return this.contextMap;
    }

    @Override
    public String getExtStr(String ftl) throws IOException, TemplateException {
        StringWriter stringWriter = new StringWriter();
        Configuration configuration = new Configuration();
        try {
            String path = JDSUtil.getJdsRealPath();
            path = path + "/ftl/";
            configuration.setDirectoryForTemplateLoading(new File(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Template template = configuration.getTemplate(ftl);
        template.process((Object)this.getContextMap(), (Writer)stringWriter);
        String str = stringWriter.toString();
        return str;
    }

    @Override
    public InputStream getInputStream(String content, String charSet) {
        if (content == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(content.getBytes(charSet));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

