/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.handler;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.server.httpproxy.core.AbstractHandler;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.Handler;
import com.ds.server.httpproxy.core.Http;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;

public class FileHandler
extends AbstractHandler
implements Handler {
    private static final Log log = LogFactory.getLog((String)"JDS", FileHandler.class);
    public static final ConfigOption ROOT_OPTION = new ConfigOption("root", true, "The path to the directory share files.");
    public static final ConfigOption DEFAULT_FILE_OPTION = new ConfigOption("default-file", "index.html", "The default file to send if no file is specified.");
    public static final String IF_MODIFIED = "If-Modified-Since";
    public static final String LAST_MODIFIED_KEY = "Last-Modified";
    public static final String RANGE_HEADER_KEY = "Range";
    private String root;
    private String defaultFile;

    @Override
    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        this.root = ROOT_OPTION.getProperty(server, handlerName);
        this.defaultFile = DEFAULT_FILE_OPTION.getProperty(server, handlerName);
        return true;
    }

    @Override
    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        File file = Http.translatePath(this.root, request.getUrl().substring(this.getUrlPrefix().length()));
        if (!Http.isSecure(this.root, file)) {
            log.warn((Object)("Access denied to " + file.getAbsolutePath()));
            return false;
        }
        request.putProperty("file-path", file.getAbsolutePath());
        if (file.isDirectory()) {
            file = new File(file, this.defaultFile);
        }
        if (!file.exists()) {
            log.warn((Object)("File " + file.getAbsolutePath() + " was not found."));
            return false;
        }
        String type = this.getMimeType(file.getName());
        if (type != null) {
            FileHandler.sendFile(request, response, file, type);
            return true;
        }
        log.warn((Object)("Mime type for file " + file.getAbsolutePath() + " was not found."));
        return false;
    }

    public static void sendFile(HttpRequest request, HttpResponse response, File file, String type) throws IOException {
        if (!file.isFile()) {
            response.sendError(404, " not a normal file");
            return;
        }
        if (!file.canRead()) {
            response.sendError(403, " Permission Denied");
            return;
        }
        if (request.getRequestHeader(IF_MODIFIED) != null) {
            try {
                long modified = Http.parseTime(request.getRequestHeader(IF_MODIFIED));
                if (file.lastModified() <= modified) {
                    response.setStatusCode(304);
                    return;
                }
            }
            catch (ParseException modified) {
                // empty catch block
            }
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        response.addHeader(LAST_MODIFIED_KEY, Http.formatTime(file.lastModified()));
        long[] range = FileHandler.getRange(request, file);
        response.setMimeType(type);
        response.sendResponse(in, range[0], range[1]);
    }

    private static long[] getRange(HttpRequest request, File file) {
        long[] range = new long[]{0L, file.length()};
        String rangeStr = request.getRequestHeader(RANGE_HEADER_KEY, "bytes=0-");
        int equalSplit = rangeStr.indexOf("=") + 1;
        int split = rangeStr.indexOf("-");
        if (split < -1) {
            try {
                range[0] = Integer.parseInt(rangeStr.substring(equalSplit));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            range[0] = Integer.parseInt(rangeStr.substring(equalSplit, split));
            if (split + 1 < rangeStr.length()) {
                try {
                    range[1] = Integer.parseInt(rangeStr.substring(split + 1, rangeStr.length()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return range;
    }
}

