/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import java.security.SecureRandom;
import java.util.StringTokenizer;

public class UUID
implements Comparable {
    private static SecureRandom randomGenerator = new SecureRandom();
    private long high;
    private long low;

    public UUID(long high, long low) {
        this.high = high;
        this.low = low;
    }

    public static UUID createUUID() {
        byte[] uuid = new byte[16];
        randomGenerator.nextBytes(uuid);
        uuid[6] = (byte)(uuid[6] & 0xF);
        uuid[6] = (byte)(uuid[6] | 0x40);
        uuid[8] = (byte)(uuid[8] & 0x3F);
        uuid[8] = (byte)(uuid[8] | 0x80);
        uuid[10] = (byte)(uuid[10] | 0x80);
        return new UUID(UUID.copyToLong(uuid, 0), UUID.copyToLong(uuid, 8));
    }

    public int compareTo(Object o) {
        UUID uuid = (UUID)o;
        if (this.high < uuid.high) {
            return -1;
        }
        if (this.high == uuid.high) {
            if (this.low < uuid.low) {
                return -1;
            }
            if (this.low == uuid.low) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    private static long copyToLong(byte[] uuid, int start) {
        long num = 0L;
        for (int i = start; i < start + 8; ++i) {
            num = num << 8 | (long)(uuid[i] & 0xFF);
        }
        return num;
    }

    public int hashCode() {
        return (int)(this.high >> 32 ^ this.high ^ this.low >> 32 ^ this.low);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UUID) {
            UUID uuid = (UUID)obj;
            return uuid.high == this.high && uuid.low == this.low;
        }
        return false;
    }

    private static String digits(long num, int i) {
        long shifted = 1L << i * 4;
        return Long.toHexString(shifted | num & shifted - 1L).substring(1);
    }

    public String toString() {
        return UUID.digits(this.high >> 32, 8) + "-" + UUID.digits(this.high >> 16, 4) + "-" + UUID.digits(this.high, 4) + "-" + UUID.digits(this.low >> 48, 4) + "-" + UUID.digits(this.low, 12);
    }

    public static UUID parse(String uuidStr) {
        StringTokenizer token = new StringTokenizer(uuidStr, "-");
        long upper = Long.parseLong(token.nextToken(), 16) << 32;
        upper |= Long.parseLong(token.nextToken(), 16) << 16;
        long lower = Long.parseLong(token.nextToken(), 16) << 48;
        return new UUID(upper |= Long.parseLong(token.nextToken(), 16), lower |= Long.parseLong(token.nextToken(), 16));
    }

    public static void main(String[] args) {
        UUID uuid = UUID.createUUID();
        System.out.println("UUID: (" + uuid + ")");
        System.out.println("UUID: (" + UUID.parse(uuid.toString()) + ")");
        UUID uuid2 = UUID.createUUID();
        System.out.println("UUID: (" + uuid2 + ")");
        System.out.println("UUID: (" + UUID.parse(uuid2.toString()) + ")");
        UUID uuid3 = UUID.createUUID();
        System.out.println("UUID: (" + uuid3 + ")");
        System.out.println("UUID: (" + UUID.parse(uuid3.toString()) + ")");
    }
}

