/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.Server;
import com.ds.server.httpproxy.core.ServerSocketEndPoint;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

public class SSLServerSocketEndPoint
extends ServerSocketEndPoint {
    private static final Log log = LogFactory.getLog((String)"JDS", SSLServerSocketEndPoint.class);
    private static final ConfigOption KEYSTORE_OPTION = new ConfigOption("keystore", true, "The keystore used by the SSL server.");
    private static final ConfigOption STOREPASS_OPTION = new ConfigOption("storepass", true, "The keystore password.");
    private static final ConfigOption KEYPASS_OPTION = new ConfigOption("keypass", false, "The password for the key in the keystore.");
    private static final ConfigOption ALIAS_OPTION = new ConfigOption("alias", "sslkey", "The alias to the key used by the SSL server.");
    private static final ConfigOption CIPHERS_OPTION = new ConfigOption("ciphers", false, "Comma seperated list of ciphers to use for the SSL server.");
    private static final ConfigOption PROTOCOLS_OPTION = new ConfigOption("protocols", false, "Comma seperated list of protocols for SSL server.");
    private static final ConfigOption CLIENT_AUTH_OPTION = new ConfigOption("clientauth", "false", "Require client authentication during SSL handshake.");

    @Override
    public void initialize(String name, Server server) throws IOException {
        super.initialize(name, server);
        try {
            File keystoreFile = new File(KEYSTORE_OPTION.getProperty(server, this.endpointName));
            String storepass = STOREPASS_OPTION.getProperty(server, this.endpointName);
            String keypass = KEYPASS_OPTION.getProperty(server, this.endpointName);
            keypass = keypass == null ? storepass : keypass;
            KeyStore keystore = this.loadKeystoreFromFile(keystoreFile, storepass.toCharArray());
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(this.getKeyManagers(keystore, keypass.toCharArray(), ALIAS_OPTION.getProperty(server, this.endpointName)), this.getTrustManagers(keystore), null);
            this.factory = context.getServerSocketFactory();
        }
        catch (GeneralSecurityException e) {
            log.error((Object)"Security Exception while initializing.", (Throwable)e);
            throw (IOException)new IOException().initCause(e);
        }
    }

    @Override
    protected String getProtocol() {
        return "https";
    }

    @Override
    protected ServerSocket createSocket(int port) throws IOException {
        boolean clientAuth;
        String protocols;
        ServerSocket serverSocket = super.createSocket(port);
        String cipherSuites = CIPHERS_OPTION.getProperty(this.server, this.getName());
        if (cipherSuites != null) {
            ((SSLServerSocket)serverSocket).setEnabledCipherSuites(cipherSuites.split(","));
        }
        if ((protocols = PROTOCOLS_OPTION.getProperty(this.server, this.getName())) != null) {
            ((SSLServerSocket)serverSocket).setEnabledProtocols(protocols.split(","));
        }
        if (clientAuth = CLIENT_AUTH_OPTION.getBoolean(this.server, this.getName()).booleanValue()) {
            ((SSLServerSocket)serverSocket).setNeedClientAuth(true);
        }
        return serverSocket;
    }

    private KeyStore loadKeystoreFromFile(File file, char[] password) throws IOException, GeneralSecurityException {
        KeyStore keystore = KeyStore.getInstance("JKS");
        FileInputStream stream = new FileInputStream(file);
        keystore.load(stream, password);
        ((InputStream)stream).close();
        return keystore;
    }

    private TrustManager[] getTrustManagers(KeyStore keystore) throws GeneralSecurityException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance("SunX509");
        factory.init(keystore);
        return factory.getTrustManagers();
    }

    private KeyManager[] getKeyManagers(KeyStore keystore, char[] pwd, String alias) throws GeneralSecurityException {
        KeyManagerFactory factory = KeyManagerFactory.getInstance("SunX509");
        factory.init(keystore, pwd);
        KeyManager[] kms = factory.getKeyManagers();
        if (alias != null) {
            for (int i = 0; i < kms.length; ++i) {
                if (!(kms[i] instanceof X509KeyManager)) continue;
                kms[i] = new AliasForcingKeyManager((X509KeyManager)kms[i], alias);
            }
        }
        return kms;
    }

    private class AliasForcingKeyManager
    implements X509KeyManager {
        X509KeyManager baseKM = null;
        String alias = null;

        public AliasForcingKeyManager(X509KeyManager keyManager, String alias) {
            this.baseKM = keyManager;
            this.alias = alias;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.baseKM.chooseClientAlias(keyType, issuers, socket);
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            String[] validAliases = this.baseKM.getServerAliases(keyType, issuers);
            if (validAliases != null) {
                for (int j = 0; j < validAliases.length; ++j) {
                    if (!validAliases[j].equals(this.alias)) continue;
                    return this.alias;
                }
            }
            return this.baseKM.chooseServerAlias(keyType, issuers, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.baseKM.getCertificateChain(alias);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.baseKM.getClientAliases(keyType, issuers);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.baseKM.getPrivateKey(alias);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.baseKM.getServerAliases(keyType, issuers);
        }
    }
}

