/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import com.ds.server.httpproxy.core.ChunkedEncodingOutputStream;
import com.ds.server.httpproxy.core.InputStreamResponseData;
import com.ds.server.httpproxy.core.PrintWriterResponseData;
import com.ds.server.httpproxy.core.ResponseData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;

public class ResponseDataList {
    List dataStreamList = new LinkedList();

    public void addResponse(ResponseData data) {
        this.dataStreamList.add(data);
    }

    public void addResponse(InputStream stream, long length) {
        this.addResponse(stream, 0L, length);
    }

    public void addResponse(InputStream stream, long offset, long length) {
        this.addResponse(new InputStreamResponseData(stream, offset, length));
    }

    public PrintWriter addPrintWriter() {
        PrintWriterResponseData data = new PrintWriterResponseData();
        this.addResponse(data);
        return data.getPrintWriter();
    }

    public long getTotalLength() {
        long total = 0L;
        for (ResponseData responseData : this.dataStreamList) {
            long len = responseData.getLength();
            total = total >= 0L && len > 0L ? total + len : -1L;
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(OutputStream os, boolean isChunkedOk) throws IOException {
        try {
            if (this.getTotalLength() < 0L && isChunkedOk) {
                os = new ChunkedEncodingOutputStream(os);
            }
            for (ResponseData responseData : this.dataStreamList) {
                responseData.send(os);
            }
        }
        finally {
            this.dataStreamList.clear();
            os.flush();
            os.close();
        }
    }

    public void reset() {
        this.dataStreamList.clear();
    }
}

