/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import com.ds.server.httpproxy.core.ChainableProperties;
import java.net.Socket;
import java.util.Properties;

public abstract class Request {
    private Properties requestProperties;
    private boolean isInternal = false;
    protected Socket connection;

    public Request(Socket connection, Properties serverConfig) {
        this.connection = connection;
        this.requestProperties = new ChainableProperties(serverConfig);
    }

    public String getProperty(String key, String defaultValue) {
        return this.requestProperties.getProperty(key, defaultValue);
    }

    public void putProperty(String key, String value) {
        this.requestProperties.put(key, value);
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    protected void setIsInternal(boolean isItInternal) {
        this.isInternal = isItInternal;
    }

    public String getLocalAddr() {
        return this.connection.getLocalAddress().getHostAddress();
    }

    public int getLocalPort() {
        return this.connection.getLocalPort();
    }

    public String getRemoteAddr() {
        return this.connection.getInetAddress().getHostAddress();
    }

    public int getRemotePort() {
        return this.connection.getPort();
    }
}

