/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class NonBlockingRunnable
implements Runnable {
    private static final Log log = LogFactory.getLog((String)"JDS", NonBlockingRunnable.class);
    Server server;
    Socket socket;
    InputStream is;
    OutputStream os;

    public NonBlockingRunnable(Server server, Socket aSocket, InputStream anIn, OutputStream anOut) {
        this.server = server;
        this.socket = aSocket;
        this.is = anIn;
        this.os = anOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            boolean next = false;
            do {
                HttpRequest request;
                if (!(next = (request = new HttpRequest("http", this.socket, this.server.getConfig())).readRequest(this.is))) continue;
                HttpResponse response = new HttpResponse(request, this.os, this.server.getResponseListeners());
                if (!this.server.post(request, response)) {
                    response.sendError(404, " was not found on this server.");
                }
                if (!(next = response.isKeepAlive())) {
                    response.addHeader("Connection", "close");
                }
                response.commitResponse();
            } while (next);
        }
        catch (EOFException eof) {
            log.error((Object)"Closing connection");
        }
        catch (IOException e) {
            log.error((Object)"IOException", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Handler threw an exception.", (Throwable)e);
        }
        finally {
            try {
                this.is.close();
            }
            catch (IOException eof) {}
            try {
                this.os.close();
            }
            catch (IOException eof) {}
        }
    }
}

