/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import com.ds.common.util.IOUtility;
import com.ds.server.httpproxy.core.ResponseData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputStreamResponseData
implements ResponseData {
    InputStream theData;
    long offset = 0L;
    long length = -1L;
    private static final int SEND_BUFFER_SIZE = 4096;

    public InputStreamResponseData(InputStream theData, long length) {
        this.theData = theData;
        this.length = length;
    }

    public InputStreamResponseData(InputStream theData, long offset, long length) {
        this.theData = theData;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public long getLength() {
        if (this.offset < this.length) {
            return this.length - this.offset;
        }
        return -1L;
    }

    @Override
    public void send(OutputStream os) throws IOException {
        this.theData.skip(this.offset);
        byte[] buffer = new byte[Math.min(4096, (int)(this.length > 0L ? this.length : Integer.MAX_VALUE))];
        int totalSent = 0;
        try {
            int bufLen;
            while ((bufLen = this.theData.read(buffer)) >= 0) {
                os.write(buffer, 0, bufLen);
                totalSent += bufLen;
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            IOUtility.shutdownStream((InputStream)this.theData);
        }
    }
}

