/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.context;

import com.ds.common.JDSException;
import com.ds.context.JDSActionContext;
import com.ds.esb.util.EsbFactory;
import com.ds.jds.core.esb.util.ActionContext;
import com.ds.jds.core.esb.util.JDSConverter;
import com.ds.jds.core.esb.util.OgnlValueStack;
import com.ds.server.JDSServer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import ognl.ClassResolver;
import ognl.OgnlContext;
import ognl.OgnlRuntime;
import ognl.TypeConverter;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringMvcContextImpl
extends JDSActionContext {
    Map contextMap = new HashMap();

    public OgnlContext getOgnlContext() {
        HttpServletRequest request = (HttpServletRequest)this.getHttpRequest();
        if (this.ognlContext == null && request != null) {
            Map objectMap = this.getContext();
            OgnlRuntime.clearCache();
            this.ognlContext = new OgnlContext((ClassResolver)OgnlValueStack.getAccessor(), (TypeConverter)JDSConverter.getInstance(), null, objectMap);
        }
        return this.ognlContext;
    }

    public Object Par(String expression) {
        Object obj = null;
        try {
            obj = this.Par(expression, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    public Map getContext() {
        if (RequestContextHolder.getRequestAttributes() != null) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            Map httpVariableMap = request.getParameterMap();
            if (httpVariableMap != null) {
                Set keSet = httpVariableMap.keySet();
                for (String key : keSet) {
                    String[] objects = (String[])httpVariableMap.get(key);
                    if (objects == null) continue;
                    if (objects.length == 1) {
                        this.contextMap.put(key, objects[0]);
                        continue;
                    }
                    this.contextMap.put(key, objects);
                }
            }
            if (this.getSession() != null) {
                this.contextMap.putAll(this.getSession());
            }
        }
        return this.contextMap;
    }

    public Object getParams(String param) {
        HttpServletRequest request;
        String value = null;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null && (request = requestAttributes.getRequest()) != null) {
            Object obj;
            value = (String)request.getAttribute(param);
            if (value == null) {
                value = request.getParameter(param);
            }
            if ((value == null || value.equals("")) && (obj = this.getContext().get(param)) != null) {
                if (obj.getClass().isArray()) {
                    Object[] objs = (Object[])this.getContext().get(param);
                    if (objs.length > 0 && objs[0] != null) {
                        value = objs[0].toString();
                    }
                } else {
                    value = obj.toString();
                }
            }
            if (value == null) {
                value = (String)this.getSession().get(param);
            }
        }
        return value;
    }

    public String getIpAddr() {
        String ip = null;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            HttpServletRequest request = requestAttributes.getRequest();
            ip = request.getHeader("X-Forwarded-For");
            String gatewayip = request.getHeader("gateway-ip");
            if (gatewayip != null && !gatewayip.equals("")) {
                ip = gatewayip;
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_CLIENT_IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
            }
        }
        return ip;
    }

    public Map getSession() {
        HttpSession session;
        HttpServletRequest request;
        Map sessionMap = new HashMap();
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null && (request = requestAttributes.getRequest()) != null && (sessionMap = (Map)(session = request.getSession(true)).getAttribute("sessionMap")) == null) {
            sessionMap = new HashMap();
            session.putValue("sessionMap", sessionMap);
        }
        return sessionMap;
    }

    public String getSessionId() {
        String sessionid = null;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
            sessionid = (String)this.getParams("JSESSIONID");
            String rSessionId = (String)this.getParams("RSESSIONID");
            if (rSessionId != null && !rSessionId.equals("")) {
                sessionid = rSessionId;
            }
            if (sessionid == null || sessionid.equals("") || sessionid.equals("\"\"")) {
                sessionid = request.getSession(true).getId();
                this.getSession().put("JSESSIONID", sessionid);
                request.getSession().setAttribute("JSESSIONID", (Object)sessionid);
            }
        }
        return sessionid;
    }

    public <T> T Par(String expression, Class<T> clazz) {
        return this.Par(expression, clazz, null);
    }

    public <T> T Par(Class<T> clazz) {
        Object o = EsbFactory.par(clazz);
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            HttpServletRequest request = requestAttributes.getRequest();
            WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext());
            webApplicationContext.getAutowireCapableBeanFactory().autowireBean(o);
        }
        return (T)o;
    }

    public <T> T Par(String expression, Class<T> clazz, Object source) {
        RequestAttributes requestAttributes;
        Object o = EsbFactory.par((String)expression, (Map)ActionContext.getContext().getContextMap(), (Object)source, clazz);
        if (o != null && (requestAttributes = RequestContextHolder.getRequestAttributes()) != null) {
            HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
            WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext());
            webApplicationContext.getAutowireCapableBeanFactory().autowireBean(o);
        }
        return (T)o;
    }

    public Object getHttpRequest() {
        HttpServletRequest request = null;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            request = requestAttributes.getRequest();
        }
        return request;
    }

    public Object getHttpResponse() {
        HttpServletResponse response = null;
        if (RequestContextHolder.getRequestAttributes() != null) {
            response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        }
        return response;
    }

    public String getHost() {
        try {
            return JDSServer.getInstance().getCurrServerBean().getUrl();
        }
        catch (JDSException e) {
            e.printStackTrace();
            return null;
        }
    }
}

