/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.comet;

import com.ds.common.ConfigCode;
import com.ds.common.JDSException;
import com.ds.context.JDSCometContext;
import com.ds.context.JDSContext;
import com.ds.engine.ConnectInfo;
import com.ds.engine.ConnectionHandle;
import com.ds.engine.JDSSessionHandle;
import com.ds.msg.Msg;
import com.ds.server.JDSClientService;
import com.ds.server.JDSServer;
import com.ds.server.comet.AbstractCometHandle;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GWReConnectCometHandle
extends AbstractCometHandle {
    public GWReConnectCometHandle(JDSClientService client, JDSSessionHandle sessionHandle, String systemCode) throws JDSException {
        super(client, sessionHandle, systemCode);
    }

    public void receive(String receiveStr) throws JDSException {
        logger.info((Object)("receive user:[" + this.getConnectInfo().getLoginName() + "] "));
        logger.info((Object)receiveStr);
    }

    @Override
    public boolean send(String msgString) throws JDSException {
        logger.info((Object)msgString);
        return super.send(msgString);
    }

    @Override
    public void connect(JDSContext context) throws JDSException {
        if (!(context instanceof JDSCometContext)) {
            throw new JDSException("\u7528\u6237\u672a\u767b\u5f55\uff01", 1000);
        }
        JDSCometContext cometContext = (JDSCometContext)context;
        this.request = (HttpServletRequest)cometContext.getHttpRequest();
        this.response = (HttpServletResponse)cometContext.getHttpResponse();
        if (this.connectInfo == null) {
            this.connectInfo = this.getClient().getConnectInfo();
        }
        if (this.connectInfo == null) {
            throw new JDSException("\u7528\u6237\u672a\u767b\u5f55\uff01", 1000);
        }
        Set sessionHandleList = JDSServer.getInstance().getSessionHandleList(this.connectInfo);
        ArrayList newsessionHandleList = new ArrayList();
        if (sessionHandleList != null) {
            newsessionHandleList.addAll(sessionHandleList);
            for (JDSSessionHandle handle : newsessionHandleList) {
                if (handle == null || handle.getSessionID().toString().equals(context.getSessionId()) || JDSServer.getInstance().getConnectTimeCache().get((Object)handle) == null) continue;
                JDSServer.getInstance().disconnect(handle);
            }
        }
        this.client.connect(this.connectInfo);
        logger.info((Object)("user:" + this.connectInfo.getLoginName() + "[" + this.sessionHandle.getSessionID() + "] cometLogin success"));
        int k = 0;
        while (this.isClose) {
            JDSClientService client = this.getClient();
            ConnectInfo connectionInfo = client.getConnectInfo();
            if (client != null && connectionInfo != null) {
                AbstractCometHandle.ConnectionServer connectTask;
                Long lastLoginTime = (Long)checkTime.get(context.getSessionId());
                Long lastCommandTime = (Long)checkHeart.get("Herat" + context.getSessionId() + "");
                if (lastCommandTime == null) {
                    lastCommandTime = System.currentTimeMillis();
                    checkHeart.put("Herat" + context.getSessionId() + "", lastCommandTime);
                }
                Long lastHeartTime = (Long)checkCommandHeart.get(context.getSessionId());
                if (lastLoginTime == null) {
                    lastLoginTime = System.currentTimeMillis();
                    checkTime.put(context.getSessionId(), lastLoginTime);
                    connectTask = new AbstractCometHandle.ConnectionServer(client, this.connectInfo);
                    GWReConnectCometHandle.getCommandService(this.connectInfo.getUserID()).submit(connectTask);
                }
                if (System.currentTimeMillis() - lastLoginTime > 300000L) {
                    checkTime.put(context.getSessionId(), System.currentTimeMillis());
                    connectTask = new AbstractCometHandle.ConnectionServer(client, this.connectInfo);
                    GWReConnectCometHandle.getCommandService(this.connectInfo.getUserID()).submit(connectTask);
                }
                if (lastHeartTime == null) {
                    lastHeartTime = System.currentTimeMillis();
                    checkCommandHeart.put(context.getSessionId(), lastHeartTime);
                }
                if (System.currentTimeMillis() - lastCommandTime < 45000L) {
                    this.send("0");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        this.isClose = false;
                        this.send(e.getMessage());
                    }
                    ++k;
                    continue;
                }
                this.isClose = false;
                client.getConnectionHandle().disconnect();
                continue;
            }
            this.isClose = false;
            this.send("sessionId is  null,  place login frist!");
            this.disconnect();
        }
    }

    @Override
    public void disconnect() throws JDSException {
        super.disconnect();
    }

    @Override
    public boolean repeatMsg(Msg msg, JDSSessionHandle handle) throws JDSException {
        return false;
    }

    class ClearSession
    implements Runnable {
        private ConnectionHandle sessionHandle;
        private ConnectInfo connectInfo;
        private String systemCode;

        ClearSession(ConnectInfo connectInfo, ConnectionHandle handle, String systemCode) {
            this.sessionHandle = handle;
            this.connectInfo = connectInfo;
            this.systemCode = systemCode;
        }

        @Override
        public void run() {
            try {
                Set sessionHandleList = JDSServer.getInstance().getSessionHandleList(this.connectInfo);
                ConfigCode configCode = JDSServer.getClusterClient().getSystem(this.systemCode).getConfigname();
                for (JDSSessionHandle handle : sessionHandleList) {
                    JDSClientService client;
                    if (handle.toString().equals(this.sessionHandle.toString()) || (client = JDSServer.getInstance().getJDSClientService(handle, configCode)) == null || client.getConnectInfo() == null) continue;
                    client.getConnectionHandle().disconnect();
                }
            }
            catch (JDSException e) {
                e.printStackTrace();
            }
        }
    }
}

