/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.comet;

import com.alibaba.fastjson.JSONObject;
import com.ds.annotation.Enumstype;
import com.ds.client.JDSSessionFactory;
import com.ds.common.JDSCommand;
import com.ds.common.JDSException;
import com.ds.common.cache.Cache;
import com.ds.common.cache.CacheManagerFactory;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.context.JDSActionContext;
import com.ds.context.JDSContext;
import com.ds.engine.ConnectInfo;
import com.ds.engine.ConnectionHandle;
import com.ds.engine.JDSSessionHandle;
import com.ds.msg.Msg;
import com.ds.org.conf.OrgConstants;
import com.ds.server.JDSClientService;
import com.ds.server.JDSServer;
import com.ds.thread.JDSThreadFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.cglib.beans.BeanMap;

public abstract class AbstractCometHandle
implements ConnectionHandle {
    protected JDSSessionHandle sessionHandle;
    protected ConnectInfo connectInfo;
    private String systemCode;
    public static final String HEARTKEY = "0";
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected JDSClientService client;
    public static Map<String, Long> commandMap = CacheManagerFactory.createCache((String)"org", (String)"CommandCache", (int)0x500000, (long)3600000L);
    public static Cache<String, String> sessionMapUser = CacheManagerFactory.createCache((String)"JDS", (String)"SessionMapUser", (int)0x100000, (long)3600000L);
    protected static Map<String, ScheduledExecutorService> commandServiceMap = new HashMap<String, ScheduledExecutorService>();
    public static Map<String, Long> checkHeart = CacheManagerFactory.createCache((String)OrgConstants.CONFIG_KEY.getType(), (String)"checkHeartCache", (int)0x100000, (long)3600000L);
    protected static Map<String, Long> checkCommandHeart = CacheManagerFactory.createCache((String)OrgConstants.CONFIG_KEY.getType(), (String)"checkCommandHeartCache", (int)0x100000, (long)3600000L);
    protected static Map<String, Long> checkTime = CacheManagerFactory.createCache((String)OrgConstants.CONFIG_KEY.getType(), (String)"checkTimeCache", (int)0x100000, (long)3600000L);
    public static final Log logger = LogFactory.getLog((String)"JDS", ConnectionHandle.class);
    protected boolean isClose = true;
    boolean isStart = true;

    protected static synchronized ScheduledExecutorService getCommandService(String userId) {
        ScheduledExecutorService service = commandServiceMap.get(userId);
        if (service == null || service.isShutdown()) {
            service = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new JDSThreadFactory("AbstractCometHandle.getCommandService"));
            commandServiceMap.put(userId, service);
        }
        return service;
    }

    public AbstractCometHandle(JDSClientService client, JDSSessionHandle sessionHandle, String systemCode) throws JDSException {
        this.client = client;
        this.systemCode = systemCode;
        this.sessionHandle = sessionHandle;
    }

    public void disconnect() throws JDSException {
        this.isClose = false;
        try {
            if (this.getClient() != null) {
                this.getClient().disconnect();
            }
        }
        catch (JDSException e) {
            throw new JDSException((Throwable)e);
        }
    }

    public void reConnect() throws JDSException {
        this.disconnect();
        JDSSessionFactory factory = new JDSSessionFactory(JDSActionContext.getActionContext());
        JDSSessionHandle sessionHandle = factory.createSessionHandle();
        JDSActionContext.getActionContext().getContext().put("JSESSIONID", sessionHandle.getSessionID());
        this.request.setAttribute("JSESSIONID", (Object)sessionHandle.getSessionID());
        try {
            this.client = JDSServer.getInstance().getAdminClient() != null ? factory.newClientService(sessionHandle, JDSServer.getInstance().getAdminClient().getConfigCode()) : factory.newClientService(sessionHandle, JDSServer.getInstance().getCurrServerBean().getConfigCode());
        }
        catch (JDSException e) {
            this.client = factory.newClientService(sessionHandle, JDSServer.getInstance().getCurrServerBean().getConfigCode());
        }
        this.client.connect(this.connectInfo);
        logger.info((Object)("reConnect:" + this.connectInfo.getLoginName() + "[" + this.client.getContext().getSessionId() + "] reconnect success"));
        this.isClose = false;
    }

    public void connect(JDSContext context) throws JDSException {
        logger.info((Object)("user:" + this.connectInfo.getLoginName() + "[" + this.client.getContext().getSessionId() + "] cometLogin success"));
        int k = 0;
        while (this.isClose) {
            JDSClientService client = this.getClient();
            ConnectInfo connectionInfo = client.getConnectInfo();
            if (client != null && connectionInfo != null) {
                Long lastHeartTime;
                Long lastLoginTime = checkTime.get(context.getSessionId());
                Long lastCommandTime = checkHeart.get("Herat" + context.getSessionId() + "");
                if (lastCommandTime == null) {
                    lastCommandTime = System.currentTimeMillis();
                    checkHeart.put("Herat" + context.getSessionId() + "", lastCommandTime);
                }
                if ((lastHeartTime = checkCommandHeart.get(context.getSessionId())) == null) {
                    lastHeartTime = System.currentTimeMillis();
                    checkCommandHeart.put(context.getSessionId(), lastHeartTime);
                }
                this.send(HEARTKEY);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    this.isClose = false;
                    this.send(e.getMessage());
                }
                ++k;
                continue;
            }
            this.isClose = false;
            this.send("sessionId is  null,  place login frist!");
            this.disconnect();
        }
    }

    public JDSClientService getClient() throws JDSException {
        return this.client;
    }

    public JDSSessionHandle getSessionHandle() {
        return this.sessionHandle;
    }

    public boolean isconnect() throws JDSException {
        return this.response != null;
    }

    public boolean repeatCommand(JDSCommand command, JDSSessionHandle handle) throws JDSException {
        JDSClientService client = this.getClient();
        if (client != null && client.getConnectInfo() != null && client.getConnectionHandle().isconnect()) {
            logger.info((Object)("comet command [" + JSONObject.toJSONString((Object)command) + "]"));
            return client.getConnectionHandle().send(command);
        }
        return false;
    }

    public boolean repeatMsg(Msg msg, JDSSessionHandle handle) throws JDSException {
        return true;
    }

    public synchronized boolean send(JDSCommand command) throws JDSException {
        String sessionId = "";
        if (this.client != null && this.client.getContext().getSessionId() != null) {
            sessionId = this.client.getContext().getSessionId();
        }
        String token = sessionId + "[" + command.getCommandId() + "]";
        logger.info((Object)("start " + token + " comet command [" + JSONObject.toJSONString((Object)command) + "]"));
        Boolean isSuccess = false;
        BeanMap commandBeanmap = BeanMap.create((Object)command);
        Enumstype commandCMD = (Enumstype)commandBeanmap.get("command");
        if (commandCMD == null) {
            isSuccess = false;
        } else {
            Long checkOutTime = commandMap.get(token);
            if (checkOutTime == null || checkOutTime - System.currentTimeMillis() > 2000L) {
                logger.info((Object)("comet command [" + JSONObject.toJSONString((Object)command) + "]"));
                Iterator keyit = commandBeanmap.keySet().iterator();
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                while (keyit.hasNext()) {
                    String key = (String)keyit.next();
                    Object value = commandBeanmap.get(key);
                    if (value == null || value.equals("")) continue;
                    if (key.equals("passVal1")) {
                        Integer pass = Integer.valueOf(value.toString());
                        valueMap.put("passVal1", pass);
                        continue;
                    }
                    valueMap.put(key, (Integer)value);
                }
                String commandStr = JSONObject.toJSON(valueMap).toString();
                logger.info((Object)("send command [" + commandStr + "]"));
                isSuccess = this.send(commandStr);
                if (isSuccess.booleanValue()) {
                    commandMap.put(token, System.currentTimeMillis());
                }
            }
        }
        logger.info((Object)("end comet command [" + JSONObject.toJSONString((Object)command) + "]"));
        return isSuccess;
    }

    public synchronized boolean send(String msgString) throws JDSException {
        block4: {
            if (this.response != null) {
                try {
                    this.response.getWriter().println(msgString);
                    this.response.getWriter().flush();
                    this.response.flushBuffer();
                    if (this.response.getWriter().checkError()) {
                        this.isClose = false;
                        this.disconnect();
                        return false;
                    }
                    break block4;
                }
                catch (Exception e) {
                    logger.error((Object)("msg[" + msgString + "] send error"));
                    this.isClose = false;
                    this.disconnect();
                    return false;
                }
            }
            this.disconnect();
            return false;
        }
        return true;
    }

    public ConnectInfo getConnectInfo() {
        return this.connectInfo;
    }

    public void setConnectInfo(ConnectInfo connectInfo) {
        this.connectInfo = connectInfo;
    }

    public String getSystemCode() {
        return this.systemCode;
    }

    public void setSystemCode(String systemCode) {
        this.systemCode = systemCode;
    }

    public static void main(String[] args) {
        String commandUrl = "http://smart.tujia.com:83/comet";
        String sessionid = "dddfffffffffffffff";
        String command = "{\"command\":\"CommandReConnect\",\"url\":\"" + commandUrl + "\",\"sessionid\":\"" + sessionid + "\"}";
        System.out.println(command + System.currentTimeMillis());
    }

    public static Map<String, Long> getCheckHeart() {
        return checkHeart;
    }

    public static void setCheckHeart(Map<String, Long> checkHeart) {
        AbstractCometHandle.checkHeart = checkHeart;
    }

    protected class ConnectionServer
    implements Callable<JDSClientService> {
        private JDSClientService clientService;
        private ConnectInfo connInfo;

        public ConnectionServer(JDSClientService clientService, ConnectInfo connInfo) {
            this.connInfo = connInfo;
            this.clientService = clientService;
        }

        @Override
        public JDSClientService call() throws JDSException {
            this.clientService.connect(this.connInfo);
            return this.clientService;
        }
    }
}

