package com.ds.server.udp.mqtt;

import com.ds.cluster.ServerNode;
import com.ds.cluster.udp.ClusterEvent;
import com.ds.common.JDSConstants;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.engine.ConnectInfo;
import com.ds.engine.JDSSessionHandle;
import com.ds.org.Person;
import com.ds.org.PersonNotFoundException;
import com.ds.server.JDSServer;
import com.ds.server.JDSUDPServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.udp.UDPServerEventTask;
import com.ds.web.RemoteConnectionManager;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class RepeatMqttMsg implements Runnable {
    private static final Log logger = LogFactory.getLog(JDSConstants.CONFIG_KEY, RepeatMqttMsg.class);

    private final String subsystemCode;
    private final ClusterEvent event;

    public RepeatMqttMsg(ClusterEvent event, final String subsystemCode) {
        this.subsystemCode = subsystemCode;
        this.event = event;
    }

    @Override
    public void run() {
        ServerNode remoteServerBean = JDSServer.getClusterClient().getServerNodeById(subsystemCode);
        ExecutorService service = RemoteConnectionManager.getConntctionService("RepeatSeverMsg[" + remoteServerBean.getId() + "]");
        try {
            final ServerNode currServerBean = JDSServer.getInstance().getCurrServerBean();
            if (event.getEventId() == null) {
                event.setMsgId(UUID.randomUUID().toString());
            }
            List<UDPServerEventTask> taskList = new ArrayList<UDPServerEventTask>();
            if (currServerBean.getType() != null && currServerBean.getType().equals("main")) {
                final List<ServerNode> systems = JDSServer.getClusterClient().getAllServer();
                for (final ServerNode node : systems) {
                    if (node.getAdminPersonId() != null) {
                        try {
                            Set<String> personIds = remoteServerBean.getAdminPersonIds();
                            for (String personId : personIds) {
                                Person toPerson = OrgManagerFactory.getOrgManager().getPersonByAccount(personId);
                                final ConnectInfo connInfo = new ConnectInfo(toPerson.getID(), toPerson.getAccount(), toPerson.getPassword());
                                final Set<JDSSessionHandle> sessionHandleList = JDSServer.getInstance().getSessionHandleList(connInfo);
                                Set<String> serverKeys = JDSUDPServer.getInstance().getRepeatEventKey(node.getId());
                                if (serverKeys.contains(event.getExpression()) && sessionHandleList != null && sessionHandleList.size() > 0) {
                                    taskList.add(new UDPServerEventTask(node.getId(), event.clone()));
                                }
                            }
                        } catch (PersonNotFoundException e) {
                            e.printStackTrace();
                        }

                    }

                }
            }
            logger.info("taskList  =======size=" + taskList.size());
            List<Future<List<ClusterEvent>>> tasks = service.invokeAll(taskList);

            for (Future<List<ClusterEvent>> future : tasks) {
                List<ClusterEvent> events = future.get(5, TimeUnit.SECONDS);
            }

        } catch (Exception e) {

            e.printStackTrace();
        }

    }

}
