package com.ds.server.udp.mqtt;

import com.ds.cluster.ServerNode;
import com.ds.cluster.udp.ClusterEvent;
import com.ds.engine.ConnectInfo;
import com.ds.engine.JDSSessionHandle;
import com.ds.org.Person;
import com.ds.server.JDSServer;
import com.ds.server.OrgManagerFactory;
import com.ds.web.RemoteConnectionManager;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class MqttEventTask implements Callable<List<ClusterEvent>> {


    private final String systemCode;
    private final ClusterEvent event;

    public MqttEventTask(String systemCode, ClusterEvent event) {
        this.systemCode = systemCode;
        this.event = event;
    }


    @Override
    public List<ClusterEvent> call() throws Exception {
        List<ClusterEvent> events = new ArrayList<ClusterEvent>();
        final ServerNode remoteServerBean = JDSServer.getClusterClient().getServerNodeById(systemCode);
        if (remoteServerBean != null) {

            try {
                Set<String> personIds = remoteServerBean.getAdminPersonIds();
                for (String personId : personIds) {
                    Person toPerson = OrgManagerFactory.getOrgManager().getPersonByAccount(personId);
                    final ConnectInfo connInfo = new ConnectInfo(toPerson.getID(), toPerson.getAccount(), toPerson.getPassword());
                    final Set<JDSSessionHandle> sessionHandleList = JDSServer.getInstance().getSessionHandleList(connInfo);
                    if (sessionHandleList != null && sessionHandleList.size() > 0) {
                        List<SendMqttMsgTask> taskList = new ArrayList<SendMqttMsgTask>();
                        for (final JDSSessionHandle serverhandle : sessionHandleList) {
                            long currentTime = System.currentTimeMillis();
                            Long loginTime = (Long) JDSServer.getInstance().getConnectTimeCache().get(serverhandle.toString());
                            if (loginTime != null && ((currentTime - loginTime.longValue()) < 30 * 1000)) {
                                ClusterEvent cevent = event.clone();
                                events.add(cevent);
                                SendMqttMsgTask task = new SendMqttMsgTask(serverhandle, cevent, systemCode);
                                taskList.add(task);
                            }
                        }
                        ExecutorService service = RemoteConnectionManager.getConntctionService(remoteServerBean.getUrl());
                        switch (event.getSequence()) {
                            case FIRST:
                                service.submit(taskList.get(0)).get();
                                break;
                            case MEANWHILE:
                                List<Future<Boolean>> tasks = service.invokeAll(taskList);
                                for (Future<Boolean> future : tasks) {
                                    future.get();
                                }
                                break;
                            case SEQUENCE:
                                for (SendMqttMsgTask task : taskList) {
                                    Boolean result = service.submit(task).get();
                                    if (result == null || !result) {
                                        break;
                                    }
                                }
                            default:
                                break;
                        }
                    }

                }


            } catch (final Exception e) {
                e.printStackTrace();
            }
        }
        return events;
    }
}
