/*
 * Decompiled with CFR 0.152.
 */
package com.ds.web.util;

import com.ds.web.util.AnnotationUtil;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RequestMapping;

@Component
public class SpringPlugs
implements ResourceLoaderAware,
ApplicationContextAware {
    private static final String DEFAULT_RESOURCE_PATTERN = "**/*.class";
    private MetadataReaderFactory metadataReaderFactory;
    private ResourcePatternResolver resourcePatternResolver;
    private ApplicationContext applicationContext;

    public Set<Class<?>> scannerPackages(String[] basePackages) {
        LinkedHashSet set = new LinkedHashSet();
        try {
            for (String basePackage : basePackages) {
                Resource[] resources;
                String packageSearchPath = "classpath*:" + this.resolveBasePackage(basePackage) + '/' + DEFAULT_RESOURCE_PATTERN;
                for (Resource resource : resources = this.resourcePatternResolver.getResources(packageSearchPath)) {
                    if (!resource.isReadable()) continue;
                    MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(resource);
                    String className = metadataReader.getClassMetadata().getClassName();
                    try {
                        Class<?> clazz = Class.forName(className);
                        if (AnnotationUtil.getClassAnnotation(clazz, RequestMapping.class) == null || AnnotationUtil.getClassAnnotation(clazz, Controller.class) == null) continue;
                        set.add(clazz);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return set;
    }

    protected String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)this.getEnvironment().resolveRequiredPlaceholders(basePackage));
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private Environment getEnvironment() {
        return this.applicationContext.getEnvironment();
    }
}

