/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.udp.mqtt;

import com.ds.cluster.ServerNode;
import com.ds.cluster.udp.ClusterEvent;
import com.ds.engine.ConnectInfo;
import com.ds.engine.JDSSessionHandle;
import com.ds.org.Person;
import com.ds.server.JDSServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.udp.mqtt.SendMqttMsgTask;
import com.ds.web.RemoteConnectionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class MqttEventTask
implements Callable<List<ClusterEvent>> {
    private final String systemCode;
    private final ClusterEvent event;

    public MqttEventTask(String systemCode, ClusterEvent event) {
        this.systemCode = systemCode;
        this.event = event;
    }

    @Override
    public List<ClusterEvent> call() throws Exception {
        ArrayList<ClusterEvent> events = new ArrayList<ClusterEvent>();
        ServerNode remoteServerBean = JDSServer.getClusterClient().getServerNodeById(this.systemCode);
        if (remoteServerBean != null) {
            try {
                Set personIds = remoteServerBean.getAdminPersonIds();
                block7: for (String personId : personIds) {
                    Person toPerson = OrgManagerFactory.getOrgManager().getPersonByAccount(personId);
                    ConnectInfo connInfo = new ConnectInfo(toPerson.getID(), toPerson.getAccount(), toPerson.getPassword());
                    Set sessionHandleList = JDSServer.getInstance().getSessionHandleList(connInfo);
                    if (sessionHandleList == null || sessionHandleList.size() <= 0) continue;
                    ArrayList<SendMqttMsgTask> taskList = new ArrayList<SendMqttMsgTask>();
                    for (JDSSessionHandle serverhandle : sessionHandleList) {
                        long currentTime = System.currentTimeMillis();
                        Long loginTime = (Long)JDSServer.getInstance().getConnectTimeCache().get((Object)serverhandle.toString());
                        if (loginTime == null || currentTime - loginTime >= 30000L) continue;
                        ClusterEvent cevent = this.event.clone();
                        events.add(cevent);
                        SendMqttMsgTask task = new SendMqttMsgTask(serverhandle, cevent, this.systemCode);
                        taskList.add(task);
                    }
                    ExecutorService service = RemoteConnectionManager.getConntctionService((String)remoteServerBean.getUrl());
                    switch (this.event.getSequence()) {
                        case FIRST: {
                            service.submit((Callable)taskList.get(0)).get();
                            break;
                        }
                        case MEANWHILE: {
                            List tasks = service.invokeAll(taskList);
                            for (Future future : tasks) {
                                future.get();
                            }
                            continue block7;
                        }
                        case SEQUENCE: {
                            SendMqttMsgTask task;
                            Boolean result;
                            Iterator iterator = taskList.iterator();
                            while (iterator.hasNext() && (result = service.submit(task = (SendMqttMsgTask)iterator.next()).get()) != null && result.booleanValue()) {
                            }
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return events;
    }
}

