/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.udp;

import com.ds.cluster.ServerNode;
import com.ds.cluster.udp.ClusterEvent;
import com.ds.engine.ConnectInfo;
import com.ds.engine.JDSSessionHandle;
import com.ds.org.Person;
import com.ds.server.JDSServer;
import com.ds.server.JDSUDPServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.udp.SendEventMsgTask;
import com.ds.web.RemoteConnectionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class UDPServerEventTask
implements Callable<List<ClusterEvent>> {
    private final String systemCode;
    private final ClusterEvent event;

    public UDPServerEventTask(String systemCode, ClusterEvent event) {
        this.systemCode = systemCode;
        this.event = event;
    }

    @Override
    public List<ClusterEvent> call() throws Exception {
        ArrayList<ClusterEvent> events = new ArrayList<ClusterEvent>();
        ServerNode remoteServerBean = JDSServer.getClusterClient().getServerNodeById(this.systemCode);
        if (remoteServerBean != null) {
            Set personIds = remoteServerBean.getAdminPersonIds();
            Set<String> personSetIds = JDSUDPServer.getInstance().getRepeatPersonEventKey(this.systemCode, this.event.getExpression());
            personIds.addAll(personSetIds);
            block7: for (String personId : personIds) {
                try {
                    if (personId == null) continue;
                    Person toPerson = OrgManagerFactory.getOrgManager().getPersonByID(personId);
                    ConnectInfo connInfo = new ConnectInfo(toPerson.getID(), toPerson.getAccount(), toPerson.getPassword());
                    Set sessionHandleList = JDSServer.getInstance().getSessionHandleList(connInfo);
                    if (sessionHandleList == null || sessionHandleList.size() <= 0) continue;
                    ArrayList<SendEventMsgTask> taskList = new ArrayList<SendEventMsgTask>();
                    for (JDSSessionHandle serverhandle : sessionHandleList) {
                        long currentTime = System.currentTimeMillis();
                        Long loginTime = (Long)JDSServer.getInstance().getConnectTimeCache().get((Object)serverhandle.toString());
                        if (loginTime == null || currentTime - loginTime >= 30000L) continue;
                        ClusterEvent cevent = this.event.clone();
                        events.add(cevent);
                        SendEventMsgTask task = new SendEventMsgTask(serverhandle, cevent, this.systemCode);
                        taskList.add(task);
                    }
                    ExecutorService service = RemoteConnectionManager.getConntctionService((String)remoteServerBean.getUrl());
                    switch (this.event.getSequence()) {
                        case FIRST: {
                            service.submit((Callable)taskList.get(0)).get();
                            break;
                        }
                        case MEANWHILE: {
                            List tasks = service.invokeAll(taskList);
                            for (Future future : tasks) {
                                future.get();
                            }
                            continue block7;
                        }
                        case SEQUENCE: {
                            SendEventMsgTask task;
                            Boolean result;
                            Iterator iterator = taskList.iterator();
                            while (iterator.hasNext() && (result = service.submit(task = (SendEventMsgTask)iterator.next()).get()) != null && result.booleanValue()) {
                            }
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return events;
    }
}

