/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.udp;

import com.alibaba.fastjson.JSONObject;
import com.ds.cluster.udp.ClusterEvent;
import com.ds.common.ConfigCode;
import com.ds.common.JDSException;
import com.ds.common.MsgStatus;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.engine.ConnectionHandle;
import com.ds.engine.JDSSessionHandle;
import com.ds.server.JDSClientService;
import com.ds.server.JDSServer;
import com.ds.server.udp.AbstractUDPHandle;
import com.ds.web.ConnectionLogFactory;
import com.ds.web.RuntimeLog;
import java.util.ArrayList;
import java.util.concurrent.Callable;

class SendEventMsgTask
implements Callable<Boolean> {
    private final JDSSessionHandle serverhandle;
    private final ClusterEvent cloneevent;
    private final String sysCode;
    private static final Log logger = LogFactory.getLog((String)"JDS", SendEventMsgTask.class);

    SendEventMsgTask(JDSSessionHandle serverhandle, ClusterEvent cloneevent, String sysCode) {
        this.serverhandle = serverhandle;
        this.cloneevent = cloneevent;
        this.sysCode = sysCode;
        logger.info((Object)("SendEventMsgTask expression=" + cloneevent.getExpression() + " sysCode=" + sysCode));
    }

    @Override
    public Boolean call() {
        block14: {
            ArrayList<String> portList = new ArrayList<String>();
            try {
                JDSClientService client = JDSServer.getInstance().getJDSClientService(this.serverhandle, ConfigCode.app);
                ConnectionHandle cnnectionHandle = client.getConnectionHandle();
                if (!(cnnectionHandle instanceof AbstractUDPHandle)) break block14;
                AbstractUDPHandle udpCnnectionHandle = (AbstractUDPHandle)client.getConnectionHandle();
                String key = udpCnnectionHandle.getIp() + ":" + udpCnnectionHandle.getPort();
                logger.info((Object)("sendEvent to " + this.serverhandle.getIp() + ":" + this.serverhandle.getPort() + "[" + this.serverhandle.getSessionID() + "] event=" + this.cloneevent.getEventName() + "[" + this.cloneevent.getEventId() + "]"));
                if (client.getConnectInfo() == null || portList.contains(key) || udpCnnectionHandle.getIp() == null) break block14;
                String msgId = this.cloneevent.getMsgId();
                String token = this.cloneevent.getToken();
                RuntimeLog log = ConnectionLogFactory.getInstance().createLog(token, "UDP://" + key + ":[" + this.sysCode + "]", this.cloneevent.getEventName() + "[" + this.cloneevent.getEventId() + "]", msgId);
                String eventStr = JSONObject.toJSONString((Object)this.cloneevent);
                log.setStartTime(System.currentTimeMillis());
                log.setRequestJson(eventStr);
                client.getConnectionHandle().send(eventStr);
                portList.add(key);
                for (int k = 0; log.getStatus().equals((Object)MsgStatus.NORMAL) && k < this.cloneevent.getTimeout(); k += k * 5) {
                    try {
                        Thread.sleep(5L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (log.getStatus().equals((Object)MsgStatus.NORMAL)) {
                    int times = 1;
                    switch (this.cloneevent.getDeadLine()) {
                        case GOON: {
                            return true;
                        }
                        case STOP: {
                            return false;
                        }
                        case DELAY: {
                            while (log.getStatus().equals((Object)MsgStatus.NORMAL) && times < this.cloneevent.getMaxtimes()) {
                                logger.info((Object)("msg timeout  =======serverhandle=" + this.serverhandle + " ip:port=" + ((AbstractUDPHandle)client.getConnectionHandle()).getIp() + ((AbstractUDPHandle)client.getConnectionHandle()).getPort()));
                                client.getConnectionHandle().send(eventStr);
                                ++times;
                                try {
                                    Thread.sleep(this.cloneevent.getTimeout().intValue());
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            break block14;
                        }
                        default: {
                            return true;
                        }
                    }
                }
                return true;
            }
            catch (JDSException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

