/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.nioproxy.handle;

import com.ds.server.httpproxy.nioproxy.handle.ProxyHttpExchange;
import com.ds.server.httpproxy.nioproxy.handle.ProxyResponseProducer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.BasicAsyncResponseProducer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.protocol.HttpContext;

public class ProxyResponseConsumer
implements HttpAsyncResponseConsumer<ProxyHttpExchange> {
    private final ProxyHttpExchange httpExchange;
    private volatile boolean completed;

    public ProxyResponseConsumer(ProxyHttpExchange httpExchange) {
        this.httpExchange = httpExchange;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseReceived(HttpResponse response) {
        ProxyHttpExchange proxyHttpExchange = this.httpExchange;
        synchronized (proxyHttpExchange) {
            this.httpExchange.setResponse(response);
            HttpAsyncExchange responseTrigger = this.httpExchange.getResponseTrigger();
            if (responseTrigger != null && !responseTrigger.isCompleted()) {
                responseTrigger.submitResponse((HttpAsyncResponseProducer)new ProxyResponseProducer(this.httpExchange));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        ProxyHttpExchange proxyHttpExchange = this.httpExchange;
        synchronized (proxyHttpExchange) {
            this.httpExchange.setOriginIOControl(ioctrl);
            ByteBuffer buf = this.httpExchange.getOutBuffer();
            int n = decoder.read(buf);
            if (decoder.isCompleted()) {
                // empty if block
            }
            if (!buf.hasRemaining()) {
                ioctrl.suspendInput();
            }
            if (buf.position() > 0 && this.httpExchange.getClientIOControl() != null) {
                this.httpExchange.getClientIOControl().requestOutput();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseCompleted(HttpContext context) {
        ProxyHttpExchange proxyHttpExchange = this.httpExchange;
        synchronized (proxyHttpExchange) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            this.httpExchange.setResponseReceived();
            if (this.httpExchange.getClientIOControl() != null) {
                this.httpExchange.getClientIOControl().requestOutput();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(Exception ex) {
        ProxyHttpExchange proxyHttpExchange = this.httpExchange;
        synchronized (proxyHttpExchange) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            this.httpExchange.setException(ex);
            HttpAsyncExchange responseTrigger = this.httpExchange.getResponseTrigger();
            if (responseTrigger != null && !responseTrigger.isCompleted()) {
                int status = 500;
                BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, status, EnglishReasonPhraseCatalog.INSTANCE.getReason(status, Locale.US));
                String message = ex.getMessage();
                if (message == null) {
                    message = "Unexpected error";
                }
                response.setEntity((HttpEntity)new NStringEntity(message, ContentType.DEFAULT_TEXT));
                responseTrigger.submitResponse((HttpAsyncResponseProducer)new BasicAsyncResponseProducer((HttpResponse)response));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        ProxyHttpExchange proxyHttpExchange = this.httpExchange;
        synchronized (proxyHttpExchange) {
            if (this.completed) {
                return false;
            }
            this.failed(new InterruptedIOException("Cancelled"));
            return true;
        }
    }

    public ProxyHttpExchange getResult() {
        return this.httpExchange;
    }

    public Exception getException() {
        return null;
    }

    public boolean isDone() {
        return this.completed;
    }
}

