/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.nioproxy;

import com.ds.config.UserBean;
import com.ds.server.JDSServer;
import com.ds.server.httpproxy.ServerProxyFactory;
import com.ds.server.httpproxy.nioproxy.ProxyConnPool;
import com.ds.server.httpproxy.nioproxy.ProxyIncomingConnectionReuseStrategy;
import com.ds.server.httpproxy.nioproxy.ProxyOutgoingConnectionReuseStrategy;
import com.ds.server.httpproxy.nioproxy.handle.HeadReponse;
import com.ds.server.httpproxy.nioproxy.handle.ProxyClientProtocolHandler;
import com.ds.server.httpproxy.nioproxy.handle.ProxyRequestHandler;
import com.ds.server.httpproxy.nioproxy.handle.ProxyServiceHandler;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.protocol.RequestAddCookies;
import org.apache.http.client.protocol.RequestClientConnControl;
import org.apache.http.client.protocol.ResponseProcessCookies;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.nio.DefaultHttpClientIODispatch;
import org.apache.http.impl.nio.DefaultHttpServerIODispatch;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandlerMapper;
import org.apache.http.nio.protocol.HttpAsyncRequester;
import org.apache.http.nio.protocol.UriHttpAsyncRequestHandlerMapper;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;

public class ProxyServer {
    private DefaultConnectingIOReactor connectingIOReactor;
    private DefaultHttpClientIODispatch connectingEventDispatch;
    private DefaultListeningIOReactor listeningIOReactor;
    private DefaultHttpServerIODispatch listeningEventDispatch;
    private int port;
    public int sotimeout = 120000;
    public int connectiontimeout = 60000;
    public int maxTol = 1000;
    public int maxPerRoute = 500;
    private UriHttpAsyncRequestHandlerMapper handlerRegistry;

    public ProxyServer(int port) throws IOReactorException {
        this.port = port;
        ImmutableHttpProcessor inhttpproc = new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer("JDS-ESD Server"), new ResponseContent(), new ResponseConnControl(), new HeadReponse(), new ResponseProcessCookies()});
        ImmutableHttpProcessor outhttpproc = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestClientConnControl(), new RequestTargetHost(), new RequestConnControl(), new RequestAddCookies(), new RequestExpectContinue()});
        IOReactorConfig config = IOReactorConfig.custom().setSoTimeout(this.sotimeout).setConnectTimeout(this.connectiontimeout).build();
        this.connectingIOReactor = new DefaultConnectingIOReactor(config);
        this.listeningIOReactor = new DefaultListeningIOReactor(config);
        ProxyConnPool connPool = new ProxyConnPool((ConnectingIOReactor)this.connectingIOReactor, ConnectionConfig.DEFAULT);
        connPool.setMaxTotal(this.maxTol);
        connPool.setDefaultMaxPerRoute(this.maxPerRoute);
        ProxyClientProtocolHandler clientHandler = new ProxyClientProtocolHandler();
        HttpAsyncRequester executor = new HttpAsyncRequester((HttpProcessor)outhttpproc, (ConnectionReuseStrategy)new ProxyOutgoingConnectionReuseStrategy());
        this.handlerRegistry = new UriHttpAsyncRequestHandlerMapper();
        this.handlerRegistry.register("*", (HttpAsyncRequestHandler)new ProxyRequestHandler(executor, connPool));
        ProxyServiceHandler serviceHandler = new ProxyServiceHandler((HttpProcessor)inhttpproc, (ConnectionReuseStrategy)new ProxyIncomingConnectionReuseStrategy(), (HttpAsyncRequestHandlerMapper)this.handlerRegistry);
        this.connectingEventDispatch = new DefaultHttpClientIODispatch((NHttpClientEventHandler)clientHandler, ConnectionConfig.DEFAULT);
        this.listeningEventDispatch = new DefaultHttpServerIODispatch((NHttpServerEventHandler)serviceHandler, ConnectionConfig.DEFAULT);
    }

    public void start() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProxyServer.this.connectingIOReactor.execute((IOEventDispatch)ProxyServer.this.connectingEventDispatch);
                }
                catch (InterruptedIOException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        ProxyServer.this.listeningIOReactor.shutdown();
                    }
                    catch (IOException ex2) {
                        ex2.printStackTrace();
                    }
                }
            }
        });
        t.start();
        try {
            this.listeningIOReactor.listen((SocketAddress)new InetSocketAddress(this.port));
            this.listeningIOReactor.execute((IOEventDispatch)this.listeningEventDispatch);
        }
        catch (InterruptedIOException ex2) {
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                this.connectingIOReactor.shutdown();
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
        }
    }

    public void stop() {
        try {
            this.connectingIOReactor.shutdown();
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
        }
    }

    public DefaultHttpClientIODispatch getConnectingEventDispatch() {
        return this.connectingEventDispatch;
    }

    public void setConnectingEventDispatch(DefaultHttpClientIODispatch connectingEventDispatch) {
        this.connectingEventDispatch = connectingEventDispatch;
    }

    public DefaultConnectingIOReactor getConnectingIOReactor() {
        return this.connectingIOReactor;
    }

    public void setConnectingIOReactor(DefaultConnectingIOReactor connectingIOReactor) {
        this.connectingIOReactor = connectingIOReactor;
    }

    public int getConnectiontimeout() {
        return this.connectiontimeout;
    }

    public void setConnectiontimeout(int connectiontimeout) {
        this.connectiontimeout = connectiontimeout;
    }

    public DefaultHttpServerIODispatch getListeningEventDispatch() {
        return this.listeningEventDispatch;
    }

    public void setListeningEventDispatch(DefaultHttpServerIODispatch listeningEventDispatch) {
        this.listeningEventDispatch = listeningEventDispatch;
    }

    public DefaultListeningIOReactor getListeningIOReactor() {
        return this.listeningIOReactor;
    }

    public void setListeningIOReactor(DefaultListeningIOReactor listeningIOReactor) {
        this.listeningIOReactor = listeningIOReactor;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getSotimeout() {
        return this.sotimeout;
    }

    public void setSotimeout(int sotimeout) {
        this.sotimeout = sotimeout;
    }

    public UriHttpAsyncRequestHandlerMapper getHandlerRegistry() {
        return this.handlerRegistry;
    }

    public void setHandlerRegistry(UriHttpAsyncRequestHandlerMapper handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
    }

    public int getMaxPerRoute() {
        return this.maxPerRoute;
    }

    public void setMaxPerRoute(int maxPerRoute) {
        this.maxPerRoute = maxPerRoute;
    }

    public int getMaxTol() {
        return this.maxTol;
    }

    public void setMaxTol(int maxTol) {
        this.maxTol = maxTol;
    }

    public static void main(String[] args) throws Exception {
        JDSServer.getInstance();
        ServerProxyFactory.getInstance();
        Integer port = UserBean.getInstance().getProxyPort();
        new ProxyServer(port).start();
    }
}

