/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.handler.cls;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.config.JDSUtil;
import com.ds.context.JDSActionContext;
import com.ds.server.httpproxy.core.AbstractHandler;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.Handler;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import com.ds.server.httpproxy.handler.ResourceHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;

public class ClsDispatcherHandle
extends AbstractHandler
implements Handler {
    private static final Log log = LogFactory.getLog((String)"JDS", ResourceHandler.class);
    public static final ConfigOption RULE_OPTION = new ConfigOption("rule", true, "Regular expression for matching URLs.");
    public static final ConfigOption RESOURCE_MOUNT_OPTION = new ConfigOption("resourceMount", "/", "A path within the classpath to the root of the folder to share.");
    Pattern rule;
    private String resourceMount;

    @Override
    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        this.rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
        this.resourceMount = RESOURCE_MOUNT_OPTION.getProperty(server, handlerName);
        return true;
    }

    @Override
    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        String path = request.getPath();
        boolean ruleMatches = this.rule.matcher(path).matches();
        if (!ruleMatches || !request.getMethod().toUpperCase().equals("GET")) {
            return false;
        }
        String projectName = this.getProjectName(request);
        String className = this.formatPath(request.getUrl(), projectName);
        if (className.indexOf("/") > -1) {
            return false;
        }
        if (projectName.indexOf("VVVERSION") > -1) {
            projectName = projectName.split("VVVERSION")[0];
        }
        ArrayList cssList = new ArrayList();
        File file = new File(JDSUtil.getJdsRealPath() + File.separator + "webapp/" + projectName + "/css");
        if (!file.exists()) {
            file = new File(JDSUtil.getJdsRealPath() + "export/" + projectName + "/css");
        }
        if (file.exists() && file.isDirectory()) {
            File[] files;
            for (File ifile : files = file.listFiles()) {
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("path", "css/" + ifile.getName());
                cssList.add(values);
            }
        }
        JDSActionContext.getActionContext().getContext().put("cssList", cssList);
        JDSActionContext.getActionContext().getContext().put("projectName", projectName);
        JDSActionContext.getActionContext().getContext().put("className", className.substring(0, className.length() - ".cls".length()));
        this.sendFtl(request, response, this.resourceMount + "/ftl/cls.ftl");
        return true;
    }
}

