/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.handler;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.config.JDSUtil;
import com.ds.server.httpproxy.core.AbstractHandler;
import com.ds.server.httpproxy.core.Handler;
import com.ds.server.httpproxy.core.Http;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.regex.Pattern;

public class SystemResourceHandler
extends AbstractHandler
implements Handler {
    private static final Log log = LogFactory.getLog((String)"JDS", SystemResourceHandler.class);
    private String resourceMount;
    private String defaultResource;
    Pattern rule;

    @Override
    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        this.resourceMount = RESOURCE_MOUNT_OPTION.getProperty(server, handlerName);
        this.defaultResource = DEFAULT_RESOURCE_OPTION.getProperty(server, handlerName);
        this.rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
        return true;
    }

    @Override
    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        boolean ruleMatches = this.rule.matcher(request.getPath()).matches();
        if (!ruleMatches) {
            return false;
        }
        String path = request.getPath();
        String resource = Http.join(this.resourceMount, path.substring(this.getUrlPrefix().length()));
        if (resource.endsWith("/")) {
            resource = resource + this.defaultResource;
        } else if (resource.lastIndexOf(46) < 0) {
            resource = resource + "/" + this.defaultResource;
        }
        log.info((Object)("Loading resource: " + resource));
        String mimeType = this.getMimeType(resource);
        File file = new File(JDSUtil.getJdsRealPath() + resource);
        if (!file.exists()) {
            file = new File(JDSUtil.getJdsRealPath() + "xui/" + resource);
        }
        if (mimeType == null) {
            log.warn((Object)("mime type was not understood.(Found file=" + file.getAbsolutePath() + ")"));
            return false;
        }
        if (file.exists()) {
            FileInputStream is = new FileInputStream(file);
            if (is != null) {
                response.setMimeType(mimeType);
                response.sendResponse(is, Integer.valueOf(Long.toString(file.length())));
                return true;
            }
            return false;
        }
        return false;
    }
}

