/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.handler;

import com.ds.server.httpproxy.core.AbstractHandler;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StatsHandler
extends AbstractHandler {
    public static final ConfigOption FILE_OPTION = new ConfigOption("file", "stats.log", "File name for the stats.");
    private String filename;
    private Map statsMap = Collections.synchronizedMap(new HashMap());

    @Override
    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        this.filename = FILE_OPTION.getProperty(server, this.getName());
        return true;
    }

    @Override
    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        UrlStatistics stats = (UrlStatistics)this.statsMap.get(request.getUrl());
        if (stats == null) {
            stats = new UrlStatistics(System.currentTimeMillis());
            this.statsMap.put(request.getUrl(), stats);
        } else {
            stats.lastTime = System.currentTimeMillis();
        }
        stats.increment();
        this.saveStatistics();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveStatistics() throws IOException {
        try (BufferedWriter file = new BufferedWriter(new FileWriter(this.filename));){
            for (String url : this.statsMap.keySet()) {
                UrlStatistics stats;
                UrlStatistics urlStatistics = stats = (UrlStatistics)this.statsMap.get(url);
                synchronized (urlStatistics) {
                    file.write(url + " " + stats.count() + " " + stats.getFirstTime() + " " + stats.getLastTime() + "\n");
                }
            }
            return;
        }
    }

    public static class UrlStatistics {
        private long lastTime;
        private int count;
        private long firstTime;

        public UrlStatistics(long currentTime) {
            this.firstTime = currentTime;
            this.lastTime = currentTime;
        }

        public synchronized void lastTime(long currentTime) {
            this.lastTime = currentTime;
        }

        public synchronized void increment() {
            ++this.count;
        }

        public synchronized long getFirstTime() {
            return this.firstTime;
        }

        public synchronized long getLastTime() {
            return this.lastTime;
        }

        public synchronized int count() {
            return this.count;
        }
    }
}

