/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.handler;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.server.httpproxy.core.AbstractHandler;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.Handler;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.Request;
import com.ds.server.httpproxy.core.Response;
import com.ds.server.httpproxy.core.Server;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class DefaultChainHandler
extends AbstractHandler
implements Handler {
    private static final Log log = LogFactory.getLog((String)"JDS", DefaultChainHandler.class);
    public static String CHAIN = ".chain";
    public static final ConfigOption CHAIN_OPTION = new ConfigOption("chain", true, "A comma seperated list of handler names to chain together.");
    private List chain;

    @Override
    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        this.chain = new ArrayList();
        this.initializeChain(server);
        return true;
    }

    private void initializeChain(Server server) {
        StringTokenizer tokenizer = new StringTokenizer(CHAIN_OPTION.getProperty(server, this.handlerName), " ,");
        while (tokenizer.hasMoreTokens()) {
            String chainChildName = tokenizer.nextToken();
            try {
                Handler handler = (Handler)server.constructJdsObject(chainChildName);
                if (handler.initialize(chainChildName, server)) {
                    this.chain.add(handler);
                    continue;
                }
                log.info((Object)(chainChildName + " was not initialized"));
            }
            catch (ClassCastException e) {
                log.error((Object)(chainChildName + " class does not implement the Handler interface."), (Throwable)e);
            }
        }
    }

    @Override
    public boolean handle(Request request, Response response) throws IOException {
        String[] pattens;
        boolean hasBeenHandled = false;
        long time = System.currentTimeMillis();
        Iterator i = this.chain.iterator();
        while (i.hasNext() && !hasBeenHandled) {
            Handler handler = (Handler)i.next();
            hasBeenHandled = handler.handle(request, response);
        }
        if (!hasBeenHandled && request instanceof HttpRequest) {
            log.warn((Object)("error  request  path" + ((HttpRequest)request).getPath()));
        }
        String path = ((HttpRequest)request).getPath();
        boolean isDefault = true;
        for (String patten : pattens = new String[]{".js", ".css", ".jpg", ".gif"}) {
            if (!path.endsWith(patten)) continue;
            isDefault = false;
        }
        if (isDefault) {
            log.info((Object)(((HttpRequest)request).getPath() + " time=" + (System.currentTimeMillis() - time) + "ms"));
        }
        return hasBeenHandled;
    }

    @Override
    public boolean shutdown(Server server) {
        boolean success = true;
        if (this.chain != null) {
            for (Handler current : this.chain) {
                boolean currentSuccess = current.shutdown(server);
                success = success && currentSuccess;
            }
        }
        return success;
    }
}

